package pl.codewise.commons.aws.cqrs.model;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class AwsPrivateIpAddress {

    private final String privateIpAddress;
    private final AwsPrivateIpAddressAssociation association;

    public AwsPrivateIpAddress(String privateIpAddress, AwsPrivateIpAddressAssociation association) {
        this.privateIpAddress = privateIpAddress;
        this.association = association;
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsPrivateIpAddress that = (AwsPrivateIpAddress) o;
        return Objects.equal(privateIpAddress, that.privateIpAddress) &&
                Objects.equal(association, that.association);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(privateIpAddress, association);
    }

    public String getPrivateIpAddress() {
        return privateIpAddress;
    }

    public AwsPrivateIpAddressAssociation getAssociation() {
        return association;
    }

    public static class Builder {

        private String privateIpAddress;
        private AwsPrivateIpAddressAssociation association;

        public Builder withPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public Builder withAssociation(AwsPrivateIpAddressAssociation association) {
            this.association = association;
            return this;
        }

        public AwsPrivateIpAddress build() {
            return new AwsPrivateIpAddress(privateIpAddress, association);
        }
    }
}
