package pl.codewise.commons.aws.cqrs.model;

import com.google.common.base.MoreObjects;

import java.util.Objects;

public abstract class AwsNameBasedResource implements AwsResource {

    private final String name;

    public AwsNameBasedResource(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsNameBasedResource that = (AwsNameBasedResource) o;
        return Objects.equals(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("name", name)
                .toString();
    }
}
