package pl.codewise.commons.aws.cqrs.model;

import com.google.common.base.MoreObjects;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsAutoScalingTag;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AwsAutoScalingGroup implements AwsResource {

    private final String autoScalingGroupName;
    private final List<AwsInstance> awsInstances;
    private final List<String> loadBalancerNames;
    private final List<String> targetGroupArns;
    private final Integer desiredCapacity;
    private final Integer minSize;
    private final Integer maxSize;
    private final Date created;
    private final String launchConfigurationName;
    private final Integer defaultCooldown;
    private final List<String> availabilityZones;
    private final String healthCheckType;
    private final Integer healthCheckGracePeriod;
    private final String placementGroup;
    private final String VPCZoneIdentifier;
    private final Boolean newInstancesProtectedFromScaleIn;
    private final List<AwsAutoScalingTag> tags;
    private final List<String> terminationPolicies;
    private final List<String> suspendedProcesses;

    private AwsAutoScalingGroup(String autoScalingGroupName, List<AwsInstance> awsInstances,
            List<String> loadBalancerNames, List<String> targetGroupArns, Integer desiredCapacity,
            Integer minSize, Integer maxSize, Date created,
            String launchConfigurationName, Integer defaultCooldown, List<String> availabilityZones,
            String healthCheckType, Integer healthCheckGracePeriod, String placementGroup, String vpcZoneIdentifier,
            Boolean newInstancesProtectedFromScaleIn, List<AwsAutoScalingTag> tags,
            List<String> terminationPolicies, List<String> suspendedProcesses) {
        this.autoScalingGroupName = autoScalingGroupName;
        this.awsInstances = awsInstances;
        this.loadBalancerNames = loadBalancerNames;
        this.targetGroupArns = targetGroupArns;
        this.desiredCapacity = desiredCapacity;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.created = created;
        this.launchConfigurationName = launchConfigurationName;
        this.defaultCooldown = defaultCooldown;
        this.availabilityZones = availabilityZones;
        this.healthCheckType = healthCheckType;
        this.healthCheckGracePeriod = healthCheckGracePeriod;
        this.placementGroup = placementGroup;
        this.VPCZoneIdentifier = vpcZoneIdentifier;
        this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        this.tags = tags;
        this.terminationPolicies = terminationPolicies;
        this.suspendedProcesses = suspendedProcesses;
    }

    public String getAutoScalingGroupName() {
        return autoScalingGroupName;
    }

    public List<AwsInstance> getAwsInstances() {
        return awsInstances;
    }

    public List<String> getLoadBalancerNames() {
        return loadBalancerNames;
    }

    public List<String> getTargetGroupArns() {
        return targetGroupArns;
    }

    public Integer getDesiredCapacity() {
        return desiredCapacity;
    }

    public Integer getMinSize() {
        return minSize;
    }

    public Integer getMaxSize() {
        return maxSize;
    }

    public Date getCreated() {
        return created;
    }

    public String getLaunchConfigurationName() {
        return launchConfigurationName;
    }

    public Integer getDefaultCooldown() {
        return defaultCooldown;
    }

    public List<String> getAvailabilityZones() {
        return availabilityZones;
    }

    public String getHealthCheckType() {
        return healthCheckType;
    }

    public Integer getHealthCheckGracePeriod() {
        return healthCheckGracePeriod;
    }

    public String getPlacementGroup() {
        return placementGroup;
    }

    public String getVPCZoneIdentifier() {
        return VPCZoneIdentifier;
    }

    public Boolean isNewInstancesProtectedFromScaleIn() {
        return newInstancesProtectedFromScaleIn;
    }

    public List<AwsAutoScalingTag> getTags() {
        return tags;
    }

    public List<String> getTerminationPolicies() {
        return terminationPolicies;
    }

    public List<String> getSuspendedProcesses() {
        return suspendedProcesses;
    }

    @Override
    public String getId() {
        return autoScalingGroupName;
    }

    @Override
    public void accept(AwsResourceVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsAutoScalingGroup that = (AwsAutoScalingGroup) o;
        return Objects.equals(autoScalingGroupName, that.autoScalingGroupName) &&
                Objects.equals(awsInstances, that.awsInstances) &&
                Objects.equals(loadBalancerNames, that.loadBalancerNames) &&
                Objects.equals(desiredCapacity, that.desiredCapacity) &&
                Objects.equals(minSize, that.minSize) &&
                Objects.equals(maxSize, that.maxSize) &&
                Objects.equals(created, that.created) &&
                Objects.equals(launchConfigurationName, that.launchConfigurationName) &&
                Objects.equals(defaultCooldown, that.defaultCooldown) &&
                Objects.equals(availabilityZones, that.availabilityZones) &&
                Objects.equals(healthCheckType, that.healthCheckType) &&
                Objects.equals(healthCheckGracePeriod, that.healthCheckGracePeriod) &&
                Objects.equals(placementGroup, that.placementGroup) &&
                Objects.equals(VPCZoneIdentifier, that.VPCZoneIdentifier) &&
                Objects.equals(newInstancesProtectedFromScaleIn, that.newInstancesProtectedFromScaleIn) &&
                Objects.equals(tags, that.tags) &&
                Objects.equals(terminationPolicies, that.terminationPolicies);
    }

    @Override
    public int hashCode() {
        return Objects
                .hash(autoScalingGroupName, awsInstances, loadBalancerNames, desiredCapacity, minSize, maxSize, created,
                        launchConfigurationName, defaultCooldown, availabilityZones, healthCheckType,
                        healthCheckGracePeriod, placementGroup, VPCZoneIdentifier, newInstancesProtectedFromScaleIn,
                        tags, terminationPolicies);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("autoScalingGroupName", autoScalingGroupName)
                .add("awsInstances", awsInstances)
                .add("loadBalancerNames", loadBalancerNames)
                .add("desiredCapacity", desiredCapacity)
                .add("minSize", minSize)
                .add("maxSize", maxSize)
                .add("created", created)
                .add("launchConfigurationName", launchConfigurationName)
                .add("defaultCooldown", defaultCooldown)
                .add("availabilityZones", availabilityZones)
                .add("healthCheckType", healthCheckType)
                .add("healthCheckGracePeriod", healthCheckGracePeriod)
                .add("placementGroup", placementGroup)
                .add("VPCZoneIdentifier", VPCZoneIdentifier)
                .add("newInstancesProtectedFromScaleIn", newInstancesProtectedFromScaleIn)
                .add("tags", tags)
                .add("terminationPolicies", terminationPolicies)
                .toString();
    }

    public Builder toBuilder() {
        return new Builder()
                .withAutoScalingGroupName(autoScalingGroupName)
                .withAwsInstances(awsInstances)
                .withLoadBalancerNames(loadBalancerNames)
                .withDesiredCapacity(desiredCapacity)
                .withMinSize(minSize)
                .withMaxSize(maxSize)
                .withCreated(created)
                .withLaunchConfigurationName(launchConfigurationName)
                .withDefaultCooldown(defaultCooldown)
                .withAvailabilityZones(availabilityZones)
                .withHealthCheckType(healthCheckType)
                .withHealthCheckGracePeriod(healthCheckGracePeriod)
                .withPlacementGroup(placementGroup)
                .withVpcZoneIdentifier(VPCZoneIdentifier)
                .withNewInstancesProtectedFromScaleIn(newInstancesProtectedFromScaleIn)
                .withTags(tags)
                .withTerminationPolicies(terminationPolicies);
    }

    public static class Builder {

        private String autoScalingGroupName;
        private List<AwsInstance> awsInstances = Collections.emptyList();
        private List<String> loadBalancerNames = Collections.emptyList();
        private List<String> targetGroupArns = Collections.emptyList();
        private Integer desiredCapacity;
        private Integer minSize;
        private Integer maxSize;
        private Date created;
        private String launchConfigurationName;
        private Integer defaultCooldown;
        private List<String> availabilityZones = Collections.emptyList();
        private String healthCheckType;
        private Integer healthCheckGracePeriod;
        private String placementGroup;
        private String vpcZoneIdentifier;
        private Boolean newInstancesProtectedFromScaleIn;
        private List<AwsAutoScalingTag> tags = Collections.emptyList();
        private List<String> terminationPolicies = Collections.emptyList();
        private List<String> suspendedProcesses = Collections.emptyList();

        public Builder withAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public Builder withAwsInstances(List<AwsInstance> awsInstances) {
            this.awsInstances = awsInstances != null ? awsInstances : Collections.emptyList();
            return this;
        }

        public Builder withLoadBalancerNames(List<String> loadBalancerNames) {
            this.loadBalancerNames = loadBalancerNames;
            return this;
        }

        public Builder withTargetGroupArns(List<String> targetGroupArns) {
            this.targetGroupArns = targetGroupArns;
            return this;
        }

        public Builder withDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public Builder withMinSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public Builder withMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder withCreated(Date created) {
            this.created = created;
            return this;
        }

        public Builder withLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public Builder withDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public Builder withAvailabilityZones(List<String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        public Builder withHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public Builder withHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public Builder withPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public Builder withVpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public Builder withNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public Builder withTags(List<AwsAutoScalingTag> tags) {
            this.tags = tags;
            return this;
        }

        public Builder withTerminationPolicies(List<String> terminationPolicies) {
            this.terminationPolicies = terminationPolicies;
            return this;
        }

        public Builder withSuspendedProcesses(List<String> processes) {
            this.suspendedProcesses = processes;
            return this;
        }

        public AwsAutoScalingGroup build() {
            return new AwsAutoScalingGroup(autoScalingGroupName, awsInstances, loadBalancerNames, targetGroupArns,
                    desiredCapacity, minSize, maxSize, created, launchConfigurationName, defaultCooldown,
                    availabilityZones, healthCheckType, healthCheckGracePeriod, placementGroup, vpcZoneIdentifier,
                    newInstancesProtectedFromScaleIn, tags, terminationPolicies, suspendedProcesses);
        }
    }
}
