package pl.codewise.commons.aws.cqrs.factories;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53domains.AmazonRoute53Domains;
import com.amazonaws.services.s3.AmazonS3;

import java.util.function.Function;

public interface ClientConstructors {

    Function<AWSCredentialsProvider, AmazonS3> s3();

    Function<AWSCredentialsProvider, AmazonIdentityManagement> iam();

    Function<AWSCredentialsProvider, AmazonEC2> ec2();

    Function<AWSCredentialsProvider, AmazonAutoScaling> autoScaling();

    Function<AWSCredentialsProvider, AWSLambda> awsLambda();

    Function<AWSCredentialsProvider, AmazonElasticLoadBalancing> amazonElasticLoadBalancing();

    Function<AWSCredentialsProvider, com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing>
    applicationLoadBalancing();

    Function<AWSCredentialsProvider, AmazonCloudWatch> amazonCloudWatch();

    Function<AWSCredentialsProvider, AmazonRoute53> amazonRoute53();

    Function<AWSCredentialsProvider, AmazonRoute53Domains> amazonRoute53Domains();
}
