package pl.codewise.commons.aws.cqrs.discovery.route53.domains;

import com.google.common.util.concurrent.RateLimiter;

public class Route53DomainsSettings {

    private final int timeoutMillis;
    private final int pollIntervalMillis;
    private final RateLimiter rateLimiter;

    public Route53DomainsSettings(
            int timeoutMillis,
            int pollIntervalMillis,
            RateLimiter rateLimiter) {
        this.timeoutMillis = timeoutMillis;
        this.pollIntervalMillis = pollIntervalMillis;
        this.rateLimiter = rateLimiter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Route53DomainsSettings defaultSettings() {
        return new Builder().build();
    }

    public int getTimeoutMillis() {
        return timeoutMillis;
    }

    public int getPollIntervalMillis() {
        return pollIntervalMillis;
    }

    public RateLimiter getRateLimiter() {
        return rateLimiter;
    }

    public static class Builder {

        private int timeoutMillis = 1000;
        private int pollIntervalMillis = 100;
        private RateLimiter rateLimiter;

        public Builder setTimeoutMillis(int timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public Builder setPollIntervalMillis(int pollIntervalMillis) {
            this.pollIntervalMillis = pollIntervalMillis;
            return this;
        }

        public Builder setRateLimiter(RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
            return this;
        }

        public Route53DomainsSettings build() {
            return new Route53DomainsSettings(timeoutMillis, pollIntervalMillis, rateLimiter);
        }
    }
}
