package pl.codewise.commons.aws;

public class EnvironmentAwareProviderFactory {

    public static ZoneProvider create(ZoneProvider amazonZoneProvider, boolean isAmazonEnvironment) {
        return isAmazonEnvironment ? amazonZoneProvider : () -> "unknown_zone";
    }

    public static RegionProvider create(RegionProvider amazonRegionProvider, boolean isAmazonEnvironment) {
        return isAmazonEnvironment ? amazonRegionProvider : () -> "unknown_region";
    }

    public static IpProvider create(IpProvider amazonIpProvider, boolean isAmazonEnvironment) {
        return isAmazonEnvironment ? amazonIpProvider : () -> "127.0.0.1";
    }

    public static IdProvider create(IdProvider amazonIdProvider, boolean isAmazonEnvironment) {
        return isAmazonEnvironment ? amazonIdProvider : () -> "unknown_box";
    }
}
