package pl.codewise.commons.aws;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.Tag;
import com.google.common.collect.Lists;

import java.util.List;

import static java.util.Collections.singletonList;

public class Ec2Wrapper {

    private final AmazonEC2 ec2;

    public Ec2Wrapper(AmazonEC2 ec2) {
        this.ec2 = ec2;
    }

    public List<Instance> describeInstances(String autoScalingGroup) {
        DescribeInstancesRequest request = new DescribeInstancesRequest()
                .withFilters(
                        new Filter("tag:aws:autoscaling:groupName", singletonList(autoScalingGroup)),
                        new Filter("instance-state-name", singletonList("running"))
                )
                .withInstanceIds();
        DescribeInstancesResult result = ec2.describeInstances(request);
        List<Instance> instances = Lists.newArrayList();
        for (Reservation reservation : result.getReservations()) {
            instances.addAll(reservation.getInstances());
        }
        return instances;
    }

    public void setInstanceName(Instance instance, String newName) {
        ec2.createTags(new CreateTagsRequest(singletonList(instance.getInstanceId()),
                singletonList(new Tag("Name", newName))));
    }

    public static String getInstanceName(Instance thisInstance) {
        String name = null;
        for (Tag tag : thisInstance.getTags()) {
            if ("Name".equals(tag.getKey())) {
                name = tag.getValue();
            }
        }
        return name;
    }
}
