package pl.codewise.commons.aws;

public class EC2InstanceIdProvider implements IdProvider {

    private final AwsEc2Instance awsEc2Instance;
    /** Cache the instance ID */
    private String instanceId;

    public EC2InstanceIdProvider(AwsEc2Instance awsEc2Instance) {
        this.awsEc2Instance = awsEc2Instance;
    }

    @Override
    public String getInstanceId() {
        if (instanceId == null) {
            instanceId = awsEc2Instance.getInstanceId();
        }

        return instanceId;
    }
}
