/*
 * Decompiled with CFR 0.152.
 */
package pl.bristleback.server.bristle.engine.netty;

import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.springframework.stereotype.Component;
import pl.bristleback.server.bristle.api.FrontController;
import pl.bristleback.server.bristle.api.WebsocketConnector;
import pl.bristleback.server.bristle.engine.OperationCode;

@Component
public class WebsocketFrameHandler {
    @Inject
    @Named(value="defaultFrontController")
    private FrontController frontController;

    public void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        WebsocketConnector connector = (WebsocketConnector)ctx.getAttachment();
        int operationCode = 0;
        if (frame instanceof TextWebSocketFrame) {
            operationCode = OperationCode.TEXT_FRAME_CODE.getCode();
        } else if (frame instanceof BinaryWebSocketFrame) {
            operationCode = OperationCode.BINARY_FRAME_CODE.getCode();
        } else if (frame instanceof CloseWebSocketFrame) {
            operationCode = OperationCode.CLOSE_FRAME_CODE.getCode();
        }
        this.frontController.processCommand(connector, operationCode, this.getData(frame));
    }

    private Object getData(WebSocketFrame frame) {
        if (frame instanceof TextWebSocketFrame) {
            return ((TextWebSocketFrame)frame).getText();
        }
        return frame.getBinaryData();
    }
}

