/*
 * Decompiled with CFR 0.152.
 */
package pl.bristleback.server.bristle.engine.netty;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.springframework.stereotype.Component;
import pl.bristleback.server.bristle.api.ServerEngine;
import pl.bristleback.server.bristle.conf.EngineConfig;
import pl.bristleback.server.bristle.engine.netty.IdleStateHandler;
import pl.bristleback.server.bristle.engine.netty.WebSocketServerHandler;

@Component
public class WebsocketChannelPipelineFactory
implements ChannelPipelineFactory {
    @Inject
    private WebSocketServerHandler webSocketServerHandler;
    private EngineConfig engineConfig;
    private IdleStateHandler idleStateHandler;

    public void init(ServerEngine engine) {
        this.engineConfig = engine.getEngineConfiguration();
        this.webSocketServerHandler.init(engine);
        HashedWheelTimer timer = new HashedWheelTimer();
        this.idleStateHandler = new IdleStateHandler((Timer)timer, this.engineConfig.getTimeout(), TimeUnit.MILLISECONDS);
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(this.engineConfig.getMaxFrameSize()));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("handler", (ChannelHandler)this.webSocketServerHandler);
        if (this.engineConfig.getTimeout() > 0) {
            pipeline.addLast("idleHandler", (ChannelHandler)this.idleStateHandler);
        }
        return pipeline;
    }
}

