/*
 * Decompiled with CFR 0.152.
 */
package pl.bristleback.server.bristle.engine.netty;

import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.springframework.stereotype.Component;
import pl.bristleback.server.bristle.api.ServerEngine;
import pl.bristleback.server.bristle.api.WebsocketConnector;
import pl.bristleback.server.bristle.engine.netty.HttpRequestHandler;
import pl.bristleback.server.bristle.engine.netty.WebsocketFrameHandler;

@Component
public class WebSocketServerHandler
extends SimpleChannelUpstreamHandler {
    private static Logger log = Logger.getLogger((String)WebSocketServerHandler.class.getName());
    private ServerEngine engine;
    @Inject
    private HttpRequestHandler httpRequestHandler;
    @Inject
    private WebsocketFrameHandler websocketFrameHandler;

    public void init(ServerEngine serverEngine) {
        this.engine = serverEngine;
        this.httpRequestHandler.init(serverEngine);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof HttpRequest) {
            this.httpRequestHandler.handleHttpRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.websocketFrameHandler.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelDisconnected(ctx, e);
        WebsocketConnector connector = (WebsocketConnector)ctx.getAttachment();
        if (connector != null) {
            this.engine.onConnectionClose(connector);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        log.debug((Object)e);
        e.getChannel().close();
    }
}

