/*
 * Decompiled with CFR 0.152.
 */
package pl.bristleback.server.bristle.engine.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.util.CharsetUtil;
import org.springframework.stereotype.Component;
import pl.bristleback.server.bristle.api.ServerEngine;
import pl.bristleback.server.bristle.api.WebsocketConnector;
import pl.bristleback.server.bristle.conf.EngineConfig;
import pl.bristleback.server.bristle.engine.WebsocketVersions;
import pl.bristleback.server.bristle.engine.base.AbstractServerEngine;
import pl.bristleback.server.bristle.engine.netty.NettyConnector;
import pl.bristleback.server.bristle.engine.netty.WebsocketChannelPipelineFactory;

@Component(value="system.engine.netty")
public class NettyServerEngine
extends AbstractServerEngine {
    private static Logger log = Logger.getLogger((String)NettyServerEngine.class.getName());
    private Channel serverChannel;
    @Inject
    private WebsocketChannelPipelineFactory pipelineFactory;

    public void startServer() {
        log.info((Object)("Starting Netty engine (" + ((Object)((Object)this)).getClass().getName() + ") on port " + this.getEngineConfiguration().getPort()));
        EngineConfig engineConfig = this.getEngineConfiguration();
        NioServerSocketChannelFactory nioChannelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)nioChannelFactory);
        this.pipelineFactory.init((ServerEngine)this);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipelineFactory);
        this.serverChannel = bootstrap.bind((SocketAddress)new InetSocketAddress(engineConfig.getPort()));
        log.info((Object)("Netty engine (" + ((Object)((Object)this)).getClass().getName() + ") on port " + this.getEngineConfiguration().getPort() + " has started."));
    }

    public void stopServer() {
        log.info((Object)("Stopping Netty engine (" + ((Object)((Object)this)).getClass().getName() + ") on port " + this.getEngineConfiguration().getPort()));
        if (this.serverChannel != null) {
            this.serverChannel.close();
            this.serverChannel.getFactory().releaseExternalResources();
        }
        log.info((Object)("Netty engine (" + ((Object)((Object)this)).getClass().getName() + ") on port " + this.getEngineConfiguration().getPort() + " has stopped."));
    }

    public void sendMessage(WebsocketConnector connector, String contentAsString) {
        Channel channel = ((NettyConnector)connector).getChannel();
        if (connector.getWebsocketVersion().equals(WebsocketVersions.HYBI_13.getVersionCode())) {
            channel.write((Object)new TextWebSocketFrame(ChannelBuffers.copiedBuffer((CharSequence)contentAsString, (Charset)CharsetUtil.UTF_8)));
        } else {
            channel.write((Object)new TextWebSocketFrame(contentAsString));
        }
    }

    public void sendMessage(WebsocketConnector connector, byte[] contentAsBytes) {
        Channel channel = ((NettyConnector)connector).getChannel();
        channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.copiedBuffer((byte[])contentAsBytes)));
    }
}

