/*
 * Decompiled with CFR 0.152.
 */
package pl.bristleback.server.bristle.engine.netty;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import org.jboss.netty.util.CharsetUtil;
import org.springframework.stereotype.Component;
import pl.bristleback.server.bristle.api.DataController;
import pl.bristleback.server.bristle.api.ServerEngine;
import pl.bristleback.server.bristle.api.WebsocketConnector;
import pl.bristleback.server.bristle.engine.WebsocketVersions;
import pl.bristleback.server.bristle.engine.netty.NettyConnector;

@Component
public class HttpRequestHandler {
    private static final String WEBSOCKET_ACCEPT_HYBI_10_PARAMETER = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final int HIXIE_BUFFER_SIZE = 16;
    private static final String WEBSOCKET_PATH = "/websocket";
    private static final String NULL_VALUE = "null";
    private ServerEngine engine;

    public void init(ServerEngine serverEngine) {
        this.engine = serverEngine;
    }

    public void handleHttpRequest(ChannelHandlerContext context, HttpRequest request) {
        if (this.isNotHttpGetRequest(request)) {
            this.sendHttpResponse(context, request, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        try {
            HttpResponse response = this.processHandshake(request);
            if (!response.getStatus().equals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS)) {
                this.sendHttpResponse(context, request, response);
                return;
            }
            this.initializeWebsocketConnector(context, request, response);
            this.replaceListeners(context);
        }
        catch (NoSuchAlgorithmException e) {
            context.getChannel().close();
        }
    }

    private void replaceListeners(ChannelHandlerContext context) {
        int maxFrameSize = this.engine.getEngineConfiguration().getMaxFrameSize();
        boolean maskClientMessagePayload = true;
        boolean maskServerMessagePayload = false;
        WebsocketConnector connector = (WebsocketConnector)context.getAttachment();
        String wsVersion = connector.getWebsocketVersion();
        WebSocket13FrameDecoder decoder = null;
        WebSocket13FrameEncoder encoder = null;
        if (wsVersion.equals(WebsocketVersions.HYBI_13.getVersionCode())) {
            decoder = new WebSocket13FrameDecoder(maskClientMessagePayload, true, (long)maxFrameSize);
            encoder = new WebSocket13FrameEncoder(maskServerMessagePayload);
        } else if (wsVersion.equals(WebsocketVersions.HYBI_10.getVersionCode())) {
            decoder = new WebSocket08FrameDecoder(maskClientMessagePayload, true, (long)maxFrameSize);
            encoder = new WebSocket08FrameEncoder(maskServerMessagePayload);
        } else if (wsVersion.equals(WebsocketVersions.HIXIE_76.getVersionCode())) {
            decoder = new WebSocket00FrameDecoder((long)maxFrameSize);
            encoder = new WebSocket00FrameEncoder();
        }
        ChannelPipeline pipeline = context.getChannel().getPipeline();
        pipeline.replace("decoder", "wsDecoder", (ChannelHandler)decoder);
        pipeline.replace("encoder", "wsEncoder", (ChannelHandler)encoder);
        pipeline.remove("aggregator");
    }

    private void initializeWebsocketConnector(final ChannelHandlerContext context, final HttpRequest request, HttpResponse response) {
        String controllerName = request.getHeader("Sec-WebSocket-Protocol");
        final DataController controllerUsed = this.engine.getConfiguration().getDataController(controllerName);
        ChannelFuture future = context.getChannel().write((Object)response);
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    NettyConnector connector = new NettyConnector(future.getChannel(), HttpRequestHandler.this.engine, controllerUsed);
                    connector.setWebsocketVersion(request.getHeader("Sec-WebSocket-Version"));
                    if (future.getChannel().isConnected()) {
                        context.setAttachment((Object)connector);
                        HttpRequestHandler.this.engine.onConnectionOpened((WebsocketConnector)connector);
                    }
                }
            }
        });
    }

    private HttpResponse processHandshake(HttpRequest request) throws NoSuchAlgorithmException {
        if (!this.hasHeaderWithValue(request, "Connection", "Upgrade") || !this.hasHeaderWithValue(request, "Upgrade", "WebSocket")) {
            return new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
        }
        if (this.hasBadProtocolHeader(request)) {
            return new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_ACCEPTABLE);
        }
        HttpResponse response = request.containsHeader("Sec-WebSocket-Version") ? this.processHybiHandshake(request) : this.processHixieHandshake(request);
        return response;
    }

    private HttpResponse processHixieHandshake(HttpRequest request) throws NoSuchAlgorithmException {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        this.addStandardResponseHeaders(request, (HttpResponse)response);
        response.addHeader("Sec-WebSocket-Origin", (Object)request.getHeader("Origin"));
        ChannelBuffer responseContent = this.createHixieHandshakeContent(request);
        response.setContent(responseContent);
        return response;
    }

    private HttpResponse processHybiHandshake(HttpRequest request) throws NoSuchAlgorithmException {
        String websocketKey = request.getHeader("Sec-WebSocket-Key");
        if (StringUtils.isEmpty((String)websocketKey)) {
            return new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        this.addStandardResponseHeaders(request, (HttpResponse)response);
        String websocketAcceptValue = this.computeHybiAcceptValue(websocketKey);
        response.addHeader("Sec-WebSocket-Accept", (Object)websocketAcceptValue);
        return response;
    }

    private String computeHybiAcceptValue(String websocketKey) throws NoSuchAlgorithmException {
        String concatenatedKey = websocketKey + WEBSOCKET_ACCEPT_HYBI_10_PARAMETER;
        byte[] result = MessageDigest.getInstance("SHA").digest(concatenatedKey.getBytes());
        result = Base64.encodeBase64((byte[])result);
        return new String(result);
    }

    private void addStandardResponseHeaders(HttpRequest request, HttpResponse response) {
        response.addHeader("Upgrade", (Object)"WebSocket");
        response.addHeader("Connection", (Object)"Upgrade");
        response.addHeader("Location", (Object)"Upgrade");
        response.addHeader("Sec-WebSocket-Location", (Object)this.getHttpClientLocation(request));
        String protocolRequested = request.getHeader("Sec-WebSocket-Protocol");
        if (StringUtils.isNotEmpty((String)protocolRequested)) {
            response.addHeader("Sec-WebSocket-Protocol", (Object)protocolRequested);
        }
    }

    private boolean hasBadProtocolHeader(HttpRequest request) {
        String protocol = request.getHeader("Sec-WebSocket-Protocol");
        if (protocol == null) {
            return false;
        }
        if (protocol.isEmpty()) {
            return true;
        }
        return !this.engine.getConfiguration().getDataControllers().hasController(protocol);
    }

    private ChannelBuffer createHixieHandshakeContent(HttpRequest request) throws NoSuchAlgorithmException {
        String key1 = request.getHeader("Sec-WebSocket-Key1");
        String key2 = request.getHeader("Sec-WebSocket-Key2");
        int keyA = (int)(Long.parseLong(key1.replaceAll("[^0-9]", "")) / (long)key1.replaceAll("[^ ]", "").length());
        int keyB = (int)(Long.parseLong(key2.replaceAll("[^0-9]", "")) / (long)key2.replaceAll("[^ ]", "").length());
        long keyC = request.getContent().readLong();
        ChannelBuffer responseBuffer = ChannelBuffers.buffer((int)16);
        responseBuffer.writeInt(keyA);
        responseBuffer.writeInt(keyB);
        responseBuffer.writeLong(keyC);
        return ChannelBuffers.wrappedBuffer((byte[])MessageDigest.getInstance("MD5").digest(responseBuffer.array()));
    }

    private String getHttpClientLocation(HttpRequest request) {
        String location = request.getHeader("Origin");
        if (StringUtils.isEmpty((String)location) || NULL_VALUE.equals(location)) {
            return "ws://" + request.getHeader("Host") + WEBSOCKET_PATH;
        }
        return location;
    }

    private boolean hasHeaderWithValue(HttpRequest request, String headerName, String expectedHeaderValue) {
        String headerValue = request.getHeader(headerName);
        return headerValue != null && expectedHeaderValue.equalsIgnoreCase(headerValue);
    }

    private boolean isNotHttpGetRequest(HttpRequest aReq) {
        return aReq.getMethod() != HttpMethod.GET;
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        if (res.getStatus().getCode() != HttpResponseStatus.OK.getCode()) {
            res.setContent(ChannelBuffers.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
        }
        ChannelFuture f = ctx.getChannel().write((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().getCode() != HttpResponseStatus.OK.getCode()) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }
}

