/*
 * Decompiled with CFR 0.152.
 */
package com.pop.easycache.registry.zk;

import com.pop.easycache.enums.CacheModifyType;
import com.pop.easycache.event.CacheModifyMessage;
import com.pop.easycache.event.EventBusHolder;
import com.pop.easycache.registry.Registry;
import com.pop.easycache.registry.zk.ZKConfig;
import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ZKRegistry
implements Registry {
    private static final Logger logger = LoggerFactory.getLogger(ZKRegistry.class);
    private volatile ZooKeeper zk;
    private String server;
    private String cacheMainPath;
    private int seesionTimeOut;
    private Watcher watcher;

    public ZKRegistry(ZKConfig zkConfig) {
        this.server = zkConfig.getServer();
        this.cacheMainPath = zkConfig.getPath();
        this.seesionTimeOut = zkConfig.getSessionTimeOut();
        this.zk = zkConfig.getZk();
        this.connect();
    }

    public void connect() {
        try {
            this.getZKInstance();
        }
        catch (Exception e) {
            logger.error("zk connect error", (Throwable)e);
        }
    }

    public synchronized void close() {
        if (this.zk != null) {
            try {
                this.zk.close();
            }
            catch (InterruptedException e) {
                logger.error("zk close error", (Throwable)e);
            }
            this.zk = null;
        }
    }

    public String create(String key, String value) {
        String path = this.cacheMainPath + "/" + key;
        try {
            this.zk.exists(path, true);
            return this.zk.create(path, value.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException e) {
            logger.info("zk create node error,node exist", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error("zk create node error", (Throwable)e);
            return null;
        }
    }

    public void del(String key) {
        try {
            this.zk.delete(this.cacheMainPath + "/" + key, -1);
        }
        catch (Exception e) {
            logger.error("zk del node error", (Throwable)e);
        }
    }

    private void reconnect() {
        this.close();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ZooKeeper getZKInstance() throws IOException, KeeperException, InterruptedException {
        if (this.zk != null) return this.zk;
        Class<ZooKeeper> clazz = ZooKeeper.class;
        synchronized (ZooKeeper.class) {
            if (this.zk != null) return this.zk;
            if (StringUtils.isEmpty((Object)this.server)) {
                throw new RuntimeException("can not connect zk,server is empty");
            }
            this.zk = new ZooKeeper(this.server, this.seesionTimeOut, this.getWatch());
            if (this.zk.exists(this.cacheMainPath, this.getWatch()) != null) return this.zk;
            this.zk.create(this.cacheMainPath, this.cacheMainPath.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.zk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Watcher getWatch() {
        if (this.watcher != null) return this.watcher;
        Class<Watcher> clazz = Watcher.class;
        synchronized (Watcher.class) {
            if (this.watcher != null) return this.watcher;
            this.watcher = new CacheWatcher();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.watcher;
        }
    }

    private String getKey(String path) {
        return path.substring(this.cacheMainPath.length() + 1);
    }

    private class CacheWatcher
    implements Watcher {
        private CacheWatcher() {
        }

        public void process(WatchedEvent watchedEvent) {
            if (watchedEvent.getState() == Watcher.Event.KeeperState.Expired) {
                logger.info("zk expired reconnect");
                ZKRegistry.this.reconnect();
                return;
            }
            if (Watcher.Event.EventType.NodeDeleted == watchedEvent.getType()) {
                String key = ZKRegistry.this.getKey(watchedEvent.getPath());
                EventBusHolder.eventBus.post((Object)new CacheModifyMessage(key, null, CacheModifyType.DELETE));
            } else if (Watcher.Event.EventType.NodeCreated == watchedEvent.getType()) {
                try {
                    ZKRegistry.this.zk.getData(watchedEvent.getPath(), true, null);
                }
                catch (KeeperException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

