/*
 * Decompiled with CFR 0.152.
 */
package com.pop.easycache.interceptor.handler;

import com.pop.easycache.annotion.NeedCache;
import com.pop.easycache.cache.Cache;
import com.pop.easycache.interceptor.handler.CacheHandler;
import com.pop.easycache.serialize.Serialize;
import com.pop.easycache.util.KeySpELUtil;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodProxy;
import org.springframework.util.StringUtils;

public class NeedCacheHandler
extends CacheHandler {
    public Object handle(Cache cache, Serialize serialize, Object target, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        NeedCache needCache = target.getClass().getAnnotation(NeedCache.class);
        if (method.getAnnotation(NeedCache.class) != null) {
            needCache = method.getAnnotation(NeedCache.class);
        }
        if (needCache != null) {
            String key;
            String className = target.getClass().getName();
            String methodName = method.getName();
            String returnTypeName = method.getReturnType().getName();
            if (returnTypeName.equals("void")) {
                return methodProxy.invokeSuper(target, args);
            }
            if (!StringUtils.isEmpty((Object)needCache.key()) || !StringUtils.isEmpty((Object)needCache.name())) {
                key = !StringUtils.isEmpty((Object)needCache.key()) && needCache.key().startsWith("#") ? needCache.name() + KeySpELUtil.getKey(method, args, needCache.key()) : needCache.name() + needCache.key();
            } else {
                StringBuilder keyBuilder = new StringBuilder();
                keyBuilder.append(className).append("-").append(methodName).append("-").append(serialize.objectToString(args));
                key = keyBuilder.toString();
            }
            Object cacheResult = cache.getStringByKey(key, method.getReturnType());
            if (cacheResult != null) {
                return cacheResult;
            }
            Object methodResut = methodProxy.invokeSuper(target, args);
            if (methodResut != null) {
                cache.set(key, methodResut);
            }
            return methodResut;
        }
        if (this.getSuccessor() != null) {
            return this.getSuccessor().handle(cache, serialize, target, method, args, methodProxy);
        }
        return methodProxy.invokeSuper(target, args);
    }
}

