/*
 * Decompiled with CFR 0.152.
 */
package com.pop.easycache.factory;

import com.google.common.base.Preconditions;
import com.pop.easycache.CacheBuilder;
import com.pop.easycache.cache.Cache;
import com.pop.easycache.cache.CacheImpl;
import com.pop.easycache.cache.local.LocalCache;
import com.pop.easycache.cache.local.LocalCacheFactory;
import com.pop.easycache.cache.local.guava.GuavaCacheConfig;
import com.pop.easycache.cache.local.guava.GuavaCacheFactory;
import com.pop.easycache.cache.remote.RemoteCache;
import com.pop.easycache.cache.remote.RemoteCacheFactory;
import com.pop.easycache.cache.remote.redis.RedisCacheConfig;
import com.pop.easycache.cache.remote.redis.RedisCacheFactory;
import com.pop.easycache.factory.CacheFactory;
import com.pop.easycache.registry.Registry;
import com.pop.easycache.registry.RegistryFactory;
import com.pop.easycache.registry.zk.ZKConfig;
import com.pop.easycache.registry.zk.ZKFactory;
import com.pop.easycache.serialize.Serialize;
import com.pop.easycache.serialize.SerializeFactory;
import com.pop.easycache.serialize.json.FastJsonConfig;
import com.pop.easycache.serialize.json.FastJsonFactory;
import org.springframework.util.StringUtils;

public class CacheFactoryImlp
implements CacheFactory {
    private CacheBuilder builder;
    private Serialize serialize;

    public CacheFactoryImlp(CacheBuilder builder) {
        this.builder = builder;
    }

    public Cache getCache() {
        this.serialize = this.initSerialize();
        return new CacheImpl(this.initLocalCache(), this.initRemoteCache(), this.initRegistry(), this.serialize);
    }

    private RemoteCache initRemoteCache() {
        if (this.builder.isUseRemoteCache()) {
            RemoteCacheFactory remoteCacheFactory = null;
            Preconditions.checkArgument((!StringUtils.isEmpty((Object)this.builder.getRemoteCacheType()) ? 1 : 0) != 0, (Object)"error,the remoteCacheType is null");
            if (this.builder.getRemoteCacheType().contentEquals("redis")) {
                remoteCacheFactory = new RedisCacheFactory(new RedisCacheConfig(this.builder.getTtl(), this.builder.getTtlUnit(), this.builder.getJedisPool(), this.builder.getRedisUrl(), this.builder.getRedisPort(), this.builder.getErrorNum(), this.builder.getRedisRetryTime()));
            }
            Preconditions.checkArgument((remoteCacheFactory != null ? 1 : 0) != 0, (Object)"can't support remoteCache type");
            return remoteCacheFactory.getRemoteCaChe();
        }
        return null;
    }

    private LocalCache initLocalCache() {
        if (this.builder.isUseLocalCache()) {
            LocalCacheFactory localCacheFactory = null;
            Preconditions.checkArgument((!StringUtils.isEmpty((Object)this.builder.getLocalCacheType()) ? 1 : 0) != 0, (Object)"error,the localCacheType is null");
            if (this.builder.getLocalCacheType().contentEquals("guava")) {
                localCacheFactory = new GuavaCacheFactory(new GuavaCacheConfig(this.builder.getTtl(), this.builder.getTtlUnit(), this.builder.getLocalMaxSize()));
            }
            Preconditions.checkArgument((localCacheFactory != null ? 1 : 0) != 0, (Object)"can't support localCache type");
            return localCacheFactory.getLocalCaChe();
        }
        return null;
    }

    private Serialize initSerialize() {
        SerializeFactory serializeFactory = null;
        Preconditions.checkArgument((!StringUtils.isEmpty((Object)this.builder.getSerializeType()) ? 1 : 0) != 0, (Object)"error,the serializeType is null");
        if (this.builder.getSerializeType().contentEquals("fastJson")) {
            serializeFactory = new FastJsonFactory(new FastJsonConfig(this.builder.getSerializerFeatures(), this.builder.getFeature()));
        }
        Preconditions.checkArgument((serializeFactory != null ? 1 : 0) != 0, (Object)"can't support serialize type");
        return serializeFactory.getSerialize();
    }

    private Registry initRegistry() {
        if (this.builder.isUseRegistry()) {
            RegistryFactory registryFactory = null;
            Preconditions.checkArgument((!StringUtils.isEmpty((Object)this.builder.getRegistryType()) ? 1 : 0) != 0, (Object)"error,the registryType is null");
            if (this.builder.getRegistryType().contentEquals("zooKeeper")) {
                registryFactory = new ZKFactory(new ZKConfig(this.builder.getRegistryServer(), this.builder.getRegistryPath(), this.builder.getZooKeeper(), this.builder.getSessionTimeOut()));
            }
            Preconditions.checkArgument((registryFactory != null ? 1 : 0) != 0, (Object)"can't support registry type");
            return registryFactory.getRegistry();
        }
        return null;
    }

    public Serialize getSerialize() {
        return this.serialize;
    }
}

