/*
 * Decompiled with CFR 0.152.
 */
package com.pop.easycache.cache.remote.redis;

import com.pop.easycache.cache.remote.RemoteCache;
import com.pop.easycache.cache.remote.redis.RedisPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class RedisRemoteCacheImpl
implements RemoteCache {
    private static final Logger logger = LoggerFactory.getLogger(RedisRemoteCacheImpl.class);
    private RedisPool redispool;

    public RedisRemoteCacheImpl(RedisPool redispool) {
        this.redispool = redispool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value) {
        Jedis con = null;
        try {
            con = this.redispool.getConnection();
            con.set(key, value);
        }
        finally {
            this.redispool.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value, int second) {
        Jedis con = null;
        try {
            con = this.redispool.getConnection();
            con.set(key, value);
            con.expire(key, second);
        }
        finally {
            this.redispool.closeConnection(con);
        }
    }

    public void del(String key) {
        Jedis con = null;
        try {
            con = this.redispool.getConnection();
            if (con != null) {
                con.del(key);
            }
        }
        finally {
            this.redispool.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringByKey(String key) {
        Jedis con = null;
        String res = null;
        try {
            con = this.redispool.getConnection();
            res = con.get(key);
        }
        finally {
            this.redispool.closeConnection(con);
        }
        return res;
    }

    public void setRedispool(RedisPool redispool) {
        this.redispool = redispool;
    }
}

