/*
 * Decompiled with CFR 0.152.
 */
package com.pop.easycache.cache.remote.redis;

import com.pop.easycache.cache.remote.RemoteCache;
import com.pop.easycache.cache.remote.RemoteCacheFactory;
import com.pop.easycache.cache.remote.redis.RedisCacheConfig;
import com.pop.easycache.cache.remote.redis.RedisDaemon;
import com.pop.easycache.cache.remote.redis.RedisPool;
import com.pop.easycache.cache.remote.redis.RedisRemoteCacheImpl;
import com.pop.easycache.entity.ValidBean;
import com.pop.easycache.proxy.RedisProxy;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPool;

public class RedisCacheFactory
extends RemoteCacheFactory {
    private RedisCacheConfig config;

    public RedisCacheFactory(RedisCacheConfig config) {
        this.config = config;
    }

    protected ValidBean valid() {
        if (this.config.getJedisPool() != null || !StringUtils.isEmpty((Object)this.config.getRedisUrl()) && !StringUtils.isEmpty((Object)this.config.getRedisPort())) {
            return new ValidBean(true, null);
        }
        return new ValidBean(false, "no source found");
    }

    protected RemoteCache build() {
        RedisPool redisPool;
        if (this.config.getJedisPool() != null) {
            redisPool = new RedisPool(this.config.getJedisPool());
        } else {
            JedisPool jedisPool = new JedisPool(this.config.getRedisUrl(), this.config.getRedisPort());
            redisPool = new RedisPool(jedisPool);
        }
        RedisProxy proxy = new RedisProxy(this.config.getErrorNum(), redisPool);
        RemoteCache remoteCache = (RemoteCache)proxy.getProxy(RedisRemoteCacheImpl.class);
        RedisDaemon redisDaemon = new RedisDaemon(redisPool, this.config.getRedisRetryTime());
        return remoteCache;
    }
}

