/*
 * Decompiled with CFR 0.152.
 */
package com.pop.easycache.cache;

import com.pop.easycache.cache.Cache;
import com.pop.easycache.cache.local.LocalCache;
import com.pop.easycache.cache.remote.RemoteCache;
import com.pop.easycache.registry.Registry;
import com.pop.easycache.serialize.Serialize;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheImpl
implements Cache {
    private LocalCache localCache;
    private RemoteCache remoteCache;
    private Registry registry;
    private Serialize serialize;

    public CacheImpl(LocalCache localCache, RemoteCache remoteCache, Registry registry, Serialize serialize) {
        this.localCache = localCache;
        this.remoteCache = remoteCache;
        this.registry = registry;
        this.serialize = serialize;
    }

    @Override
    public void set(String key, Object value) {
        if (this.localCache != null) {
            this.localCache.set(key, value);
        }
        if (this.registry != null) {
            this.registry.create(key, this.serialize.objectToString(value));
        }
        if (this.remoteCache != null) {
            this.remoteCache.set(key, this.serialize.objectToString(value));
        }
    }

    @Override
    public void del(String key) {
        if (this.remoteCache != null) {
            this.remoteCache.del(key);
        }
        if (this.localCache != null) {
            this.localCache.del(key);
        }
        if (this.registry != null) {
            this.registry.del(key);
        }
    }

    @Override
    public <T> T getStringByKey(String key, Class<T> clazz) {
        String remoteResult;
        Object localResult;
        if (this.localCache != null && (localResult = this.localCache.getStringByKey(key)) != null) {
            return (T)localResult;
        }
        if (this.remoteCache != null && !StringUtils.isEmpty((Object)(remoteResult = this.remoteCache.getStringByKey(key)))) {
            return this.serialize.toObject(remoteResult, clazz);
        }
        return null;
    }
}

