/*
 * Decompiled with CFR 0.152.
 */
package com.pop.easycache;

import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.pop.easycache.annotion.CacheFlush;
import com.pop.easycache.annotion.NeedCache;
import com.pop.easycache.factory.CacheFactoryImlp;
import com.pop.easycache.proxy.CacheCglibProxy;
import com.pop.easycache.proxy.Proxy;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.ZooKeeper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import redis.clients.jedis.JedisPool;

public class CacheBuilder
implements BeanPostProcessor,
InitializingBean {
    private String serializeType = "fastJson";
    private String localCacheType = "guava";
    private String remoteCacheType = "redis";
    private String registryType = "zooKeeper";
    private boolean useLocalCache = false;
    private boolean useRemoteCache = false;
    private boolean useRegistry = false;
    private ZooKeeper zooKeeper;
    private JedisPool jedisPool;
    private String redisUrl;
    private int redisPort;
    private String registryServer;
    private int sessionTimeOut = 200000;
    private String registryPath = "/easyCache_localCache";
    private SerializerFeature[] serializerFeatures = new SerializerFeature[0];
    private Feature[] feature = new Feature[0];
    private long ttl = -1L;
    private TimeUnit ttlUnit = TimeUnit.SECONDS;
    private long localMaxSize = -1L;
    private Map<String, Object> cacheBeanMap;
    private Proxy proxy;
    private int errorNum = 200;
    private int redisRetryTime = 20;

    public void afterPropertiesSet() throws Exception {
        this.cacheBeanMap = new ConcurrentHashMap<String, Object>();
        CacheFactoryImlp cacheFactory = new CacheFactoryImlp(this);
        this.proxy = new CacheCglibProxy(cacheFactory.getCache(), cacheFactory.getSerialize());
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean != null) {
            return this.wrapIfNecessary(bean, beanName);
        }
        return bean;
    }

    private Object wrapIfNecessary(Object bean, String beanName) {
        Method[] methods;
        Object cacheBean = this.cacheBeanMap.get(beanName);
        if (cacheBean != null) {
            return cacheBean;
        }
        if (bean.getClass().getAnnotation(NeedCache.class) != null) {
            Object proxyBean = this.proxy.getProxyObject(bean.getClass());
            this.cacheBeanMap.put(beanName, proxyBean);
            return proxyBean;
        }
        for (Method method : methods = bean.getClass().getMethods()) {
            if (method.getAnnotation(NeedCache.class) == null && method.getAnnotation(CacheFlush.class) == null) continue;
            Object proxyBean = this.proxy.getProxyObject(bean.getClass());
            this.cacheBeanMap.put(beanName, proxyBean);
            return proxyBean;
        }
        return bean;
    }

    public String getSerializeType() {
        return this.serializeType;
    }

    public void setSerializeType(String serializeType) {
        this.serializeType = serializeType;
    }

    public String getLocalCacheType() {
        return this.localCacheType;
    }

    public void setLocalCacheType(String localCacheType) {
        this.localCacheType = localCacheType;
    }

    public String getRemoteCacheType() {
        return this.remoteCacheType;
    }

    public void setRemoteCacheType(String remoteCacheType) {
        this.remoteCacheType = remoteCacheType;
    }

    public String getRegistryType() {
        return this.registryType;
    }

    public void setRegistryType(String registryType) {
        this.registryType = registryType;
    }

    public boolean isUseLocalCache() {
        return this.useLocalCache;
    }

    public void setUseLocalCache(boolean useLocalCache) {
        this.useLocalCache = useLocalCache;
    }

    public boolean isUseRemoteCache() {
        return this.useRemoteCache;
    }

    public void setUseRemoteCache(boolean useRemoteCache) {
        this.useRemoteCache = useRemoteCache;
    }

    public boolean isUseRegistry() {
        return this.useRegistry;
    }

    public void setUseRegistry(boolean useRegistry) {
        this.useRegistry = useRegistry;
    }

    public ZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(ZooKeeper zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public String getRedisUrl() {
        return this.redisUrl;
    }

    public void setRedisUrl(String redisUrl) {
        this.redisUrl = redisUrl;
    }

    public int getRedisPort() {
        return this.redisPort;
    }

    public void setRedisPort(int redisPort) {
        this.redisPort = redisPort;
    }

    public SerializerFeature[] getSerializerFeatures() {
        return this.serializerFeatures;
    }

    public void setSerializerFeatures(SerializerFeature[] serializerFeatures) {
        this.serializerFeatures = serializerFeatures;
    }

    public Feature[] getFeature() {
        return this.feature;
    }

    public void setFeature(Feature[] feature) {
        this.feature = feature;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public TimeUnit getTtlUnit() {
        return this.ttlUnit;
    }

    public void setTtlUnit(TimeUnit ttlUnit) {
        this.ttlUnit = ttlUnit;
    }

    public long getLocalMaxSize() {
        return this.localMaxSize;
    }

    public void setLocalMaxSize(long localMaxSize) {
        this.localMaxSize = localMaxSize;
    }

    public String getRegistryServer() {
        return this.registryServer;
    }

    public void setRegistryServer(String registryServer) {
        this.registryServer = registryServer;
    }

    public int getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    public void setSessionTimeOut(int sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
    }

    public String getRegistryPath() {
        return this.registryPath;
    }

    public void setRegistryPath(String registryPath) {
        this.registryPath = registryPath;
    }

    public int getErrorNum() {
        return this.errorNum;
    }

    public void setErrorNum(int errorNum) {
        this.errorNum = errorNum;
    }

    public int getRedisRetryTime() {
        return this.redisRetryTime;
    }

    public void setRedisRetryTime(int redisRetryTime) {
        this.redisRetryTime = redisRetryTime;
    }
}

