/*
 * Decompiled with CFR 0.152.
 */
package com.czzhan.captcha.common.dto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;

public class CaptchaDto {
    private String ip;
    private String servletPath;
    private String date;
    private Integer count;

    public CaptchaDto(String ip, String servletPath) {
        this.ip = ip;
        this.servletPath = servletPath;
        this.date = DateFormatUtils.format((Date)new Date(), (String)DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.getPattern());
        this.count = 0;
    }

    public String getKey() {
        String key = this.ip + this.servletPath + this.date;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] mdBytes = md.digest(key.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte b : mdBytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            return key;
        }
    }

    public String getIp() {
        return this.ip;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getDate() {
        return this.date;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaptchaDto)) {
            return false;
        }
        CaptchaDto other = (CaptchaDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$servletPath = this.getServletPath();
        String other$servletPath = other.getServletPath();
        if (this$servletPath == null ? other$servletPath != null : !this$servletPath.equals(other$servletPath)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        return !(this$date == null ? other$date != null : !this$date.equals(other$date));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CaptchaDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $servletPath = this.getServletPath();
        result = result * 59 + ($servletPath == null ? 43 : $servletPath.hashCode());
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        return result;
    }

    public String toString() {
        return "CaptchaDto(ip=" + this.getIp() + ", servletPath=" + this.getServletPath() + ", date=" + this.getDate() + ", count=" + this.getCount() + ")";
    }
}

