/*
 * Decompiled with CFR 0.152.
 */
package com.czzhan.captcha.common.aspectj;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.czzhan.captcha.common.annotation.WebInterceptCaptcha;
import com.czzhan.captcha.common.core.RedisCache;
import com.czzhan.captcha.common.dto.CaptchaDto;
import com.czzhan.captcha.common.dto.Result;
import com.czzhan.captcha.common.util.IpUtils;
import com.wf.captcha.ArithmeticCaptcha;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order(value=1)
@Component
public class WebInterceptCaptchaAspect {
    private static final Logger log = LoggerFactory.getLogger(WebInterceptCaptchaAspect.class);
    @Resource
    private RedisCache redisCache;

    @Pointcut(value="@annotation(com.czzhan.captcha.common.annotation.WebInterceptCaptcha)")
    public void captchaPointCut() {
    }

    @Around(value="captchaPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        WebInterceptCaptcha captchaPointCut = signature.getMethod().getAnnotation(WebInterceptCaptcha.class);
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = sra.getRequest();
        String ip = IpUtils.getIpAddr(request);
        String servletPath = request.getServletPath();
        CaptchaDto dto = new CaptchaDto(ip, servletPath);
        String hickey = "reqCaptcha:history:" + dto.getKey();
        String str = this.redisCache.getCacheObject(hickey);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            dto = (CaptchaDto)JSONObject.parseObject((String)str, CaptchaDto.class);
        }
        if (captchaPointCut.ipUpperLimit() > 0 && captchaPointCut.ipUpperLimit() <= dto.getCount()) {
            return JSONObject.toJSONString((Object)Result.failed("\u4eca\u65e5\u8c03\u7528\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650"), (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        }
        if (captchaPointCut.ipTriggerLimit() <= dto.getCount()) {
            return this.captcha(point, request, dto);
        }
        return point.proceed();
    }

    @AfterReturning(returning="object", pointcut="captchaPointCut()")
    public void doAfterReturning(Object object) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String ip = IpUtils.getIpAddr(request);
        String servletPath = request.getServletPath();
        CaptchaDto dto = new CaptchaDto(ip, servletPath);
        String hickey = "reqCaptcha:history:" + dto.getKey();
        String str = this.redisCache.getCacheObject(hickey);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            dto = (CaptchaDto)JSONObject.parseObject((String)str, CaptchaDto.class);
            dto.setCount(dto.getCount() + 1);
        } else {
            dto.setCount(1);
        }
        this.redisCache.setCacheObject(hickey, JSONObject.toJSONString((Object)dto, (JSONWriter.Feature[])new JSONWriter.Feature[0]), 1, TimeUnit.DAYS);
    }

    private Object captcha(ProceedingJoinPoint point, HttpServletRequest request, CaptchaDto dto) throws Throwable {
        String key = "reqCaptcha:key:" + dto.getKey();
        String code = request.getHeader("captcha-code");
        String tmpCode = this.redisCache.getCacheObject(key);
        if (StringUtils.isNotBlank((CharSequence)tmpCode) && StringUtils.equals((CharSequence)code, (CharSequence)tmpCode)) {
            this.redisCache.deleteObject(key);
            return point.proceed();
        }
        Captcha specCaptcha = this.easyGenerateCode();
        String content = specCaptcha.text();
        log.info("content={}", (Object)content);
        this.redisCache.setCacheObject(key, content, 300, TimeUnit.SECONDS);
        return Result.captcha(specCaptcha.toBase64());
    }

    private Captcha easyGenerateCode() {
        SpecCaptcha specCaptcha;
        Random random = new Random();
        int n = random.nextInt(2);
        if (n == 0) {
            specCaptcha = new SpecCaptcha();
            specCaptcha.setLen(5);
        } else {
            specCaptcha = new ArithmeticCaptcha();
            specCaptcha.setLen(2);
        }
        return specCaptcha;
    }
}

