package com.czzhan.captcha.common.dto;

import lombok.Data;

/**
 * Result
 *
 * @author czzhan
 * @date 2024/5/5 20:44
 */
@Data
public class Result {

    private String code;

    private String message;

    private Object data;

    public static Result failed(String message) {
        Result result = new Result();
        result.code = "500";
        result.message = message;
        return result;
    }

    public static Result captcha(Object data) {
        Result result = new Result();
        result.code = "10001000";
        result.data = data;
        return result;
    }
}
