package com.czzhan.captcha.common.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * WebInterceptCaptcha
 * web接口拦截，返回验证码注解
 *
 * @author czzhan
 * @date 2024/5/5 15:18
 */
@Target({ ElementType.METHOD, ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface WebInterceptCaptcha {

    /**
    * ipTriggerLimit
    * 单ip调用，触发验证码的阈值
    *
    * @author czzhan
    * @since 2024/5/5 15:24
    * @return int
    */
    int ipTriggerLimit() default 0;

    /**
    * ipUpperLimit
    * 单ip最大调用接口次数
    *
    * @author czzhan
    * @since 2024/5/5 15:34
    * @return int
    */
    int ipUpperLimit() default -1;

}
