/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator.jmi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jmi.model.AliasType;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.AttachesTo;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.DataType;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.IsOfType;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Namespace;
import javax.jmi.model.Parameter;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.Reference;
import javax.jmi.model.RefersTo;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.Tag;
import javax.jmi.model.TypedElement;
import ru.novosoft.mdf.ext.MDFOutermostPackage;
import ru.novosoft.mdf.generator.GenMM;
import ru.novosoft.mdf.generator.NameUtil;

public class JMIUtil {
    private static MDFOutermostPackage repository;
    private static Properties properties;
    private static GenMM generator;
    private static HashMap obj2name;
    private static long gen_name_count;
    private static HashMap obj2collectionId;
    private static long gen_collection_id;
    static /* synthetic */ Class class$javax$jmi$model$IsOfType;
    static /* synthetic */ Class class$javax$jmi$model$RefersTo;
    static /* synthetic */ Class class$javax$jmi$model$AttachesTo;

    public JMIUtil(MDFOutermostPackage r, Properties p, GenMM gen) {
        repository = r;
        properties = p;
        generator = gen;
    }

    public static String setterAt(String nm, String pos, String arg) {
        return JMIUtil.setterAtName(nm) + "(" + pos + ", " + arg + ")";
    }

    public static String setter(String nm, String arg) {
        return JMIUtil.setterName(nm) + "(" + arg + ")";
    }

    public static String setterName(String nm) {
        return "set" + NameUtil.getId1(nm);
    }

    public static String setterAtName(String nm) {
        return "set" + NameUtil.getId1(nm) + "At";
    }

    public static GenMM getGenerator() {
        return generator;
    }

    public static String getter(String nm) {
        return JMIUtil.nameOfGetter(nm) + "()";
    }

    public static String getter(String nm, String arg) {
        return JMIUtil.nameOfGetter(nm) + "(" + arg + ")";
    }

    public static final boolean isEnum(Object o) {
        return o instanceof EnumerationType;
    }

    public static final boolean isStruct(Object o) {
        return o instanceof StructureType;
    }

    public static boolean isBoolean(Classifier c) {
        if ((c = JMIUtil.dereference(c)) instanceof PrimitiveType) {
            return "PrimitiveTypes.Boolean".equals(JMIUtil.getQualifiedName((ModelElement)c));
        }
        return false;
    }

    public static boolean isFloat(Classifier c) {
        if ((c = JMIUtil.dereference(c)) instanceof PrimitiveType) {
            return "PrimitiveTypes.Float".equals(JMIUtil.getQualifiedName((ModelElement)c));
        }
        return false;
    }

    public static boolean isDouble(Classifier c) {
        if ((c = JMIUtil.dereference(c)) instanceof PrimitiveType) {
            return "PrimitiveTypes.Double".equals(JMIUtil.getQualifiedName((ModelElement)c));
        }
        return false;
    }

    public static boolean isInteger(Classifier c) {
        if ((c = JMIUtil.dereference(c)) instanceof PrimitiveType) {
            PrimitiveType dt = (PrimitiveType)c;
            return "PrimitiveTypes.Integer".equals(JMIUtil.getQualifiedName((ModelElement)dt));
        }
        return false;
    }

    public static boolean isString(Classifier c) {
        if ((c = JMIUtil.dereference(c)) instanceof PrimitiveType) {
            PrimitiveType dt = (PrimitiveType)c;
            return "PrimitiveTypes.String".equals(JMIUtil.getQualifiedName((ModelElement)dt));
        }
        return false;
    }

    public static boolean isLong(Classifier c) {
        if ((c = JMIUtil.dereference(c)) instanceof PrimitiveType) {
            return "PrimitiveTypes.Long".equals(JMIUtil.getQualifiedName((ModelElement)c));
        }
        return false;
    }

    public static boolean isBoolean(StructuralFeature sf) {
        return JMIUtil.isBoolean(sf.getType());
    }

    public static boolean isString(Object o) {
        if (o instanceof PrimitiveType) {
            PrimitiveType pt = (PrimitiveType)o;
            return "PrimitiveTypes.String".equals(JMIUtil.getQualifiedName((ModelElement)pt));
        }
        return false;
    }

    public static final String getQualifiedName(ModelElement m) {
        Namespace ns = m.getContainer();
        String rc = JMIUtil.getName(m);
        while (ns != null) {
            rc = JMIUtil.getName((ModelElement)ns) + "." + rc;
            ns = ns.getContainer();
        }
        return rc;
    }

    public static boolean isOptional(Attribute at) {
        return "optional".equals(JMIUtil.multValued(at));
    }

    public static boolean isOptional(AssociationEnd ae) {
        return "optional".equals(JMIUtil.multValued(ae));
    }

    public static boolean isSingle(Attribute at) {
        return "single".equals(JMIUtil.multValued(at));
    }

    public static boolean isSingle(AssociationEnd ae) {
        return "single".equals(JMIUtil.multValued(ae));
    }

    public static boolean isMulti(Attribute at) {
        return "multi".equals(JMIUtil.multValued(at));
    }

    public static boolean isMulti(AssociationEnd ae) {
        return "multi".equals(JMIUtil.multValued(ae));
    }

    public static boolean isMultiple(MultiplicityType m) {
        return JMIUtil.upper(m) > 1 || JMIUtil.upper(m) == -1;
    }

    public static boolean isMultiple(TypedElement te) {
        return JMIUtil.upper(te) > 1 || JMIUtil.upper(te) == -1;
    }

    public static String getQualifiedNameAsParamList(ModelElement m) {
        int paramNum = 1;
        StringBuffer buf = new StringBuffer("\"" + JMIUtil.getName(m) + "\"");
        Namespace ns = m.getContainer();
        while (ns != null) {
            buf.insert(0, "\"" + JMIUtil.getName((ModelElement)ns) + "\",");
            ++paramNum;
            ns = ns.getContainer();
        }
        if (paramNum > 7) {
            return " new String[]{" + buf + "} ";
        }
        return buf.toString();
    }

    public static boolean isOrdered(TypedElement te) {
        if (te instanceof AssociationEnd) {
            return JMIUtil.isOrdered(((AssociationEnd)te).getMultiplicity());
        }
        if (te instanceof StructuralFeature) {
            return JMIUtil.isOrdered(((StructuralFeature)te).getMultiplicity());
        }
        throw new RuntimeException();
    }

    public static boolean isSet(AssociationEnd ae) {
        return JMIUtil.isMultiple((TypedElement)ae) && JMIUtil.isUnique((TypedElement)ae) && !JMIUtil.isOrdered((TypedElement)ae);
    }

    public static boolean isSet(TypedElement te) {
        return JMIUtil.isMultiple(te) && JMIUtil.isUnique(te) && !JMIUtil.isOrdered(te);
    }

    public static boolean isList(AssociationEnd ae) {
        return JMIUtil.isMultiple((TypedElement)ae) && !JMIUtil.isSet(ae);
    }

    public static boolean isList(TypedElement te) {
        return JMIUtil.isMultiple(te) && !JMIUtil.isSet(te);
    }

    public static final String getName(ModelElement m) {
        String rc = (String)JMIUtil.tagValue(m, "javax.jmi.substituteName");
        if (rc != null) {
            return rc;
        }
        return m.getName();
    }

    public static Collection elementsByType(Classifier c) {
        MDFOutermostPackage outermostPkg = (MDFOutermostPackage)c.refOutermostPackage();
        IsOfType isOfType = (IsOfType)outermostPkg.getMetaObject(class$javax$jmi$model$IsOfType == null ? (class$javax$jmi$model$IsOfType = JMIUtil.class$("javax.jmi.model.IsOfType")) : class$javax$jmi$model$IsOfType);
        return isOfType.getTypedElements(c);
    }

    public static String nameOfGetter(String nm) {
        return "get" + NameUtil.getId1(nm);
    }

    public static AssociationEnd oppositeEnd(AssociationEnd ae) {
        Association asc = (Association)ae.getContainer();
        Iterator i = asc.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof AssociationEnd) || o == ae) continue;
            return (AssociationEnd)o;
        }
        throw new RuntimeException("bad model, association only with one end.");
    }

    public static Reference referenceTo(AssociationEnd oe) {
        MDFOutermostPackage outermostPkg = (MDFOutermostPackage)oe.refOutermostPackage();
        RefersTo refersTo = (RefersTo)outermostPkg.getMetaObject(class$javax$jmi$model$RefersTo == null ? (class$javax$jmi$model$RefersTo = JMIUtil.class$("javax.jmi.model.RefersTo")) : class$javax$jmi$model$RefersTo);
        Collection references = refersTo.getReferent(oe);
        JMIUtil.tooManyReferencesControl(references);
        if (1 == references.size()) {
            return (Reference)references.iterator().next();
        }
        return null;
    }

    public static Reference primaryReferenceTo(AssociationEnd oe) {
        MDFOutermostPackage outermostPkg = (MDFOutermostPackage)oe.refOutermostPackage();
        RefersTo refersTo = (RefersTo)outermostPkg.getMetaObject(class$javax$jmi$model$RefersTo == null ? (class$javax$jmi$model$RefersTo = JMIUtil.class$("javax.jmi.model.RefersTo")) : class$javax$jmi$model$RefersTo);
        Collection references = refersTo.getReferent(oe);
        AssociationEnd te = JMIUtil.oppositeEnd(oe);
        Reference rc = null;
        Iterator i = references.iterator();
        while (i.hasNext()) {
            Reference r = (Reference)i.next();
            if (r.getContainer() != te.getType()) continue;
            if (rc != null) {
                throw new RuntimeException("too many primiary references for end: " + oe.getContainer().getName() + "." + oe.getName());
            }
            rc = r;
        }
        return rc;
    }

    public static String genMethodName(AssociationEnd ae) {
        return JMIUtil.genName((ModelElement)ae);
    }

    public static String implType(ModelElement c) {
        if (c instanceof MofPackage) {
            return JMIUtil.javaClassPackage((Namespace)c) + "." + JMIUtil.nameOfClass(JMIUtil.name(c), "Package");
        }
        if (c instanceof EnumerationType) {
            return JMIUtil.javaClassPackage(c.getContainer()) + "." + JMIUtil.nameOfInterface(c) + "Enum";
        }
        String rc = JMIUtil.javaClassPackage(c.getContainer()) + "." + JMIUtil.nameOfClass(JMIUtil.getName(c));
        if (c instanceof MofClass && JMIUtil.getGenerator().needGenerateHelper((MofClass)c)) {
            rc = rc + "Helper";
        }
        return rc;
    }

    public static String nameOfMutator(Attribute at) {
        StringBuffer buf = new StringBuffer();
        buf.append("set");
        if (JMIUtil.upper((StructuralFeature)at) == 1 && JMIUtil.isBoolean((StructuralFeature)at) && JMIUtil.startsWithIs(JMIUtil.name((ModelElement)at))) {
            buf.append(NameUtil.getId1(JMIUtil.name((ModelElement)at).substring(2)));
        } else {
            buf.append(NameUtil.getId1(JMIUtil.name((ModelElement)at)));
        }
        return buf.toString();
    }

    public static String mutator(Attribute at, String arg) {
        return JMIUtil.nameOfMutator(at) + "(" + arg + ")";
    }

    public static String javaInterfacePackage(Namespace ns) {
        String tagValue;
        String pk = properties.getProperty("interfaces.package.prefix.tagId");
        if (null == pk) {
            pk = properties.getProperty("interfaces.package.tagId");
        }
        if (null == (tagValue = (String)JMIUtil.tagValue((ModelElement)ns, pk))) {
            if (null != ns.getContainer()) {
                return JMIUtil.javaInterfacePackage(ns.getContainer()) + "." + NameUtil.getId2(JMIUtil.name((ModelElement)ns));
            }
            throw new RuntimeException("cannot generate name for package: " + JMIUtil.name((ModelElement)ns));
        }
        String p = properties.getProperty("interfaces.package.map." + tagValue + "." + JMIUtil.name((ModelElement)ns));
        if (null == p) {
            throw new RuntimeException("cannot generate name for package: " + tagValue + "." + JMIUtil.name((ModelElement)ns));
        }
        return p;
    }

    public static final String mofPrefixedPackageName(Namespace ns) {
        String pk = properties.getProperty("interfaces.package.prefix.tagId");
        if (null == pk) {
            pk = properties.getProperty("interfaces.package.tagId");
        }
        String tagValue = (String)JMIUtil.tagValue((ModelElement)ns, pk);
        return tagValue + "." + ns.getName();
    }

    public static String implTypeInnerDataType(DataType dt) {
        String rc = JMIUtil.javaClassPackage(dt.getContainer().getContainer()) + ".";
        if (dt instanceof EnumerationType) {
            return rc + JMIUtil.nameOfInterface((ModelElement)dt) + "Enum";
        }
        return rc + JMIUtil.nameOfClass(JMIUtil.getName((ModelElement)dt));
    }

    public static String javaClassPackage(Namespace ns) {
        String tagValue;
        String pk = properties.getProperty("impl.package.prefix.tagId");
        if (pk == null) {
            pk = properties.getProperty("impl.package.tagId");
        }
        if ((tagValue = (String)JMIUtil.tagValue((ModelElement)ns, pk)) == null) {
            if (ns.getContainer() != null) {
                return JMIUtil.javaClassPackage(ns.getContainer()) + "." + NameUtil.getId2(JMIUtil.name((ModelElement)ns));
            }
            throw new RuntimeException("cannot generate name for package: " + JMIUtil.name((ModelElement)ns));
        }
        String p = properties.getProperty("impl.package.map." + tagValue + "." + JMIUtil.name((ModelElement)ns));
        if (p == null) {
            throw new RuntimeException("cannot generate name for package: " + tagValue + "." + JMIUtil.name((ModelElement)ns));
        }
        return p;
    }

    public static String nameOfInterface(ModelElement cls) {
        StringBuffer buf = new StringBuffer();
        String pfx = null;
        if (cls instanceof MofPackage) {
            pfx = properties.getProperty("interfaces.package.prefix." + JMIUtil.mofPrefixedPackageName((Namespace)cls));
        }
        if (pfx == null && cls.getContainer() != null) {
            pfx = properties.getProperty("interfaces.package.prefix." + JMIUtil.mofPrefixedPackageName(cls.getContainer()));
        }
        if (pfx == null) {
            pfx = properties.getProperty("interfaces.prefix");
        }
        buf.append(pfx);
        buf.append(NameUtil.getId1(JMIUtil.name(cls)));
        String sffx = null;
        if (cls instanceof MofPackage) {
            sffx = properties.getProperty("interfaces.package.suffix." + JMIUtil.mofPrefixedPackageName((Namespace)cls));
        }
        if (sffx == null && cls.getContainer() != null) {
            sffx = properties.getProperty("interfaces.package.suffix." + JMIUtil.mofPrefixedPackageName(cls.getContainer()));
        }
        if (sffx == null) {
            sffx = properties.getProperty("interfaces.suffix");
        }
        buf.append(sffx);
        return buf.toString();
    }

    public static String nameOfClass(String name) {
        StringBuffer buf = new StringBuffer();
        buf.append(JMIUtil.implPrefix());
        buf.append(NameUtil.getId1(name));
        buf.append(JMIUtil.implSuffix());
        return buf.toString();
    }

    public static String nameOfClass(String name, String sfx) {
        StringBuffer buf = new StringBuffer();
        buf.append(JMIUtil.implPrefix());
        buf.append(NameUtil.getId1(name));
        buf.append(sfx);
        buf.append(JMIUtil.implSuffix());
        return buf.toString();
    }

    public static String unprefixEnumLabel(DataType dt, String label) {
        String tagValue = (String)JMIUtil.tagValue((ModelElement)dt, "org.omg.xmi.enumerationUnprefix");
        if (tagValue != null && label.startsWith(tagValue)) {
            return label.substring(tagValue.length());
        }
        return label;
    }

    public static String accessor(StructuralFeature sf) {
        return JMIUtil.nameOfAccessor(sf) + "()";
    }

    public static String accessor(StructuralFeature sf, String params) {
        return JMIUtil.nameOfAccessor(sf) + "(" + params + ")";
    }

    public static String accessor(StructureField field) {
        return JMIUtil.nameOfAccessor(field) + "()";
    }

    public static String javaCollectionInterface(MultiplicityType m) {
        if (m.isOrdered()) {
            return "java.util.List";
        }
        return "java.util.Collection";
    }

    public static String javaCollectionInterface(StructuralFeature sf) {
        if (sf.getMultiplicity().isOrdered()) {
            return "java.util.List";
        }
        return "java.util.Collection";
    }

    public static String modifier(String nm, String arg1, String arg2) {
        return JMIUtil.nameOfModifier(nm) + "(" + arg1 + ", " + arg2 + ")";
    }

    public static String nameOfRemover(StructuralFeature sf) {
        return "remove" + NameUtil.getId1(JMIUtil.name((ModelElement)sf));
    }

    public static String unref(String nm, String arg) {
        return "internalUnrefBy" + NameUtil.uname(nm) + "(" + arg + ")";
    }

    public static String ref(String nm, String arg) {
        return "internalRefBy" + NameUtil.uname(nm) + "(" + arg + ")";
    }

    public static String refThis(String nm, String o) {
        return o + "." + JMIUtil.ref(nm, "this") + ";";
    }

    public static String genName(ModelElement e) {
        String rc = (String)obj2name.get(e);
        if (rc == null) {
            rc = JMIUtil.getName(e) + gen_name_count;
            ++gen_name_count;
            obj2name.put(e, rc);
        }
        return rc;
    }

    public static String adder(String nm, String arg) {
        return JMIUtil.nameOfAdder(nm) + "(" + arg + ")";
    }

    public static String nameOfAdder(String nm) {
        return "add" + NameUtil.getId1(nm);
    }

    public static String remover(String nm, String arg) {
        return JMIUtil.nameOfRemover(nm) + "(" + arg + ")";
    }

    public static String removerAt(String nm, String pos) {
        return JMIUtil.removerAtName(nm) + "(" + pos + ")";
    }

    public static String nameOfRemover(String nm) {
        return "remove" + NameUtil.getId1(nm);
    }

    public static String removerAtName(String nm) {
        return "remove" + NameUtil.getId1(nm) + "At";
    }

    public static Object tagValue(ModelElement m, String tagId) {
        MDFOutermostPackage outermostPkg = (MDFOutermostPackage)m.refOutermostPackage();
        AttachesTo attachesTo = (AttachesTo)outermostPkg.getMetaObject(class$javax$jmi$model$AttachesTo == null ? (class$javax$jmi$model$AttachesTo = JMIUtil.class$("javax.jmi.model.AttachesTo")) : class$javax$jmi$model$AttachesTo);
        Iterator i = attachesTo.getTag(m).iterator();
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            if (!tagId.equals(tag.getTagId())) continue;
            List rc = tag.getValues();
            if (rc.size() != 1) {
                throw new RuntimeException("Too many values for tag use other method: " + rc);
            }
            return rc.iterator().next();
        }
        return null;
    }

    public static int upper(MultiplicityType mult) {
        return mult.getUpper();
    }

    public static int upper(StructuralFeature sf) {
        return JMIUtil.upper(sf.getMultiplicity());
    }

    public static int upper(TypedElement te) {
        if (te instanceof AssociationEnd) {
            return JMIUtil.upper(((AssociationEnd)te).getMultiplicity());
        }
        if (te instanceof StructuralFeature) {
            return JMIUtil.upper(((StructuralFeature)te).getMultiplicity());
        }
        if (te instanceof Parameter) {
            return JMIUtil.upper(((Parameter)te).getMultiplicity());
        }
        throw new RuntimeException();
    }

    public static String genCollectionId(Object o) {
        if (o instanceof AssociationEnd || o instanceof Attribute) {
            String id = (String)obj2collectionId.get(o);
            if (id == null) {
                id = "" + gen_collection_id;
                obj2collectionId.put(o, id);
                ++gen_collection_id;
            }
            return id;
        }
        throw new RuntimeException();
    }

    public static Classifier dereference(Classifier c) {
        while (c instanceof AliasType) {
            c = ((AliasType)c).getType();
        }
        return c;
    }

    protected static boolean isUnique(TypedElement te) {
        if (te instanceof StructuralFeature) {
            return JMIUtil.isUnique(((StructuralFeature)te).getMultiplicity());
        }
        if (te instanceof AssociationEnd) {
            return JMIUtil.isUnique(((AssociationEnd)te).getMultiplicity());
        }
        throw new RuntimeException();
    }

    protected static boolean isUnique(MultiplicityType m) {
        return m.isUnique();
    }

    protected static boolean isOrdered(MultiplicityType m) {
        return m.isOrdered();
    }

    private static String multValued(Attribute at) {
        int lower = at.getMultiplicity().getLower();
        if (lower == 0 && JMIUtil.upper((StructuralFeature)at) == 1) {
            return "optional";
        }
        if (lower == 1 && JMIUtil.upper((StructuralFeature)at) == 1) {
            return "single";
        }
        return "multi";
    }

    private static String multValued(AssociationEnd ae) {
        if (JMIUtil.upper((TypedElement)ae) == 1) {
            return "single";
        }
        return "multi";
    }

    private static void tooManyReferencesControl(Collection references) {
        if (references.size() > 1) {
            StringBuffer buf = new StringBuffer();
            Iterator i = references.iterator();
            while (i.hasNext()) {
                Reference ref = (Reference)i.next();
                buf.append("Too many references. The program need redesign to handle this model. ");
                buf.append(JMIUtil.name((ModelElement)ref.getContainer()));
                buf.append(".").append(JMIUtil.name((ModelElement)ref)).append(":");
                buf.append(JMIUtil.name((ModelElement)ref.getType()));
            }
            throw new RuntimeException(buf.toString());
        }
    }

    private static String implPrefix() {
        return properties.getProperty("impl.prefix");
    }

    private static String implSuffix() {
        return properties.getProperty("impl.suffix");
    }

    private static String nameOfModifier(String nm) {
        return "modify" + NameUtil.getId1(nm);
    }

    private static String nameOfAccessor(StructuralFeature sf) {
        if (JMIUtil.upper(sf) == 1 && JMIUtil.isBoolean(sf) && JMIUtil.startsWithIs(JMIUtil.name((ModelElement)sf))) {
            return "is" + NameUtil.getId1(JMIUtil.name((ModelElement)sf).substring(2));
        }
        return "get" + NameUtil.getId1(JMIUtil.name((ModelElement)sf));
    }

    private static boolean startsWithIs(String name) {
        return name.startsWith("is");
    }

    private static String nameOfAccessor(StructureField field) {
        if (JMIUtil.isBoolean(field.getType()) && JMIUtil.startsWithIs(JMIUtil.name((ModelElement)field))) {
            return "is" + NameUtil.getId1(JMIUtil.name((ModelElement)field).substring(2));
        }
        return "get" + NameUtil.getId1(JMIUtil.name((ModelElement)field));
    }

    private static String name(ModelElement m) {
        return JMIUtil.getName(m);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        generator = null;
        obj2name = new HashMap();
        gen_name_count = 100L;
        obj2collectionId = new HashMap();
        gen_collection_id = 100L;
    }
}

