/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator.jmi;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.Association;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.VisibilityKindEnum;
import ru.novosoft.mdf.generator.GenMM;
import ru.novosoft.mdf.generator.jmi.GenMMInterfaceWriter;
import ru.novosoft.mdf.generator.jmi.JMIUtil;

public final class GenMMPackage
extends GenMMInterfaceWriter {
    private JMIUtil jmi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenMMPackage(GenMM g, MofPackage c, JMIUtil jmi) throws IOException {
        super(g, JMIUtil.javaInterfacePackage((Namespace)c), JMIUtil.nameOfInterface((ModelElement)c) + "Package.java", jmi);
        this.jmi = jmi;
        try {
            this.prolog();
            this.line("package " + JMIUtil.javaInterfacePackage((Namespace)c) + ";");
            this.annotation();
            this.declareInterface(c);
            this.sblock();
            this.generateMethods(c);
            this.eblock();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close();
            throw throwable;
        }
        this.close();
    }

    private void generateMethods(MofPackage p) throws IOException {
        Iterator i = p.getContents().iterator();
        while (i.hasNext()) {
            ModelElement o = (ModelElement)i.next();
            if (o instanceof Import) {
                this.genGetterMethodForImportedPackage((Import)o);
                continue;
            }
            if (o instanceof MofPackage) {
                this.genGetterMethodForInnerPackage((MofPackage)o);
                continue;
            }
            if (o instanceof MofClass) {
                this.genGetterMethodForProxy((MofClass)o);
                continue;
            }
            if (o instanceof Association) {
                this.genGetterMethodForAssociation((Association)o);
                continue;
            }
            if (!JMIUtil.isStruct(o)) continue;
            this.genCreateStructMethod((StructureType)o);
        }
    }

    private void genCreateStructMethod(StructureType dt) {
        this.sline("public ");
        this.print(JMIUtil.javaInterfacePackage(dt.getContainer()));
        this.print(".");
        this.print(JMIUtil.nameOfInterface((ModelElement)dt));
        this.print(" create");
        this.print(this.getName((ModelElement)dt));
        this.print("(");
        List fields = this.getFields(dt);
        int j = 0;
        while (j < fields.size()) {
            StructureField f = (StructureField)fields.get(j);
            this.print(this.type(f));
            this.print(" ");
            this.print(this.getName((ModelElement)f));
            if (j != fields.size() - 1) {
                this.print(", ");
            }
            ++j;
        }
        this.println(") throws javax.jmi.reflect.JmiException;");
    }

    private void declareInterface(MofPackage c) {
        String nm = JMIUtil.nameOfInterface((ModelElement)c);
        this.sline("public interface ");
        this.print(nm);
        this.print("Package extends ");
        List st = c.getSupertypes();
        if (st.size() == 0) {
            this.print("javax.jmi.reflect.RefPackage");
        } else {
            int i = 0;
            while (i < st.size()) {
                MofPackage p = (MofPackage)st.get(i);
                if (VisibilityKindEnum.PUBLIC_VIS == p.getVisibility()) {
                    this.print(this.type(p) + "Package");
                    if (i != st.size() - 1) {
                        this.print(", ");
                    }
                }
                ++i;
            }
        }
        this.println();
    }

    private void genGetterMethodForImportedPackage(Import im) {
        Namespace ns = im.getImportedNamespace();
        if (ns instanceof MofPackage) {
            boolean isPackagePublic;
            MofPackage importedPkg = (MofPackage)ns;
            boolean isImportClustered = im.isClustered();
            boolean isImportPublic = im.getVisibility() == VisibilityKindEnum.PUBLIC_VIS;
            boolean bl = isPackagePublic = importedPkg.getVisibility() == VisibilityKindEnum.PUBLIC_VIS;
            if (isImportClustered && isImportPublic && isPackagePublic) {
                this.sline("public " + JMIUtil.javaInterfacePackage((Namespace)importedPkg) + ".");
                this.print(JMIUtil.nameOfInterface((ModelElement)importedPkg) + "Package ");
                this.println("get" + JMIUtil.nameOfInterface((ModelElement)im) + "();");
            }
        }
    }

    private void genGetterMethodForInnerPackage(MofPackage innerPkg) {
        if (innerPkg.getVisibility() == VisibilityKindEnum.PUBLIC_VIS) {
            this.sline("public " + JMIUtil.javaInterfacePackage((Namespace)innerPkg) + ".");
            this.print(JMIUtil.nameOfInterface((ModelElement)innerPkg) + "Package ");
            this.println("get" + JMIUtil.nameOfInterface((ModelElement)innerPkg) + "();");
        }
    }

    private void genGetterMethodForProxy(MofClass proxy) {
        if (proxy.getVisibility() == VisibilityKindEnum.PUBLIC_VIS) {
            this.sline("public " + this.type(proxy) + "Class ");
            this.println("get" + JMIUtil.nameOfInterface((ModelElement)proxy) + "();");
        }
    }

    private void genGetterMethodForAssociation(Association asc) {
        if (VisibilityKindEnum.PUBLIC_VIS == asc.getVisibility()) {
            this.sline("public " + this.type(asc));
            this.println(" get" + JMIUtil.nameOfInterface((ModelElement)asc) + "();");
        }
    }

    private void annotation() {
        this.println();
        this.println("/*");
        this.println(" * Contains operations that provide the dependent Package, ");
        this.println(" * Association and Class proxy objects for a package object.");
        this.println(" * For more information see JMI specification.");
        this.println("*/");
    }
}

