/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator.jmi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.DirectionKindEnum;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofException;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Operation;
import javax.jmi.model.Parameter;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.TypedElement;
import ru.novosoft.mdf.generator.jmi.GenMMInterfaceWriter;
import ru.novosoft.mdf.generator.jmi.JMIUtil;

public class GenMMOperationTemplate
extends GenMMInterfaceWriter {
    protected Collection operations;
    private StringBuffer paramBuf;
    private StringBuffer params;
    private StringBuffer excepBuf;
    private String retType;

    public GenMMOperationTemplate(Collection c) throws IOException {
        this.operations = new ArrayList(c);
        this.paramBuf = new StringBuffer();
        this.excepBuf = new StringBuffer();
        this.params = new StringBuffer();
    }

    public void signatures() {
        Iterator i = this.operations.iterator();
        while (i.hasNext()) {
            Operation o = (Operation)i.next();
            this.collectOperationInfo(o);
            String mdfctr = o.getScope() == ScopeKindEnum.CLASSIFIER_LEVEL ? "public static " : "public ";
            this.line(mdfctr + this.retType + this.getName((ModelElement)o) + "(" + this.paramBuf + ") throws " + this.excepBuf + ";");
            this.paramBuf.delete(0, this.paramBuf.length());
            this.excepBuf.delete(0, this.excepBuf.length());
            this.params.delete(0, this.params.length());
        }
    }

    public void operations() {
        Iterator i = this.operations.iterator();
        while (i.hasNext()) {
            Operation o = (Operation)i.next();
            this.collectOperationInfo(o);
            String mdfctr = o.getScope() == ScopeKindEnum.CLASSIFIER_LEVEL ? "public static " : "public ";
            this.line(mdfctr + this.retType + this.getName((ModelElement)o) + "(" + this.paramBuf + ") throws " + this.excepBuf);
            this.body(o);
            this.paramBuf.delete(0, this.paramBuf.length());
            this.params.delete(0, this.params.length());
            this.excepBuf.delete(0, this.excepBuf.length());
        }
    }

    public void operationStubs() {
        Iterator i = this.operations.iterator();
        while (i.hasNext()) {
            Operation o = (Operation)i.next();
            MofClass c = (MofClass)o.getContainer();
            this.collectOperationInfo(o);
            String mdfctr = o.getScope() == ScopeKindEnum.CLASSIFIER_LEVEL ? "public static " : "public ";
            this.sline(mdfctr + this.retType + this.getName((ModelElement)o) + "(" + JMIUtil.javaInterfacePackage(c.getContainer()));
            this.print("." + JMIUtil.nameOfInterface((ModelElement)c));
            if (this.paramBuf.length() != 0) {
                this.println(" o, " + this.paramBuf + ") throws " + this.excepBuf);
            } else {
                this.println(" o) throws " + this.excepBuf);
            }
            this.block();
            this.paramBuf.delete(0, this.paramBuf.length());
            this.params.delete(0, this.params.length());
            this.excepBuf.delete(0, this.excepBuf.length());
        }
    }

    private void body(Operation o) {
        this.sblock();
        MofClass c = (MofClass)o.getContainer();
        String type = JMIUtil.javaClassPackage(c.getContainer()) + "." + JMIUtil.nameOfClass(this.getName((ModelElement)c));
        this.sline(type + "Operations oprtn = (" + type + "Operations)");
        this.print("((ru.novosoft.mdf.ext.MDFOutermostPackage)refOutermostPackage()).");
        this.println("getOperationObject(" + type + "Operations.class);");
        if (!"void ".equals(this.retType)) {
            this.sline("return ");
        }
        if (this.params.length() == 0) {
            this.println("oprtn." + this.getName((ModelElement)o) + "(this);");
        } else {
            this.println("oprtn." + this.getName((ModelElement)o) + "(this, " + this.params + ");");
        }
        this.eblock();
    }

    private void collectOperationInfo(Operation o) {
        if (this.getReturnType(o) == null) {
            this.retType = "void ";
        } else {
            Parameter rt = this.getReturnType(o);
            MultiplicityType mt = rt.getMultiplicity();
            int upper = mt.getUpper();
            int lower = mt.getLower();
            this.retType = upper == 1 && lower == 0 ? this.type(rt) + " " : (upper == 1 && lower == 1 ? this.type(rt) + " " : this.colType((TypedElement)rt) + " ");
        }
        Iterator i = this.getParameters(o).iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            MultiplicityType mt = p.getMultiplicity();
            int upper = mt.getUpper();
            int lower = mt.getLower();
            if (upper == 1 && lower == 0) {
                if (this.isIN_DIR(p)) {
                    this.paramBuf.append(this.type(p));
                } else if (this.isOUT_DIR(p)) {
                    this.paramBuf.append(this.type(p) + "[]");
                } else if (this.isINOUT_DIR(p)) {
                    this.paramBuf.append(this.type(p) + "[]");
                }
            } else if (upper == 1 && lower == 1) {
                if (this.isIN_DIR(p)) {
                    this.paramBuf.append(this.type(p));
                } else if (this.isOUT_DIR(p)) {
                    this.paramBuf.append(this.type(p) + "[]");
                } else if (this.isINOUT_DIR(p)) {
                    this.paramBuf.append(this.type(p) + "[]");
                }
            } else if (this.isIN_DIR(p)) {
                this.paramBuf.append(this.colType((TypedElement)p));
            } else if (this.isOUT_DIR(p)) {
                this.paramBuf.append(this.colType((TypedElement)p));
            } else if (this.isINOUT_DIR(p)) {
                this.paramBuf.append(this.colType((TypedElement)p));
            }
            this.paramBuf.append(" " + p.getName());
            this.params.append(p.getName());
            if (!i.hasNext()) continue;
            this.paramBuf.append(", ");
            this.params.append(", ");
        }
        Iterator i2 = o.getExceptions().iterator();
        while (i2.hasNext()) {
            this.excepBuf.append(this.type((MofException)i2.next()) + "Exception, ");
        }
        this.excepBuf.append("javax.jmi.reflect.JmiException");
    }

    private Parameter getReturnType(Operation o) {
        Iterator i = o.getContents().iterator();
        while (i.hasNext()) {
            Parameter p;
            Object obj = i.next();
            if (!(obj instanceof Parameter) || (p = (Parameter)obj).getDirection() != DirectionKindEnum.RETURN_DIR) continue;
            return p;
        }
        return null;
    }

    private List getParameters(Operation o) {
        ArrayList params = new ArrayList();
        Iterator i = o.getContents().iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof Parameter)) continue;
            params.add(obj);
        }
        params.remove(this.getReturnType(o));
        return params;
    }

    private boolean isIN_DIR(Parameter p) {
        return p.getDirection() == DirectionKindEnum.IN_DIR;
    }

    private boolean isOUT_DIR(Parameter p) {
        return p.getDirection() == DirectionKindEnum.OUT_DIR;
    }

    private boolean isINOUT_DIR(Parameter p) {
        return p.getDirection() == DirectionKindEnum.INOUT_DIR;
    }
}

