/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator.jmi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.model.Attribute;
import javax.jmi.model.Constant;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Operation;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKind;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.VisibilityKindEnum;
import ru.novosoft.mdf.generator.GenMM;
import ru.novosoft.mdf.generator.NameUtil;
import ru.novosoft.mdf.generator.jmi.GenMMInterfaceWriter;
import ru.novosoft.mdf.generator.jmi.GenMMOperationTemplate;
import ru.novosoft.mdf.generator.jmi.JMIUtil;

public final class GenMMObject
extends GenMMInterfaceWriter {
    private JMIUtil jmi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenMMObject(GenMM g, MofClass c, JMIUtil jmi) throws IOException {
        super(g, JMIUtil.javaInterfacePackage(c.getContainer()), JMIUtil.nameOfInterface((ModelElement)c) + ".java", jmi);
        try {
            this.jmi = jmi;
            String nm = JMIUtil.nameOfInterface((ModelElement)c);
            this.prolog();
            this.line("package " + JMIUtil.javaInterfacePackage(c.getContainer()) + ";");
            this.annotation();
            this.declareInterface(c);
            this.sblock();
            this.generate(c);
            this.eblock();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.close();
            throw throwable;
        }
        this.close();
    }

    protected void attrAccessor(Attribute at) {
        if (ScopeKindEnum.CLASSIFIER_LEVEL == at.getScope()) {
            return;
        }
        MultiplicityType mt = at.getMultiplicity();
        int upper = mt.getUpper();
        int lower = mt.getLower();
        if (upper == 1 && lower == 0) {
            this.line("public " + this.type((StructuralFeature)at) + " " + JMIUtil.accessor((StructuralFeature)at) + " throws javax.jmi.reflect.JmiException;");
        } else if (upper == 1 && lower == 1) {
            this.line("public " + this.type((StructuralFeature)at) + " " + JMIUtil.accessor((StructuralFeature)at) + " throws javax.jmi.reflect.JmiException;");
        } else {
            String c = JMIUtil.javaCollectionInterface(mt);
            this.line("public " + c + " " + JMIUtil.accessor((StructuralFeature)at) + " throws javax.jmi.reflect.JmiException;");
        }
    }

    private void declareInterface(MofClass c) {
        String nm = JMIUtil.nameOfInterface((ModelElement)c);
        this.sline("public interface " + nm + " extends ");
        Iterator i = c.getSupertypes().iterator();
        if (!i.hasNext()) {
            this.print("javax.jmi.reflect.RefObject");
        }
        boolean first = true;
        while (i.hasNext()) {
            MofClass sc = (MofClass)i.next();
            if (first) {
                first = false;
            } else {
                this.print(", ");
            }
            this.print(this.type(sc));
        }
        this.println();
    }

    private void generate(MofClass c) throws IOException {
        ArrayList col = new ArrayList();
        Iterator i = c.getContents().iterator();
        while (i.hasNext()) {
            ModelElement m = (ModelElement)i.next();
            if (m instanceof Constant) {
                this.constants((Constant)m);
                continue;
            }
            if (m instanceof Operation) {
                this.checkOperation(col, (Operation)m);
                continue;
            }
            if (m instanceof Reference) {
                this.referenceOperations((Reference)m);
                continue;
            }
            if (!(m instanceof Attribute)) continue;
            this.attributeOperations((Attribute)m, (ScopeKind)ScopeKindEnum.INSTANCE_LEVEL);
        }
        new GenMMOperationTemplate(col).signatures();
    }

    private void checkOperation(Collection col, Operation op) {
        if (op.getVisibility() == VisibilityKindEnum.PUBLIC_VIS && op.getScope() == ScopeKindEnum.INSTANCE_LEVEL) {
            col.add(op);
        }
    }

    private void constants(Constant c) {
        String v = c.getValue();
        StringBuffer buf = new StringBuffer(v);
        if (v.indexOf("\n") != -1) {
            buf.deleteCharAt(v.indexOf("\n"));
            buf.insert(v.indexOf("\n"), "\\n");
        }
        this.sline("public final " + this.type(c) + " ");
        this.print(NameUtil.getId3(this.getName((ModelElement)c)) + " = \"");
        this.println(buf.toString() + "\";");
    }

    private void annotation() {
        this.println();
        this.println("/*");
        this.println(" * This interface contains operations for the");
        this.println(" * classes instance-scoped attributes and operations, ");
        this.println(" * along with any references");
        this.println(" */");
    }
}

