/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator.jmi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.AggregationKindEnum;
import javax.jmi.model.AliasType;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.CollectionType;
import javax.jmi.model.Constant;
import javax.jmi.model.DataType;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofException;
import javax.jmi.model.MofPackage;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Namespace;
import javax.jmi.model.Parameter;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKind;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.TypedElement;
import javax.jmi.model.VisibilityKindEnum;
import ru.novosoft.mdf.generator.GenMM;
import ru.novosoft.mdf.generator.GenMMWriter;
import ru.novosoft.mdf.generator.jmi.JMIUtil;
import ru.novosoft.mdf.mof.impl.model.MOFMultiplicityTypeImpl;

public class GenMMInterfaceWriter
extends GenMMWriter {
    public static final String PRIV_METH = "private final static Method ";
    public static final String REF_OBJECT = "javax.jmi.reflect.RefObject";
    public static final String REF_CLASS = "javax.jmi.reflect.RefClass";
    public static final String MOF_CLASS = "javax.jmi.model.MofClass";
    public static final String ASC_END = "javax.jmi.model.AssociationEnd";
    public static final String REF_PACKAGE = "javax.jmi.reflect.RefPackage";
    public static final String MDF_CLASS = "ru.novosoft.mdf.ext.MDFClass";
    public static final String MDF_PACKAGE = "ru.novosoft.mdf.ext.MDFPackage";
    public static final String MDF_OBJECT = "ru.novosoft.mdf.ext.MDFObject";
    public static final String PUB_FIN = "public final ";
    public static final String REF_STRUCT = "javax.jmi.reflect.RefStruct";
    public static final String REF_ENUM = "javax.jmi.reflect.RefEnum";
    public static final String MDF_STRUCT_IMPL = "ru.novosoft.mdf.impl.MDFStructImpl";
    public static final String REF_ASSOCIATION = "javax.jmi.reflect.RefAssociation";
    public static final String MDF_BASE_OBJECT_IMPL = "ru.novosoft.mdf.impl.MDFBaseObjectImpl";
    public static final String THROWS_NOT_FOUND = "throws javax.jmi.reflect.NotFoundException";
    public static JMIUtil jmi = null;

    public GenMMInterfaceWriter(GenMM generator, String pkg, String file, JMIUtil jmi) throws IOException {
        super(generator, pkg, file);
        GenMMInterfaceWriter.jmi = jmi;
    }

    public GenMMInterfaceWriter() throws IOException {
    }

    public boolean isComposite(Reference ref) {
        AssociationEnd oe = ref.getReferencedEnd();
        AssociationEnd te = JMIUtil.oppositeEnd(oe);
        return this.isComposite((TypedElement)te);
    }

    public AssociationEnd oppositeEnd(AssociationEnd ae) {
        Association a = (Association)ae.getContainer();
        Iterator i = a.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof AssociationEnd) || o == ae) continue;
            return (AssociationEnd)o;
        }
        throw new RuntimeException("bad model, association only with one end.");
    }

    public String vname(ModelElement me) {
        if (me instanceof AssociationEnd) {
            return this.vname(JMIUtil.genName((ModelElement)((AssociationEnd)me)));
        }
        return this.vname(JMIUtil.genName(me));
    }

    public String methodJavaTypeValue(Classifier m) {
        if (JMIUtil.isFloat(m)) {
            return "floatValue()";
        }
        if (JMIUtil.isDouble(m)) {
            return "doubleValue()";
        }
        if (JMIUtil.isBoolean(m)) {
            return "booleanValue()";
        }
        if (JMIUtil.isInteger(m)) {
            return "intValue()";
        }
        if (JMIUtil.isLong(m)) {
            return "longValue()";
        }
        return null;
    }

    protected String getRefName(AssociationEnd oe) {
        Reference r = JMIUtil.primaryReferenceTo(oe);
        if (r != null) {
            return this.getName((ModelElement)r);
        }
        return this.type((Association)oe.getContainer()) + "." + this.getName((ModelElement)oe);
    }

    protected boolean isOrdered(TypedElement te) {
        if (te instanceof AssociationEnd) {
            return this.isOrdered(((AssociationEnd)te).getMultiplicity());
        }
        if (te instanceof StructuralFeature) {
            return this.isOrdered(((StructuralFeature)te).getMultiplicity());
        }
        if (te instanceof Parameter) {
            return this.isOrdered(((Parameter)te).getMultiplicity());
        }
        throw new RuntimeException();
    }

    protected boolean isOrdered(MultiplicityType m) {
        return m.isOrdered();
    }

    protected boolean isUnique(TypedElement te) {
        if (te instanceof StructuralFeature) {
            return this.isUnique(((StructuralFeature)te).getMultiplicity());
        }
        if (te instanceof AssociationEnd) {
            return this.isUnique(((AssociationEnd)te).getMultiplicity());
        }
        throw new RuntimeException();
    }

    protected boolean isUnique(MultiplicityType m) {
        return m.isUnique();
    }

    protected boolean isComposite(TypedElement te) {
        if (te instanceof Attribute) {
            return ((Attribute)te).getType() instanceof MofClass;
        }
        if (te instanceof AssociationEnd) {
            return AggregationKindEnum.COMPOSITE == ((AssociationEnd)te).getAggregation();
        }
        throw new RuntimeException();
    }

    protected final String getName(ModelElement m) {
        return GenMMInterfaceWriter.getName(jmi, m);
    }

    protected final List getFields(StructureType st) {
        ArrayList rc = new ArrayList();
        Iterator i = st.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof StructureField)) continue;
            rc.add(o);
        }
        return rc;
    }

    protected void attributeOperations(Attribute at, ScopeKind scope) {
        if (VisibilityKindEnum.PUBLIC_VIS == at.getVisibility() && scope == at.getScope()) {
            this.attrAccessor(at);
            if (at.isChangeable()) {
                this.attrMutator(at);
            }
        }
    }

    protected void referenceOperations(Reference r) {
        if (VisibilityKindEnum.PUBLIC_VIS == r.getVisibility()) {
            MultiplicityType m = r.getMultiplicity();
            AssociationEnd ae = r.getReferencedEnd();
            if (m.getUpper() == 1) {
                this.line("public " + this.type(ae) + " " + JMIUtil.accessor((StructuralFeature)r) + " throws javax.jmi.reflect.JmiException;");
                if (ae.isChangeable()) {
                    this.line("public void " + JMIUtil.setterName(this.getName((ModelElement)r)) + "(" + this.type(ae) + " newValue) throws javax.jmi.reflect.JmiException;");
                }
            } else if (JMIUtil.isMultiple((TypedElement)r)) {
                MultiplicityType mult = ae.getMultiplicity();
                this.line("public " + JMIUtil.javaCollectionInterface(mult) + " " + JMIUtil.accessor((StructuralFeature)r) + " throws javax.jmi.reflect.JmiException;");
            } else {
                throw new RuntimeException("r.getName() == " + r.getName() + "; lower = " + m.getLower() + ";  upper = " + m.getUpper());
            }
        }
    }

    protected void block() {
        this.sblock();
        this.line("String msg = mdfOutermostPackage.getLocalizedString(\"MDFNotImpl\");");
        this.line("throw new RuntimeException( msg );");
        this.eblock();
    }

    protected void line(StringBuffer buf) {
        this.line(buf.toString());
        this.clearBuf(buf);
    }

    protected void clearBuf(StringBuffer buf) {
        buf.delete(0, buf.length());
    }

    protected List superTypes(Classifier cl) {
        return new ArrayList(cl.getSupertypes());
    }

    protected List fields(DataType dt) {
        if (dt instanceof StructureType) {
            StructureType st = (StructureType)dt;
            return this.getFields(st);
        }
        throw new RuntimeException("data type isn't struct. " + dt);
    }

    protected String utilQualifiedProxyName(MofClass c) {
        GenMM g = this.getGenerator();
        String sfx = g.getProperty("impl.suffix");
        String prfx = g.getProperty("impl.prefix");
        StringBuffer pnm = new StringBuffer();
        pnm.append(JMIUtil.javaClassPackage(c.getContainer()));
        pnm.append(".");
        pnm.append(JMIUtil.nameOfClass(this.getName((ModelElement)c), "Class"));
        return pnm.toString();
    }

    protected void genRefThis(String thisName, String o, boolean composite, String refName, boolean nullable) {
        if (thisName != null || composite) {
            if (nullable) {
                this.sif(o + " != null");
            }
            if (thisName != null) {
                this.line(JMIUtil.refThis(thisName, o));
            }
            if (composite) {
                this.line("((ru.novosoft.mdf.impl.MDFObjectImpl)" + o + ").mdfSetElementContainer((ru.novosoft.mdf.ext.MDFFeatured)this,\"" + refName + "\");");
            }
            if (nullable) {
                this.eif();
            }
        }
    }

    protected void genRefThis(String nm, String o, boolean composite, String refRole) {
        this.genRefThis(nm, o, composite, refRole, false);
    }

    protected void genUnrefThis(String thisName, String o, boolean composite, String refName, boolean nullable) {
        if (thisName != null || composite) {
            if (nullable) {
                this.sif(o + " != null");
            }
            if (thisName != null) {
                this.line(this.unrefThis(thisName, o));
            }
            if (composite) {
                this.sif(o + ".refImmediateComposite() != null");
                this.line("((ru.novosoft.mdf.impl.MDFObjectImpl)" + o + ").mdfSetElementContainer(null, null);");
                this.eif();
            }
            if (nullable) {
                this.eif();
            }
        }
    }

    protected void genUnrefThis(String nm, String o, boolean composite, String refName) {
        this.genUnrefThis(nm, o, composite, refName, false);
    }

    protected HashSet utilNotImpl(MofClass c, MofClass extCls) {
        HashSet<MofClass> notImpl = new HashSet<MofClass>();
        if (extCls != null) {
            HashSet sc1 = new HashSet();
            GenMM.getAllSupertypes(c, notImpl);
            GenMM.getAllSupertypes(extCls, sc1);
            notImpl.removeAll(sc1);
            notImpl.remove(extCls);
        }
        notImpl.add(c);
        return notImpl;
    }

    protected final String name(ModelElement m) {
        return this.getName(m);
    }

    protected String fieldsParamList(DataType dt) {
        StringBuffer buf = new StringBuffer();
        List fields = this.fields(dt);
        int j = 0;
        while (j < fields.size()) {
            StructureField f = (StructureField)fields.get(j);
            buf.append(this.type(f));
            buf.append(" ");
            buf.append(this.name((ModelElement)f));
            if (j != fields.size() - 1) {
                buf.append(", ");
            }
            ++j;
        }
        return buf.toString();
    }

    protected String methodInvokeParam(List attributes) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < attributes.size()) {
            Attribute at = (Attribute)attributes.get(i);
            buf.append(this.name((ModelElement)at));
            buf.append(i != attributes.size() - 1 ? ", " : "");
            ++i;
        }
        return buf.toString();
    }

    protected String fieldsParamInvokeList(StructureType dt) {
        StringBuffer buf = new StringBuffer();
        List fields = this.fields((DataType)dt);
        int i = 0;
        while (i < fields.size()) {
            StructureField field = (StructureField)fields.get(i);
            buf.append(this.name((ModelElement)field));
            buf.append(i != fields.size() - 1 ? ", " : "");
            ++i;
        }
        return buf.toString();
    }

    protected MofClass extendedClass(MofClass cl) {
        if (this.superTypes((Classifier)cl).size() == 0) {
            return null;
        }
        return (MofClass)this.superTypes((Classifier)cl).remove(0);
    }

    protected int upper(MultiplicityType mult) {
        return mult.getUpper();
    }

    protected int upper(TypedElement te) {
        if (te instanceof AssociationEnd) {
            return this.upper(((AssociationEnd)te).getMultiplicity());
        }
        if (te instanceof StructuralFeature) {
            return this.upper(((StructuralFeature)te).getMultiplicity());
        }
        throw new RuntimeException();
    }

    protected String colType(TypedElement te) {
        if (this.isOrdered(te)) {
            return "java.util.List";
        }
        return "java.util.Collection";
    }

    private void attrMutator(Attribute at) {
        MultiplicityType mt = at.getMultiplicity();
        int upper = mt.getUpper();
        int lower = mt.getLower();
        String param = this.type((StructuralFeature)at) + " newValue";
        if (upper == 1 && lower == 0) {
            this.line("public void " + JMIUtil.mutator(at, param) + " throws javax.jmi.reflect.JmiException;");
        } else if (upper == 1 && lower == 1) {
            this.line("public void " + JMIUtil.mutator(at, param) + " throws javax.jmi.reflect.JmiException;");
        }
    }

    protected void attrAccessor(Attribute at) {
    }

    protected void attrAccessor(Attribute at, MultiplicityType m, String ty) {
    }

    protected String convertObjectToExpression(Classifier cl, String expression) {
        if (cl instanceof DataType) {
            cl = JMIUtil.dereference(cl);
            if (JMIUtil.isStruct(cl)) {
                return "((" + this.type((StructureType)cl) + ")" + expression + ")";
            }
            if (JMIUtil.isEnum(cl)) {
                return "((" + this.type((EnumerationType)cl) + ")" + expression + ")";
            }
            if (JMIUtil.isString(cl)) {
                return "((String)" + expression + ")";
            }
            if (JMIUtil.isInteger(cl)) {
                return "(((Integer)(" + expression + ")).intValue())";
            }
            if (JMIUtil.isLong(cl)) {
                return "(((Long)(" + expression + ")).longValue())";
            }
            if (JMIUtil.isFloat(cl)) {
                return "(((Float)(" + expression + ")).floatValue())";
            }
            if (JMIUtil.isDouble(cl)) {
                return "(((Double)(" + expression + ")).doubleValue())";
            }
            if (JMIUtil.isBoolean(cl)) {
                return "(((Boolean)(" + expression + ")).booleanValue())";
            }
            throw new RuntimeException("Unknown typecode: " + cl);
        }
        if (cl instanceof MofClass) {
            return "((" + this.type((MofClass)cl) + ")" + expression + ")";
        }
        throw new RuntimeException("Unknown type: " + cl);
    }

    protected String convertExpressionToObject(Classifier cl, String p_expression) {
        block9: {
            block11: {
                block10: {
                    if (!(cl instanceof DataType)) break block9;
                    cl = JMIUtil.dereference(cl);
                    if (JMIUtil.isStruct(cl)) break block10;
                    if (JMIUtil.isEnum(cl)) break block10;
                    if (!JMIUtil.isString(cl)) break block11;
                }
                return p_expression;
            }
            if (JMIUtil.isInteger(cl)) {
                return "new Integer(" + p_expression + ")";
            }
            if (JMIUtil.isLong(cl)) {
                return "new Long(" + p_expression + ")";
            }
            if (JMIUtil.isFloat(cl)) {
                return "new Float(" + p_expression + ")";
            }
            if (JMIUtil.isDouble(cl)) {
                return "new Double(" + p_expression + ")";
            }
            if (JMIUtil.isBoolean(cl)) {
                return "new Boolean(" + p_expression + ")";
            }
            throw new RuntimeException("Unknown typecode: " + JMIUtil.getQualifiedName((ModelElement)cl));
        }
        if (cl instanceof MofClass) {
            return p_expression;
        }
        throw new RuntimeException("Unknown type: " + cl);
    }

    protected String castedType(Classifier type, String ot) {
        if (type instanceof MofClass) {
            return JMIUtil.implType((ModelElement)((MofClass)type));
        }
        return ot;
    }

    protected String castedType(Attribute at) {
        return this.castedType(at.getType(), this.type((StructuralFeature)at));
    }

    protected String castedType(AssociationEnd ae) {
        return this.castedType(ae.getType(), "<< ERROR >>");
    }

    private String unrefThis(String nm, String o) {
        return o + "." + JMIUtil.unref(nm, "this") + ";";
    }

    private String javaInterfacePackage(DataType dt) {
        if (dt.getContainer() instanceof MofClass) {
            return JMIUtil.javaInterfacePackage(dt.getContainer().getContainer());
        }
        return JMIUtil.javaInterfacePackage(dt.getContainer());
    }

    private String nameOfInterface(ModelElement m) {
        return JMIUtil.nameOfInterface(m);
    }

    protected static final String getName(JMIUtil jmi, ModelElement m) {
        String rc = (String)JMIUtil.tagValue(m, "javax.jmi.substituteName");
        if (rc != null) {
            return rc;
        }
        return m.getName();
    }

    public String type(MofClass c) {
        return JMIUtil.javaInterfacePackage(c.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)c);
    }

    public String type(Import c) {
        return JMIUtil.javaInterfacePackage(c.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)c);
    }

    public String type(Association c) {
        return JMIUtil.javaInterfacePackage(c.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)c);
    }

    public String type(MofException c) {
        Namespace ns = c.getContainer();
        if (ns instanceof MofClass) {
            return JMIUtil.javaInterfacePackage(c.getContainer().getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)c);
        }
        return JMIUtil.javaInterfacePackage(c.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)c);
    }

    public String type(MofPackage c) {
        return JMIUtil.javaInterfacePackage((Namespace)c) + "." + JMIUtil.nameOfInterface((ModelElement)c);
    }

    public String type(StructuralFeature sf) {
        Classifier type = sf.getType();
        MultiplicityType mt = sf.getMultiplicity();
        return this.type(type, mt);
    }

    public String type(Parameter p) {
        Classifier type = p.getType();
        MultiplicityType mt = p.getMultiplicity();
        return this.type(type, mt);
    }

    public String type(Constant c) {
        Classifier type = c.getType();
        MOFMultiplicityTypeImpl mt = new MOFMultiplicityTypeImpl(1, 1, false, false);
        return this.type(type, (MultiplicityType)mt);
    }

    public String type(AssociationEnd ae) {
        Classifier type = ae.getType();
        MultiplicityType mt = ae.getMultiplicity();
        return this.type(type, mt);
    }

    private String type(Classifier type, MultiplicityType mt) {
        if (type instanceof MofClass) {
            return this.type((MofClass)type);
        }
        if (type instanceof Association) {
            return this.type((Association)type);
        }
        if (type instanceof PrimitiveType) {
            return this.type((PrimitiveType)type, mt);
        }
        if (type instanceof EnumerationType) {
            return this.type((EnumerationType)type);
        }
        if (type instanceof StructureType) {
            return this.type((StructureType)type);
        }
        if (type instanceof CollectionType) {
            throw new RuntimeException("CollectionType isn't supported");
        }
        if (type instanceof AliasType) {
            return this.type((AliasType)type, mt);
        }
        throw new RuntimeException("type class is " + type.getClass());
    }

    public String type(PrimitiveType pt, MultiplicityType mt) {
        int upper = mt.getUpper();
        int lower = mt.getLower();
        if (upper == 1 && lower == 0) {
            return this.primitive(pt, true);
        }
        if (upper == 1 && lower == 1) {
            return this.primitive(pt, false);
        }
        return JMIUtil.javaCollectionInterface(mt);
    }

    public String type(EnumerationType type) {
        if (type.getContainer() instanceof MofPackage) {
            return JMIUtil.javaInterfacePackage(type.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)type);
        }
        return JMIUtil.javaInterfacePackage(type.getContainer().getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)type);
    }

    public String type(StructureType type) {
        if (type.getContainer() instanceof MofPackage) {
            return JMIUtil.javaInterfacePackage(type.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)type);
        }
        return JMIUtil.javaInterfacePackage(type.getContainer().getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)type);
    }

    public String type(StructureField field) {
        Classifier type = field.getType();
        MOFMultiplicityTypeImpl mt = new MOFMultiplicityTypeImpl(1, 1, false, false);
        return this.type(type, (MultiplicityType)mt);
    }

    public String type(AliasType alias, MultiplicityType mt) {
        Classifier type = JMIUtil.dereference((Classifier)alias);
        return this.type(type, mt);
    }

    private String primitive(PrimitiveType pt, boolean isObject) {
        if (JMIUtil.isInteger((Classifier)pt)) {
            return isObject ? "Integer" : "int";
        }
        if (JMIUtil.isFloat((Classifier)pt)) {
            return isObject ? "Float" : "float";
        }
        if (JMIUtil.isDouble((Classifier)pt)) {
            return isObject ? "Double" : "double";
        }
        if (JMIUtil.isBoolean((Classifier)pt)) {
            return isObject ? "Boolean" : "boolean";
        }
        if (JMIUtil.isLong((Classifier)pt)) {
            return isObject ? "Long" : "long";
        }
        if (JMIUtil.isString((Classifier)pt)) {
            return "String";
        }
        return null;
    }
}

