/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator.jmi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.Attribute;
import javax.jmi.model.Constant;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Operation;
import javax.jmi.model.ScopeKind;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.VisibilityKindEnum;
import ru.novosoft.mdf.generator.GenMM;
import ru.novosoft.mdf.generator.NameUtil;
import ru.novosoft.mdf.generator.jmi.GenMMInterfaceWriter;
import ru.novosoft.mdf.generator.jmi.GenMMOperationTemplate;
import ru.novosoft.mdf.generator.jmi.JMIUtil;

public final class GenMMClassProxy
extends GenMMInterfaceWriter {
    private JMIUtil jmi;
    private List attrs = new ArrayList();
    private HashSet attributes = new HashSet();
    private HashSet constants = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenMMClassProxy(GenMM g, MofClass c, JMIUtil jmi) throws IOException {
        super(g, JMIUtil.javaInterfacePackage(c.getContainer()), JMIUtil.nameOfInterface((ModelElement)c) + "Class.java", jmi);
        try {
            this.jmi = jmi;
            this.prolog();
            this.line("package " + JMIUtil.javaInterfacePackage(c.getContainer()) + ";");
            this.annotation();
            this.sline("public interface " + JMIUtil.nameOfInterface((ModelElement)c) + "Class ");
            this.println("extends javax.jmi.reflect.RefClass");
            this.sblock();
            this.collectAttributes(c);
            if (!c.isAbstract()) {
                this.noArgCreateMethod(c);
                if (this.attrs.size() > 0) {
                    this.argCreateMethod(c);
                }
            }
            this.createStructMethod(c);
            this.templates(c);
            this.templateOperation(c);
            this.eblock();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close();
            throw throwable;
        }
        this.close();
    }

    public void collectAttributes(MofClass c) {
        Iterator i = c.getSupertypes().iterator();
        while (i.hasNext()) {
            this.collectAttributes((MofClass)i.next());
        }
        Iterator i2 = c.getContents().iterator();
        while (i2.hasNext()) {
            Attribute at;
            Object o = i2.next();
            if (!(o instanceof Attribute) || this.attrs.contains(o) || (at = (Attribute)o).isDerived() || ScopeKindEnum.CLASSIFIER_LEVEL == at.getScope()) continue;
            this.attrs.add(at);
        }
    }

    public void templates(MofClass c) {
        Iterator i = c.getSupertypes().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            this.templates(cl);
        }
        Iterator i2 = c.getContents().iterator();
        while (i2.hasNext()) {
            Object o = i2.next();
            if (o instanceof Attribute && !this.attributes.contains(o)) {
                Attribute at = (Attribute)o;
                if (ScopeKindEnum.CLASSIFIER_LEVEL != at.getScope()) continue;
                this.attributes.add(at);
                this.attributeOperations(at, (ScopeKind)ScopeKindEnum.CLASSIFIER_LEVEL);
                continue;
            }
            if (!(o instanceof Constant) || this.constants.contains(o)) continue;
            Constant con = (Constant)o;
            this.constants.add(o);
            String v = con.getValue();
            StringBuffer buf = new StringBuffer(v);
            if (v.indexOf("\n") != -1) {
                buf.deleteCharAt(v.indexOf("\n"));
                buf.insert(v.indexOf("\n"), "\\n");
            }
            this.sline("public final " + this.type(con) + " ");
            this.print(NameUtil.getId3(this.getName((ModelElement)con)) + " = \"");
            this.println(buf.toString() + "\";");
        }
    }

    private void templateOperation(MofClass c) throws IOException {
        ArrayList<Operation> col = new ArrayList<Operation>();
        Iterator i = c.getContents().iterator();
        while (i.hasNext()) {
            Operation op;
            Object obj = i.next();
            if (!(obj instanceof Operation) || (op = (Operation)obj).getVisibility() != VisibilityKindEnum.PUBLIC_VIS || op.getScope() != ScopeKindEnum.CLASSIFIER_LEVEL) continue;
            col.add(op);
        }
        new GenMMOperationTemplate(col).signatures();
    }

    private void noArgCreateMethod(MofClass thisCls) {
        this.sline("public " + this.type(thisCls) + " create" + JMIUtil.nameOfInterface((ModelElement)thisCls));
        this.println("() throws javax.jmi.reflect.JmiException;");
    }

    private void argCreateMethod(MofClass cl) {
        String nm = this.type(cl);
        this.sline("public " + nm + " create" + JMIUtil.nameOfInterface((ModelElement)cl) + "(");
        int i = 0;
        while (i < this.attrs.size()) {
            Attribute at = (Attribute)this.attrs.get(i);
            MultiplicityType mt = at.getMultiplicity();
            int upper = mt.getUpper();
            int lower = mt.getLower();
            if (upper == 1 && lower == 0) {
                this.print(this.type((StructuralFeature)at));
            } else if (upper == 1 && lower == 1) {
                this.print(this.type((StructuralFeature)at));
            } else {
                this.print(JMIUtil.javaCollectionInterface((StructuralFeature)at));
            }
            this.print(" ");
            this.print(this.getName((ModelElement)at));
            if (i != this.attrs.size() - 1) {
                this.print(", ");
            }
            ++i;
        }
        this.println(") throws javax.jmi.reflect.JmiException;");
    }

    private void createStructMethod(MofClass c) {
        Iterator i = c.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof StructureType)) continue;
            StructureType dt = (StructureType)o;
            List fields = this.getFields(dt);
            this.sline("public " + JMIUtil.javaInterfacePackage(dt.getContainer().getContainer()));
            this.print("." + JMIUtil.nameOfInterface((ModelElement)dt));
            this.print(" create" + JMIUtil.nameOfInterface((ModelElement)dt) + "(");
            int j = 0;
            while (j < fields.size()) {
                StructureField f = (StructureField)fields.get(j);
                this.print(this.type(f) + " " + this.getName((ModelElement)f));
                if (j != fields.size() - 1) {
                    this.print(", ");
                }
                ++j;
            }
            this.println(") throws javax.jmi.reflect.JmiException;");
        }
    }

    protected void attrAccessor(Attribute at) {
        if (ScopeKindEnum.INSTANCE_LEVEL == at.getScope()) {
            return;
        }
        MultiplicityType mt = at.getMultiplicity();
        int upper = mt.getUpper();
        int lower = mt.getLower();
        if (upper == 1 && lower == 0) {
            this.line("public " + this.type((StructuralFeature)at) + " " + JMIUtil.accessor((StructuralFeature)at) + " throws javax.jmi.reflect.JmiException;");
        } else if (upper == 1 && lower == 1) {
            this.line("public " + this.type((StructuralFeature)at) + " " + JMIUtil.accessor((StructuralFeature)at) + " throws javax.jmi.reflect.JmiException;");
        } else {
            String c = JMIUtil.javaCollectionInterface(mt);
            this.line("public " + c + " " + JMIUtil.accessor((StructuralFeature)at) + ";");
        }
    }

    private void annotation() {
        this.println();
        this.println("/*");
        this.println(" * This interface has operations for any classifier-scoped");
        this.println(" * attributes, constants, operations, along with a factory");
        this.println(" * operation that give access to its instance objects");
        this.println(" */");
    }
}

