/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator.jmi;

import java.io.IOException;
import java.util.Iterator;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.ModelElement;
import javax.jmi.model.TypedElement;
import ru.novosoft.mdf.generator.GenMM;
import ru.novosoft.mdf.generator.jmi.GenMMInterfaceWriter;
import ru.novosoft.mdf.generator.jmi.JMIUtil;

public final class GenMMAssociation
extends GenMMInterfaceWriter {
    private JMIUtil jmi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenMMAssociation(GenMM g, Association c, JMIUtil jmi) throws IOException {
        super(g, JMIUtil.javaInterfacePackage(c.getContainer()), JMIUtil.nameOfInterface((ModelElement)c) + ".java", jmi);
        try {
            this.jmi = jmi;
            String nm = JMIUtil.nameOfInterface((ModelElement)c);
            this.prolog();
            this.line("package " + JMIUtil.javaInterfacePackage(c.getContainer()) + ";");
            this.annotation();
            this.sline("public interface " + nm + " extends javax.jmi.reflect.RefAssociation");
            this.println();
            this.sblock();
            AssociationEnd ae1 = null;
            AssociationEnd ae2 = null;
            Iterator i = c.getContents().iterator();
            while (i.hasNext()) {
                ModelElement m = (ModelElement)i.next();
                if (!(m instanceof AssociationEnd)) continue;
                if (ae1 == null) {
                    ae1 = (AssociationEnd)m;
                    continue;
                }
                ae2 = (AssociationEnd)m;
                break;
            }
            this.generateMethods(ae1, ae2);
            this.eblock();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.close();
            throw throwable;
        }
        this.close();
    }

    public void generateMethods(AssociationEnd ae1, AssociationEnd ae2) {
        String ty1 = this.type(ae1);
        String ty2 = this.type(ae2);
        String nm1 = JMIUtil.getName((ModelElement)ae1);
        String nm2 = JMIUtil.getName((ModelElement)ae2);
        String param1 = ty2 + " " + this.vname(nm2);
        String param2 = ty1 + " " + this.vname(nm1);
        String throwsStr = " throws javax.jmi.reflect.JmiException";
        this.line("public boolean exists(" + ty1 + " " + this.vname(nm1) + ", " + ty2 + " " + this.vname(nm2) + ")" + throwsStr + ";");
        if (JMIUtil.isSingle(ae1) && ae1.isNavigable()) {
            this.line("public " + ty1 + " " + JMIUtil.getter(nm1, param1) + throwsStr + ";");
        }
        if (JMIUtil.isSingle(ae2) && ae2.isNavigable()) {
            this.line("public " + ty2 + " " + JMIUtil.getter(nm2, param2) + throwsStr + ";");
        }
        if (JMIUtil.isMulti(ae1)) {
            if (!JMIUtil.isOrdered((TypedElement)ae1) && ae1.isNavigable()) {
                this.line("public java.util.Collection " + JMIUtil.getter(nm1, param1) + throwsStr + ";");
            }
        }
        if (JMIUtil.isMulti(ae2)) {
            if (!JMIUtil.isOrdered((TypedElement)ae2) && ae2.isNavigable()) {
                this.line("public java.util.Collection " + JMIUtil.getter(nm2, param2) + throwsStr + ";");
            }
        }
        if (JMIUtil.isMulti(ae1)) {
            if (JMIUtil.isOrdered((TypedElement)ae1) && ae1.isNavigable()) {
                this.line("public java.util.List " + JMIUtil.getter(nm1, param1) + throwsStr + ";");
            }
        }
        if (JMIUtil.isMulti(ae2)) {
            if (JMIUtil.isOrdered((TypedElement)ae2) && ae2.isNavigable()) {
                this.line("public java.util.List " + JMIUtil.getter(nm2, param2) + throwsStr + ";");
            }
        }
        if (ae1.isChangeable() && ae2.isChangeable()) {
            this.line("public boolean add(" + ty1 + " " + this.vname(nm1) + ", " + ty2 + " " + this.vname(nm2) + ")" + throwsStr + ";");
            this.line("public boolean remove(" + ty1 + " " + this.vname(nm1) + ", " + ty2 + " " + this.vname(nm2) + ")" + throwsStr + ";");
        }
    }

    private void annotation() {
        this.println();
        this.println("/*");
        this.println(" * This interface contains the interface operations");
        this.println(" * for accessing and updating the association's link");
        this.println(" * set");
        this.println(" */");
    }
}

