/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jmi.model.AggregationKindEnum;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.DataType;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.TypedElement;
import ru.novosoft.mdf.ext.MDFObject;
import ru.novosoft.mdf.ext.MDFOutermostPackage;
import ru.novosoft.mdf.generator.GenMM;
import ru.novosoft.mdf.generator.NameUtil;
import ru.novosoft.mdf.generator.impl.GenMMImplWriter;
import ru.novosoft.mdf.generator.jmi.JMIUtil;
import ru.novosoft.mdf.mof.MOF;

public class GenMMImplXMIWriterSAX2
extends GenMMImplWriter {
    Set usedNamespaces = new HashSet();
    Set usedStructs = new HashSet();
    Set trackedClasses = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenMMImplXMIWriterSAX2(GenMM g, MDFOutermostPackage r, JMIUtil jmi) throws IOException {
        super(g, g.getProperty("impl.repository.package"), g.getProperty("impl.repository.name") + "XMIWriter.java", jmi);
        String nm = g.getProperty("impl.repository.name") + "XMIWriter";
        try {
            this.prolog();
            this.line("package " + g.getProperty("impl.repository.package") + ";");
            this.line("import ru.novosoft.mdf.impl.*;");
            this.line("import javax.jmi.xmi.*;");
            this.line("import ru.novosoft.mdf.ext.*;");
            this.line("import ru.novosoft.mdf.impl.xmi.writers.*;");
            this.line("import org.xml.sax.*;");
            this.line("import org.xml.sax.helpers.*;");
            this.line("import java.util.*;");
            this.println();
            this.line("public final class " + nm + " extends ru.novosoft.mdf.impl.XMI11WriterSAX2");
            this.sblock();
            this.line("public " + nm + "()");
            this.sblock();
            this.eblock();
            this.println();
            this.generateProcessContentAsElements();
            this.println();
            this.generateAssociations();
            this.println();
            this.generateGetValueForEnum();
            this.println();
            this.generateCollectAttributes();
            this.println();
            this.generateGetElementName();
            this.println();
            this.generateUsedStructs();
            this.println();
            this.generateUsedNamespaces();
            this.println();
            this.generateForceNSInfo();
            this.eblock();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.close();
            throw throwable;
        }
        this.close();
    }

    public String getXMINamespace(ModelElement cl) {
        String rc = (String)JMIUtil.tagValue(cl, "org.omg.xmi.namespace");
        if (rc == null) {
            rc = this.getGenerator().getProperty("org.omg.xmi.namespace." + this.getName(cl));
        }
        if (rc != null) {
            this.usedNamespaces.add(rc);
            return rc;
        }
        if (cl.getContainer() != null) {
            return this.getXMINamespace((ModelElement)cl.getContainer());
        }
        throw new RuntimeException("Model is possibly incomplete, no namespace for package: " + this.getName((ModelElement)cl.getContainer()));
    }

    public void generateGetValueForEnum() {
        this.println();
        this.line("/**");
        this.line(" * Returns string presentation of enumeration value.");
        this.line(" * ");
        this.line(" * @param val     enumeration value");
        this.line(" * @return        string presentation of enumeration value");
        this.line(" */");
        this.line("protected String getValueForEnum( Object val )");
        this.sblock();
        Iterator i = this.getGenerator().getAllEnumerationTypes().iterator();
        while (i.hasNext()) {
            EnumerationType dt = (EnumerationType)i.next();
            Iterator j = dt.getLabels().iterator();
            while (j.hasNext()) {
                String l = (String)j.next();
                String lnm = JMIUtil.unprefixEnumLabel((DataType)dt, l);
                this.sif("val == " + JMIUtil.javaInterfacePackage(dt.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)dt) + "Enum." + NameUtil.getId3(lnm));
                this.line("return \"" + lnm + "\";");
                this.eif();
            }
        }
        this.line("String msg = mdfOutermostPackage.formatLocalizedString(\"XMI11WriterSAX2_UnknownEnumVal\", val);");
        this.line("throw new RuntimeException(msg);");
        this.eblock();
    }

    public void generateCollectAttributes() {
        this.println();
        this.line("/**");
        this.line(" * Perform collecting all element references and attributes. It's added into 'xe'");
        this.line(" * parameter.");
        this.line(" * ");
        this.line(" * @param me      element whose references and attributes are collecting.");
        this.line(" * @param xe      attributes buffer where element references and attributes are added.");
        this.line(" * @exception     SAXException");
        this.line(" * @author        dida");
        this.line(" */");
        this.line("protected void collectAttributes( MDFObject me, AttributesImpl xe ) throws SAXException");
        this.sblock();
        this.line("ru.novosoft.mdf.ext.MDFClass proxy = null;");
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            String jt = this.type(cl);
            String ns = this.getXMINamespace((ModelElement)cl);
            String uri = ns + "_NAMESPACE_URI";
            boolean isEmpty = true;
            int proxy = 0;
            if (this.trackedClasses.contains(cl)) {
                isEmpty = false;
                this.sif("me instanceof " + jt);
                this.line(this.getExtentName(cl) + ".add(me);");
            }
            Iterator j = cl.getContents().iterator();
            while (j.hasNext()) {
                boolean isCol;
                boolean composite;
                MDFObject o = (MDFObject)j.next();
                if (!(o instanceof StructuralFeature)) continue;
                StructuralFeature sf = (StructuralFeature)o;
                boolean isClass = sf.getType() instanceof MofClass;
                String localname = "\"" + this.getName((ModelElement)cl) + "." + this.getName((ModelElement)sf) + "\"";
                String qname = "\"" + ns + ":" + this.getName((ModelElement)cl) + "." + this.getName((ModelElement)sf) + "\"";
                if (o instanceof Reference) {
                    Reference r = (Reference)o;
                    AssociationEnd oe = JMIUtil.oppositeEnd(r.getReferencedEnd());
                    if (((Association)oe.getContainer()).isDerived()) continue;
                    composite = AggregationKindEnum.COMPOSITE == oe.getAggregation() || AggregationKindEnum.COMPOSITE == r.getReferencedEnd().getAggregation();
                } else {
                    Attribute a;
                    if (!(o instanceof Attribute) || (a = (Attribute)o).isDerived()) continue;
                    composite = isClass;
                }
                boolean bl = isCol = sf.getMultiplicity().getUpper() != 1;
                if (composite) continue;
                if (isClass) {
                    proxy = this.lineProxy(sf, proxy);
                    if (isEmpty) {
                        this.sif("me instanceof " + jt);
                    }
                    isEmpty = false;
                    String pm = isCol ? "processReferenceList" : "processReference";
                    this.sline(pm + "(xe, \"" + this.getName((ModelElement)sf) + "\", ((" + jt);
                    this.print(this.isInstance(sf) ? ")me)." : "Class)proxy).");
                    this.println(JMIUtil.getter(this.getName((ModelElement)sf)) + " );");
                    continue;
                }
                DataType dt = (DataType)JMIUtil.dereference(sf.getType());
                if (isCol) continue;
                if (isEmpty) {
                    this.sif("me instanceof " + jt);
                }
                isEmpty = false;
                if (JMIUtil.isString((Classifier)dt)) {
                    proxy = this.lineProxy(sf, proxy);
                    this.sline("processString(xe, \"" + this.getName((ModelElement)sf) + "\", ((" + jt);
                    this.print(this.isInstance(sf) ? ")me)." : "Class)proxy).");
                    this.println(JMIUtil.accessor(sf) + " );");
                    continue;
                }
                if (JMIUtil.isBoolean((Classifier)dt)) {
                    proxy = this.lineProxy(sf, proxy);
                    this.sline("processBoolean(xe, \"" + this.getName((ModelElement)sf) + "\", ((" + jt);
                    this.print(this.isInstance(sf) ? ")me)." : "Class)proxy).");
                    this.println(JMIUtil.accessor(sf) + " );");
                    continue;
                }
                if (JMIUtil.isInteger((Classifier)dt)) {
                    proxy = this.lineProxy(sf, proxy);
                    this.sline("processInt(xe, \"" + this.getName((ModelElement)sf) + "\", ((" + jt);
                    this.print(this.isInstance(sf) ? ")me)." : "Class)proxy).");
                    this.println(JMIUtil.accessor(sf) + " );");
                    continue;
                }
                if (JMIUtil.isLong((Classifier)dt)) {
                    proxy = this.lineProxy(sf, proxy);
                    this.sline("processLong(xe, \"" + this.getName((ModelElement)sf) + "\", ((" + jt);
                    this.print(this.isInstance(sf) ? ")me)." : "Class)proxy).");
                    this.println(JMIUtil.accessor(sf) + " );");
                    continue;
                }
                if (JMIUtil.isFloat((Classifier)dt)) {
                    proxy = this.lineProxy(sf, proxy);
                    this.sline("processFloat(xe, \"" + this.getName((ModelElement)sf) + "\", ((" + jt);
                    this.print(this.isInstance(sf) ? ")me)." : "Class)proxy).");
                    this.println(JMIUtil.accessor(sf) + " );");
                    continue;
                }
                if (JMIUtil.isDouble((Classifier)dt)) {
                    proxy = this.lineProxy(sf, proxy);
                    this.sline("processDouble(xe, \"" + this.getName((ModelElement)sf) + "\", ((" + jt);
                    this.print(this.isInstance(sf) ? ")me)." : "Class)proxy).");
                    this.println(JMIUtil.accessor(sf) + " );");
                    continue;
                }
                if (JMIUtil.isEnum(dt)) {
                    proxy = this.lineProxy(sf, proxy);
                    this.sline("processEnum(xe, \"" + this.getName((ModelElement)sf) + "\", ((" + jt);
                    this.print(this.isInstance(sf) ? ")me)." : "Class)proxy).");
                    this.println(JMIUtil.accessor(sf) + " );");
                    continue;
                }
                if (JMIUtil.isStruct(dt)) continue;
                throw new RuntimeException("do not know how to handle " + dt);
            }
            if (isEmpty) continue;
            this.eif();
        }
        this.eblock();
    }

    private int lineProxy(StructuralFeature sf, int proxy) {
        if (!this.isInstance(sf) && proxy++ == 0) {
            this.line("proxy = (ru.novosoft.mdf.ext.MDFClass)me.refClass();");
        }
        return proxy;
    }

    public void generateForceNSInfo() {
        this.line("/**");
        this.line(" * Returns element_prefix/element_uri string pair array. This values");
        this.line(" * are given in the config.prp file and read from it as properties.");
        this.line(" * ");
        this.line(" * @return     prefix/uri string pair array.");
        this.line(" * @author     dida");
        this.line(" */");
        this.line("protected String[][] forceNSInfo()");
        this.sblock();
        this.line("return new String[][]{");
        Iterator i = this.usedNamespaces.iterator();
        while (i.hasNext()) {
            String pfx = (String)i.next();
            String ns = this.getGenerator().getProperty("impl.xmi.namespace.map." + pfx);
            if (i.hasNext()) {
                this.line("{" + pfx + "_NAMESPACE_PREFIX, " + pfx + "_NAMESPACE_URI}, ");
                continue;
            }
            this.line("{" + pfx + "_NAMESPACE_PREFIX, " + pfx + "_NAMESPACE_URI}");
        }
        this.line("};");
        this.eblock();
    }

    public void generateProcessContentAsElements() {
        this.println();
        this.line("/**");
        this.line(" * Processes element content and writes it as element.");
        this.line(" * ");
        this.line(" * @param me      mdf element whose content need be processed.");
        this.line(" * @exception     SAXException");
        this.line(" * @author        dida");
        this.line(" */");
        this.line("protected void processContentAsElements( MDFObject me) throws SAXException");
        this.sblock();
        this.line("ru.novosoft.mdf.ext.MDFClass proxy = null;");
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            String ns = this.getXMINamespace((ModelElement)cl);
            String uri = ns + "_NAMESPACE_URI";
            int empty = 0;
            int proxy = 0;
            if (this.trackedClasses.contains(cl)) {
                ++empty;
                this.sif("me instanceof " + this.type(cl));
                this.line(this.getExtentName(cl) + ".add(me);");
            }
            Iterator j = cl.getContents().iterator();
            while (j.hasNext()) {
                boolean isCol;
                boolean composite;
                MDFObject o;
                if (empty++ == 0) {
                    this.sif("me instanceof " + this.type(cl));
                    this.line(this.type(cl) + " ce = (" + this.type(cl) + ")me;");
                }
                if (!((o = (MDFObject)j.next()) instanceof StructuralFeature)) continue;
                StructuralFeature sf = (StructuralFeature)o;
                String localname = "\"" + cl.getName() + "." + this.getName((ModelElement)sf) + "\"";
                String qname = "\"" + ns + ":" + cl.getName() + "." + this.getName((ModelElement)sf) + "\"";
                String mnm = JMIUtil.accessor(sf);
                boolean isClass = sf.getType() instanceof MofClass;
                if (o instanceof Reference) {
                    Reference r = (Reference)o;
                    AssociationEnd oe = JMIUtil.oppositeEnd(r.getReferencedEnd());
                    if (((Association)oe.getContainer()).isDerived()) continue;
                    composite = AggregationKindEnum.COMPOSITE == oe.getAggregation();
                } else {
                    Attribute a;
                    if (!(o instanceof Attribute) || (a = (Attribute)o).isDerived()) continue;
                    composite = isClass;
                }
                boolean bl = isCol = sf.getMultiplicity().getUpper() != 1;
                if (composite) {
                    String pm;
                    String string = pm = isCol ? "processOwnedElements" : "processOwnedElement";
                    if (!this.isInstance(sf) && proxy++ == 0) {
                        this.line("proxy = (ru.novosoft.mdf.ext.MDFClass)me.refClass();");
                    }
                    this.sline(pm + "(" + uri + ", " + localname + ", " + qname + ", ((" + this.type(cl));
                    this.print(this.isInstance(sf) ? ")me)." : "Class)proxy).");
                    this.println(JMIUtil.getter(this.getName((ModelElement)sf)) + ");");
                    continue;
                }
                if (isClass) {
                    Classifier otype = ((Reference)sf).getReferencedEnd().getType();
                    String otypeName = "\"" + this.getName((ModelElement)otype) + "\"";
                    if (isCol) {
                        this.line("refListValuesAsElements(" + uri + ", " + localname + ", " + otypeName + ", ce." + mnm + ");");
                        continue;
                    }
                    this.line("refValueAsElement(" + uri + ", " + localname + ", " + otypeName + ", ce." + mnm + ");");
                    continue;
                }
                DataType dt = (DataType)JMIUtil.dereference(sf.getType());
                if (isCol) {
                    if (JMIUtil.isString((Classifier)dt)) {
                        this.sline("processStringCollection(" + uri + ", " + localname);
                        this.print(", " + qname + ", ((" + this.type(cl) + ")me).");
                        this.println(JMIUtil.getter(this.getName((ModelElement)sf)) + " );");
                        continue;
                    }
                }
                if (!this.isInstance(sf) && proxy++ == 0) {
                    this.line("proxy = (ru.novosoft.mdf.ext.MDFClass)me.refClass();");
                }
                String rci = ", ce." + mnm + ");";
                String rcp = ", ((" + this.type(cl) + "Class)proxy)." + mnm + ");";
                dt = (DataType)JMIUtil.dereference((Classifier)dt);
                if (JMIUtil.isString((Classifier)dt)) {
                    this.sline("stringValueAsElement(" + uri + ", " + localname);
                    this.println(this.isInstance(sf) ? rci : rcp);
                    continue;
                }
                if (JMIUtil.isBoolean((Classifier)dt)) {
                    this.sline("booleanValueAsElement(" + uri + ", " + localname);
                    this.println(this.isInstance(sf) ? rci : rcp);
                    continue;
                }
                if (JMIUtil.isInteger((Classifier)dt)) {
                    this.sline("intValueAsElement(" + uri + ", " + localname);
                    this.println(this.isInstance(sf) ? rci : rcp);
                    continue;
                }
                if (JMIUtil.isLong((Classifier)dt)) {
                    this.sline("longValueAsElement(" + uri + ", " + localname);
                    this.println(this.isInstance(sf) ? rci : rcp);
                    continue;
                }
                if (JMIUtil.isFloat((Classifier)dt)) {
                    this.sline("floatValueAsElement(" + uri + ", " + localname);
                    this.println(this.isInstance(sf) ? rci : rcp);
                    continue;
                }
                if (JMIUtil.isDouble((Classifier)dt)) {
                    this.sline("doubleValueAsElement(" + uri + ", " + localname);
                    this.println(this.isInstance(sf) ? rci : rcp);
                    continue;
                }
                if (JMIUtil.isEnum(dt)) {
                    this.sline("enumValueAsElement(" + uri + ", " + localname);
                    this.println(this.isInstance(sf) ? rci : rcp);
                    continue;
                }
                if (!JMIUtil.isStruct(dt)) continue;
                if (!this.isInstance(sf) && proxy++ == 0) {
                    this.line("proxy = (ru.novosoft.mdf.ext.MDFClass)me.refClass();");
                }
                this.usedStructs.add(dt);
                this.sline("processStruct(" + uri + ", " + localname + ", " + qname + ", ((" + this.type(cl));
                this.print(this.isInstance(sf) ? ")me)." : "Class)proxy).");
                this.println(JMIUtil.accessor(sf) + " );");
            }
            if (empty == 0) continue;
            this.eif();
        }
        this.eblock();
    }

    public void generateGetElementName() {
        this.line("/**");
        this.line(" * Initialize string array 'vals' by two values: class uri and class name.");
        this.line(" * ");
        this.line(" * @param cls      class, information about whose must be contains in 'vals'");
        this.line(" *                 after method performed.");
        this.line(" * @param vals     string array that must be initialized.");
        this.line(" * @author         dida");
        this.line(" */");
        this.line("protected void getElementName(Class cls, String[] vals)");
        this.sblock();
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            String uri = this.getXMINamespace((ModelElement)cl) + "_NAMESPACE_URI";
            this.sif("cls == " + this.type(cl) + ".class");
            this.line("vals[0] = " + uri + ";");
            this.line("vals[1] = \"" + cl.getName() + "\";");
            this.line("return;");
            this.eif();
        }
        this.eblock();
    }

    public void generateAssociations() {
        Collection allAssoc = this.getGenerator().getAllAssociations();
        HashSet<AssociationEnd> nrAes = new HashSet<AssociationEnd>();
        HashSet<AssociationEnd> ceAes = new HashSet<AssociationEnd>();
        Iterator i = allAssoc.iterator();
        while (i.hasNext()) {
            AssociationEnd oe;
            Association a = (Association)i.next();
            if (a.isDerived()) continue;
            AssociationEnd[] aes = MOF.getAssociationEnds(a);
            AssociationEnd ae1 = aes[0];
            AssociationEnd ae2 = aes[1];
            Reference r1 = JMIUtil.primaryReferenceTo(ae1);
            Reference r2 = JMIUtil.primaryReferenceTo(ae2);
            if (r1 == null && r2 == null) {
                AssociationEnd pe = null;
                pe = MOF.isOrdered(ae1) ? ae1 : (MOF.isOrdered(ae2) ? ae2 : (this.isComposite((TypedElement)ae1) ? ae2 : (this.isComposite((TypedElement)ae2) ? ae1 : ae1)));
                nrAes.add(pe);
                oe = JMIUtil.oppositeEnd(pe);
                if (this.trackedClasses.contains(oe.getType())) continue;
                this.trackedClasses.add(oe.getType());
                this.line("Set " + this.getExtentName(oe) + " = new HashSet();");
                continue;
            }
            if ((!this.isComposite((TypedElement)ae1) || r2 != null) && (!this.isComposite((TypedElement)ae2) || r1 != null)) continue;
            AssociationEnd ce = this.isComposite((TypedElement)ae1) ? ae1 : ae2;
            oe = JMIUtil.oppositeEnd(ce);
            if (!this.trackedClasses.contains(ce.getType())) {
                this.trackedClasses.add(ce.getType());
                this.line("Set " + this.getExtentName(ce) + " = new HashSet();");
            }
            ceAes.add(ce);
        }
        this.line("/**");
        this.line(" * Processes associations. It's invoked only after all model elements was processed.");
        this.line(" * ");
        this.line(" * @exception     SAXException");
        this.line(" * @author        cap & dida");
        this.line(" */");
        this.line("protected void processAssociations() throws SAXException");
        this.sblock();
        Iterator i2 = ceAes.iterator();
        while (i2.hasNext()) {
            AssociationEnd ce = (AssociationEnd)i2.next();
            AssociationEnd oe = JMIUtil.oppositeEnd(ce);
            Classifier cty = ce.getType();
            Classifier oty = oe.getType();
            Association a = (Association)ce.getContainer();
            String aty = this.type(a);
            String vnm = "assoc_" + aty.replace('.', '_');
            String cgt = "((" + JMIUtil.implType((ModelElement)cty) + ")obj)." + JMIUtil.getter(JMIUtil.genName((ModelElement)oe));
            this.sblock();
            this.sforeach(this.getExtentName(ce), this.type(ce), "obj");
            if (oe.getMultiplicity().getUpper() == 1) {
                this.line(this.type(oe) + " m  = " + cgt + ";");
                this.sif("m != null");
                this.line("xc.addContent(processElement(m));");
                this.eif();
            } else {
                this.line("processOwnedElements(" + cgt + ");");
            }
            this.eforeach();
            this.eblock();
        }
        Iterator i3 = nrAes.iterator();
        while (i3.hasNext()) {
            AssociationEnd pe = (AssociationEnd)i3.next();
            AssociationEnd oe = JMIUtil.oppositeEnd(pe);
            Classifier pty = pe.getType();
            Classifier oty = oe.getType();
            Association a = (Association)pe.getContainer();
            String aty = this.type(a);
            String vnm = "assoc_" + aty.replace('.', '_');
            String pgt = "((" + JMIUtil.implType((ModelElement)oty) + ")obj)." + JMIUtil.getter(JMIUtil.genName((ModelElement)pe));
            String uri = this.getXMINamespace((ModelElement)a) + "_NAMESPACE_URI";
            String enm = "\"" + this.getName((ModelElement)a) + "\"";
            String pnm = "\"" + this.getName((ModelElement)pe) + "\"";
            String onm = "\"" + this.getName((ModelElement)oe) + "\"";
            String olnm = "\"" + this.getName((ModelElement)a) + "." + this.getName((ModelElement)oe) + "\"";
            String plnm = "\"" + this.getName((ModelElement)a) + "." + this.getName((ModelElement)pe) + "\"";
            this.sblock();
            this.sforeach(this.getExtentName(oe), this.type(oe), "obj");
            if (pe.getMultiplicity().getUpper() == 1) {
                this.line("startLink(" + uri + ", " + enm + ", " + onm + ", obj, " + pnm + ", m);");
                this.line("refValueAsElement(" + uri + ", " + olnm + ", " + pnm + ", obj);");
                this.line("refValueAsElement(" + uri + ", " + plnm + ", " + onm + ", pgt);");
                this.line("endLink(" + uri + ", " + enm + ");");
            } else {
                this.sforeach(pgt, this.type(pe), "m");
                this.line("startLink(" + uri + ", " + enm + ", " + onm + ", obj, " + pnm + ", m);");
                this.line("refValueAsElement(" + uri + ", " + olnm + ", " + pnm + ", obj);");
                this.line("refValueAsElement(" + uri + ", " + plnm + ", " + onm + ", m);");
                this.line("endLink(" + uri + ", " + enm + ");");
                this.eforeach();
            }
            this.eforeach();
            this.eblock();
        }
        this.eblock();
    }

    private String getExtentName(AssociationEnd ae) {
        return "extent_" + this.type(ae).replace('.', '_');
    }

    private String getExtentName(MofClass c) {
        return "extent_" + this.type(c).replace('.', '_');
    }

    void generateUsedStructs() {
        Iterator i = this.usedStructs.iterator();
        while (i.hasNext()) {
            StructureType dt = (StructureType)i.next();
            this.println();
            this.line("/**");
            this.line(" * Processes structs.");
            this.line(" * ");
            this.line(" * @param uri           struct owner element uri");
            this.line(" * @param localName     struct name in form 'class_name.struct_name'");
            this.line(" * @param qName         full struct name in form 'prefix:local_name'");
            this.line(" * @param arg           struct value");
            this.line(" * @exception           SAXException");
            this.line(" */");
            this.line("protected void processStruct( String uri, String localName, String qName, " + this.type(dt) + " arg) throws SAXException");
            this.sblock();
            this.line("createStartFieldElement(uri, localName, qName);");
            Iterator j = this.getFields(dt).iterator();
            while (j.hasNext()) {
                StructureField f = (StructureField)j.next();
                this.line("processField( arg." + JMIUtil.accessor(f) + ");");
            }
            this.line("createEndFieldElement(uri, localName, qName);");
            this.eblock();
        }
    }

    void generateUsedNamespaces() {
        Iterator i = this.usedNamespaces.iterator();
        while (i.hasNext()) {
            String pfx = (String)i.next();
            String ns = this.getGenerator().getProperty("impl.xmi.namespace.map." + pfx);
            if (ns == null || ns.equals("")) {
                throw new RuntimeException("namespace is null or empty : " + pfx + "_NAMESPACE.put( \"uri\", \"" + ns + "\");");
            }
            this.line("public static final String " + pfx + "_NAMESPACE_PREFIX = \"" + pfx + "\";");
            this.line("public static final String " + pfx + "_NAMESPACE_URI = \"" + ns + "\";");
        }
    }

    private final boolean isInstance(StructuralFeature sf) {
        return ScopeKindEnum.INSTANCE_LEVEL == sf.getScope();
    }

    private boolean sifIsEmpty(boolean isEmpty, String jt) {
        if (isEmpty) {
            this.sif("me instanceof " + jt);
            return false;
        }
        return false;
    }
}

