/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jmi.model.AggregationKindEnum;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.DataType;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import ru.novosoft.mdf.ext.MDFObject;
import ru.novosoft.mdf.ext.MDFOutermostPackage;
import ru.novosoft.mdf.generator.GenMM;
import ru.novosoft.mdf.generator.impl.GenMMImplWriter;
import ru.novosoft.mdf.generator.jmi.JMIUtil;

public class GenMMImplXMIReaderSAX2
extends GenMMImplWriter {
    Set usedNamespaces = new HashSet();
    Set usedStructs = new HashSet();
    Set allowedReferences = new HashSet();
    Set referencelessAssociations = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenMMImplXMIReaderSAX2(GenMM g, MDFOutermostPackage r, JMIUtil jmi) throws IOException {
        super(g, g.getProperty("impl.repository.package"), g.getProperty("impl.repository.name") + "XMIReader.java", jmi);
        String nm = g.getProperty("impl.repository.name") + "XMIReader";
        try {
            this.prolog();
            this.line("package " + g.getProperty("impl.repository.package") + ";");
            this.line("import ru.novosoft.mdf.impl.*;");
            this.line("import ru.novosoft.mdf.ext.*;");
            this.line("import javax.jmi.xmi.*;");
            this.line("import java.lang.reflect.*;");
            this.line("import org.xml.sax.*;");
            this.line("import org.xml.sax.helpers.*;");
            this.line("import java.util.*;");
            this.println();
            this.line("public final class " + nm + " extends ru.novosoft.mdf.impl.XMI11ReaderSAX2");
            this.sblock();
            this.line("public " + nm + "()");
            this.sblock();
            this.eblock();
            this.collectUsedStructs();
            this.collectXMINamespaces();
            this.prepareReferences();
            this.generateProcessAssociationAttributes();
            this.generateGetAssociationClass();
            this.generateProcessElementAttributes();
            this.generateAttributeSetting();
            this.generateReferenceSetting();
            this.generateCreateStateByName();
            this.generateCreateMDFObject();
            this.generateGetStructObject();
            this.generateGetEnumValue();
            this.generateUsedNamespaces();
            this.generateForName();
            this.eblock();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.close();
            throw throwable;
        }
        this.close();
    }

    public String getXMINamespace(ModelElement cl) {
        String rc = (String)JMIUtil.tagValue(cl, "org.omg.xmi.namespace");
        if (rc == null) {
            rc = this.getGenerator().getProperty("org.omg.xmi.namespace." + this.getName(cl));
        }
        if (rc != null) {
            this.usedNamespaces.add(rc);
            return rc;
        }
        if (cl.getContainer() != null) {
            return this.getXMINamespace((ModelElement)cl.getContainer());
        }
        throw new RuntimeException("Model is possibly incomplete, no namespace for package: " + this.getName((ModelElement)cl.getContainer()));
    }

    public void generateGetAssociationClass() {
        this.println();
        this.line("public Class getAssociationClass(String uri, String name)");
        this.sblock();
        if (this.referencelessAssociations.size() == 0) {
            this.line("return null;");
            this.eblock();
            return;
        }
        Iterator it = this.usedNamespaces.iterator();
        while (it.hasNext()) {
            String ns = (String)it.next();
            String uri = ns + "_NAMESPACE_URI";
            this.sif(uri + ".equals(uri)");
            Iterator i = this.referencelessAssociations.iterator();
            while (i.hasNext()) {
                Association a = (Association)i.next();
                if (!this.getXMINamespace((ModelElement)a).equals(ns)) continue;
                this.sif("\"" + this.getName((ModelElement)a) + "\".equals(name)");
                this.line("return " + this.type(a) + ".class;");
                this.eif();
            }
            this.eif();
        }
        this.line("String msg = mdfOutermostPackage.formatLocalizedString(\"XMI11ReaderSAX2_UnknownAssoc\", uri, name);");
        this.line("throw new RuntimeException(msg);");
        this.eblock();
    }

    public void generateProcessAssociationAttributes() {
        this.println();
        this.line("public boolean processAssociationAttributes(Attributes attrs, Class cl)");
        this.sblock();
        Iterator i = this.referencelessAssociations.iterator();
        while (i.hasNext()) {
            Association a = (Association)i.next();
            String jt = this.type(a);
            this.sif("cl == " + jt + ".class");
            Iterator j = a.getContents().iterator();
            while (j.hasNext()) {
                Object o = j.next();
                if (!(o instanceof AssociationEnd)) continue;
                AssociationEnd te = (AssociationEnd)o;
                AssociationEnd oe = JMIUtil.oppositeEnd(te);
                String teName = this.getName((ModelElement)te);
                String oeName = this.getName((ModelElement)oe);
                String teJt = this.type(te);
                String oeJt = this.type(oe);
                this.line(teJt + " teObj = (" + teJt + ")id2obj.get(attrs.getValue(\"\",\"" + teName + "\"));");
                this.line(oeJt + " oeObj = (" + oeJt + ")id2obj.get(attrs.getValue(\"\",\"" + oeName + "\"));");
                String ascName = "asc_" + jt.replace('.', '_');
                this.sif("teObj != null && oeObj != null");
                this.line(jt + " " + ascName + " = (" + jt + ")mdfOutermostPackage.getMetaObject(cl);");
                this.line(ascName + ".add(teObj, oeObj);");
                this.line("return true;");
                this.eif();
                break;
            }
            this.eif();
        }
        this.line("return false;");
        this.eblock();
    }

    public void collectUsedStructs() {
        Iterator i = this.getGenerator().getAllStructureTypes().iterator();
        while (i.hasNext()) {
            StructureType dt = (StructureType)i.next();
            if (!JMIUtil.isStruct(dt)) continue;
            this.usedStructs.add(dt);
        }
    }

    public void generateCreateMDFObject() {
        this.println();
        this.line("public MDFObject createMDFObject( String uri, String localName )");
        this.sblock();
        Iterator it = this.usedNamespaces.iterator();
        while (it.hasNext()) {
            String ns = (String)it.next();
            String uri = ns + "_NAMESPACE_URI";
            this.sif(uri + ".equals(uri)");
            Iterator i = this.getGenerator().getAllClasses().iterator();
            while (i.hasNext()) {
                MofClass cl = (MofClass)i.next();
                if (cl.isAbstract() || !this.getXMINamespace((ModelElement)cl).equals(ns)) continue;
                this.sif("\"" + cl.getName() + "\".equals(localName)");
                this.line("return mdfOutermostPackage.create(" + this.type(cl) + ".class);");
                this.eif();
            }
            this.eif();
        }
        this.line("return null;");
        this.eblock();
    }

    public void generateReferenceSetting() {
        this.println();
        this.line("public void referenceSetting(MDFObject e, Attributes attrs)");
        this.sblock();
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            String jt = this.type(cl);
            boolean isEmpty = true;
            Iterator j = cl.getContents().iterator();
            while (j.hasNext()) {
                Reference ref;
                Object o = j.next();
                if (!(o instanceof Reference) || (ref = (Reference)o).getContainer() != cl || !this.allowedReferences.contains(ref) || this.isComposite(ref)) continue;
                if (isEmpty) {
                    this.sif("e instanceof " + jt);
                    isEmpty = false;
                }
                String name = this.getName((ModelElement)ref);
                AssociationEnd oe = ref.getReferencedEnd();
                MultiplicityType mult = oe.getMultiplicity();
                if (mult.getUpper() != 0 && mult.getUpper() != 1) {
                    if (mult.isOrdered()) {
                        this.line("deferLinkingList(e, attrs, \"" + name + "\");");
                        continue;
                    }
                    if (mult.isOrdered() || !mult.isUnique()) continue;
                    this.line("deferLinkingSet(e, attrs, \"" + name + "\");");
                    continue;
                }
                this.line("deferLinkingRef(e, attrs, \"" + name + "\");");
            }
            if (isEmpty) continue;
            this.eif();
        }
        this.eblock();
    }

    public void generateProcessElementAttributes() {
        this.println();
        this.line("public void processElementAttributes(MDFObject e, Attributes attrs)");
        this.sblock();
        this.line("ru.novosoft.mdf.ext.MDFClass proxy = null;");
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            int empty = 0;
            int proxyCount = 0;
            Iterator j = cl.getContents().iterator();
            while (j.hasNext()) {
                AssociationEnd oe;
                MultiplicityType mult;
                Reference ref;
                Object o = j.next();
                if (o instanceof Attribute) {
                    Attribute at = (Attribute)o;
                    if (!at.isChangeable() || at.getContainer() != cl || at.isDerived()) continue;
                    if (empty++ == 0) {
                        this.sif("e instanceof " + this.type(cl));
                    }
                    if (at.getScope() == ScopeKindEnum.CLASSIFIER_LEVEL && proxyCount++ == 0) {
                        this.line("proxy = (ru.novosoft.mdf.ext.MDFClass)e.refClass();");
                    }
                    this.genAttrSetting(at);
                    continue;
                }
                if (!(o instanceof Reference) || (ref = (Reference)o).getContainer() != cl || !this.allowedReferences.contains(ref) || this.isComposite(ref)) continue;
                if (empty++ == 0) {
                    this.sif("e instanceof " + this.type(cl));
                }
                if ((mult = (oe = ref.getReferencedEnd()).getMultiplicity()).getUpper() != 0 && mult.getUpper() != 1) {
                    if (mult.isOrdered()) {
                        this.line("deferLinkingList(e, attrs, \"" + this.getName((ModelElement)ref) + "\");");
                        continue;
                    }
                    if (mult.isOrdered() || !mult.isUnique()) continue;
                    this.line("deferLinkingSet(e, attrs, \"" + this.getName((ModelElement)ref) + "\");");
                    continue;
                }
                this.line("deferLinkingRef(e, attrs, \"" + this.getName((ModelElement)ref) + "\");");
            }
            if (empty == 0) continue;
            this.eif();
        }
        this.eblock();
    }

    public void generateCreateStateByName() {
        this.println();
        this.line("public void createStateByName(String uri, String name, Attributes attrs)");
        this.sblock();
        this.line("int dotPos = name.indexOf('.');");
        this.line("String clsName = name.substring(0, dotPos);");
        this.line("String propName = name.substring(dotPos + 1);");
        Iterator it = this.usedNamespaces.iterator();
        while (it.hasNext()) {
            String pfx = (String)it.next();
            String uri = pfx + "_NAMESPACE_URI";
            this.sif(uri + ".equals(uri)");
            Iterator i = this.getGenerator().getAllClasses().iterator();
            while (i.hasNext()) {
                MofClass cl = (MofClass)i.next();
                if (!this.getXMINamespace((ModelElement)cl).equals(pfx) || this.getAllReferences(cl).size() == 0 && this.getAllAttributes(cl).size() == 0) continue;
                this.sif("\"" + cl.getName() + "\".equals(clsName)");
                this.gen4References(cl);
                this.gen4Attributes(cl);
                this.eif();
            }
            this.eif();
        }
        this.eblock();
    }

    public void generateGetStructObject() {
        this.println();
        this.line("public MDFStruct getStructObject(Class cl, List fields)");
        this.sblock();
        HashSet<String> classes = new HashSet<String>();
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            Iterator j = cl.getContents().iterator();
            while (j.hasNext()) {
                StructuralFeature sf;
                Classifier type;
                Object o = j.next();
                if (!(o instanceof StructuralFeature) || !((type = (sf = (StructuralFeature)o).getType()) instanceof DataType)) continue;
                DataType dt = (DataType)JMIUtil.dereference((Classifier)((DataType)type));
                if (!JMIUtil.isStruct(dt)) continue;
                StructureType struct = (StructureType)dt;
                String name = "\"" + this.getName((ModelElement)cl) + "." + this.getName((ModelElement)sf) + "\"";
                String jt = this.type(struct);
                if (!classes.add(jt)) continue;
                this.sif("cl == " + jt + ".class");
                this.sline("return new " + JMIUtil.implType((ModelElement)dt) + "(");
                List fields = this.getFields(struct);
                int k = 0;
                while (k < fields.size()) {
                    StructureField field = (StructureField)fields.get(k);
                    String ty = this.type(field);
                    String nm = this.getName((ModelElement)field);
                    if (JMIUtil.isBoolean(field.getType())) {
                        this.print("Boolean.valueOf( (String)fields.get(" + k + ") ).booleanValue()");
                    } else if (JMIUtil.isString(field.getType())) {
                        this.print("(String)fields.get(" + k + ")");
                    } else if (JMIUtil.isInteger(field.getType())) {
                        this.print("Integer.parseInt( (String)fields.get(" + k + "))");
                    } else if (JMIUtil.isLong(field.getType())) {
                        this.print("Long.longValue((String)fields.get(" + k + "))");
                    } else if (JMIUtil.isFloat(field.getType())) {
                        this.print("Float.floatValue((String)fields.get( " + k + " ))");
                    } else if (JMIUtil.isDouble(field.getType())) {
                        this.print("Double.doubleValue((String)fields.get( " + k + " ))");
                    }
                    if (k != fields.size() - 1) {
                        this.print(", ");
                    }
                    ++k;
                }
                this.println(");");
                this.eif();
            }
        }
        this.line("String msg = mdfOutermostPackage.formatLocalizedString(\"XMI11ReaderSAX2_UnknownStruct\", cl);");
        this.line("throw new RuntimeException(msg);");
        this.eblock();
    }

    public void generateAttributeSetting() {
        this.println();
        this.line("public void attributeSetting(MDFObject e, Attributes attrs)");
        this.sblock();
        this.line("ru.novosoft.mdf.ext.MDFClass proxy = null;");
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            int empty = 0;
            int proxyCount = 0;
            Iterator j = cl.getContents().iterator();
            while (j.hasNext()) {
                Attribute at;
                Object o = j.next();
                if (!(o instanceof Attribute) || !(at = (Attribute)o).isChangeable() || at.getContainer() != cl || at.isDerived()) continue;
                if (empty++ == 0) {
                    this.sif("e instanceof " + this.type(cl));
                }
                if (at.getScope() == ScopeKindEnum.CLASSIFIER_LEVEL && proxyCount++ == 0) {
                    this.line("proxy = (ru.novosoft.mdf.ext.MDFClass)e.refClass();");
                }
                this.genAttrSetting(at);
            }
            if (empty == 0) continue;
            this.eif();
        }
        this.eblock();
    }

    public void generateGetEnumValue() {
        this.println();
        this.line("public final Object getEnumValue(Class cl, String enumValue)");
        this.sblock();
        Iterator i = this.getGenerator().getAllEnumerationTypes().iterator();
        while (i.hasNext()) {
            EnumerationType dt = (EnumerationType)i.next();
            String jt = this.type(dt);
            this.sif("cl == " + jt + ".class");
            this.line("return forName(\"" + this.getName((ModelElement)dt) + "\", enumValue);");
            this.eif();
        }
        this.line("return null;");
        this.eblock();
    }

    void prepareReferences() {
        Iterator i = this.getGenerator().getAllAssociations().iterator();
        while (i.hasNext()) {
            Association a = (Association)i.next();
            if (a.isDerived()) continue;
            AssociationEnd ae1 = null;
            AssociationEnd ae2 = null;
            Iterator j = a.getContents().iterator();
            while (j.hasNext()) {
                MDFObject e = (MDFObject)j.next();
                if (!(e instanceof AssociationEnd)) continue;
                if (ae1 == null) {
                    ae1 = (AssociationEnd)e;
                    continue;
                }
                if (ae2 != null) continue;
                ae2 = (AssociationEnd)e;
                break;
            }
            Reference r1 = JMIUtil.primaryReferenceTo(ae1);
            Reference r2 = JMIUtil.primaryReferenceTo(ae2);
            Object r = null;
            if (r1 == null && r2 == null) {
                this.referencelessAssociations.add(a);
                continue;
            }
            if (r1 != null && r2 == null) {
                this.allowedReferences.add(r1);
                continue;
            }
            if (r2 != null && r1 == null) {
                this.allowedReferences.add(r2);
                continue;
            }
            if (AggregationKindEnum.COMPOSITE == ae1.getAggregation()) {
                this.allowedReferences.add(r2);
                continue;
            }
            if (AggregationKindEnum.COMPOSITE == ae2.getAggregation()) {
                this.allowedReferences.add(r1);
                continue;
            }
            MultiplicityType m1 = r1.getMultiplicity();
            MultiplicityType m2 = r2.getMultiplicity();
            if (m1.isOrdered()) {
                this.allowedReferences.add(r1);
                continue;
            }
            if (m2.isOrdered()) {
                this.allowedReferences.add(r2);
                continue;
            }
            this.allowedReferences.add(r2);
        }
    }

    void generateUsedNamespaces() {
        this.println();
        Iterator i = this.usedNamespaces.iterator();
        while (i.hasNext()) {
            String pfx = (String)i.next();
            String ns = this.getGenerator().getProperty("impl.xmi.namespace.map." + pfx);
            if (ns == null || "".equals(ns)) {
                throw new RuntimeException("namespace is null or empty: ns = " + ns + ";\n property = impl.xmi.namespace.map." + pfx);
            }
            this.line("public static final String " + pfx + "_NAMESPACE_URI = \"" + ns + "\";");
        }
    }

    private String getCollectionKind(MultiplicityType mult) {
        int upper = mult.getUpper();
        boolean isUnique = mult.isUnique();
        boolean isOrdered = mult.isOrdered();
        if (upper == 1) {
            return "REF_KIND";
        }
        if (isOrdered) {
            return "LIST_KIND";
        }
        if (!isUnique && !isOrdered) {
            return "COLLECTION_KIND";
        }
        if (isUnique && !isOrdered) {
            return "SET_KIND";
        }
        throw new RuntimeException("Unknown collectionKind. ReaderGen:getCollectionKind().");
    }

    private void generateForName() {
        this.line("private final javax.jmi.reflect.RefEnum forName(String enm, String lnm)");
        this.sblock();
        this.line("return mdfOutermostPackage.forName(enm, lnm);");
        this.eblock();
    }

    private void collectXMINamespaces() {
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            this.getXMINamespace((ModelElement)cl);
        }
    }

    private void genAttrSetting(Attribute at) {
        MofClass cl = (MofClass)at.getContainer();
        String name = this.getName((ModelElement)at);
        if (at.getType() instanceof DataType) {
            DataType dt = (DataType)JMIUtil.dereference(at.getType());
            MultiplicityType mt = at.getMultiplicity();
            int upper = mt.getUpper();
            int lower = mt.getLower();
            String preOptionalObjConversion = upper == 1 && lower == 0 ? "new " + this.type((StructuralFeature)at) + "(" : "";
            String postOptionalObjConversion = upper == 1 && lower == 0 ? ")" : "";
            String str = null;
            str = ScopeKindEnum.INSTANCE_LEVEL == at.getScope() ? "((" + this.type(cl) + ")e)." : "((" + this.type(cl) + "Class)proxy).";
            if (JMIUtil.isEnum(dt)) {
                this.genEnumAttrSetting(at);
            } else if (JMIUtil.isStruct(dt)) {
                this.genStructAttrSetting(at);
            } else if (JMIUtil.isBoolean((Classifier)dt)) {
                this.line(str + JMIUtil.mutator(at, preOptionalObjConversion + "processBoolean(attrs, \"" + name + "\")") + postOptionalObjConversion + ";");
            } else if (JMIUtil.isString((Classifier)dt) && upper == 1 && (lower == 0 || lower == 1)) {
                this.line(str + JMIUtil.mutator(at, "processString(attrs, \"" + name + "\", " + "((" + this.type(cl) + ")e)." + JMIUtil.getter(name)) + ");");
            } else if (JMIUtil.isInteger((Classifier)dt)) {
                this.line(str + JMIUtil.mutator(at, preOptionalObjConversion + "processInt(attrs, \"" + name + "\")") + postOptionalObjConversion + ";");
            } else if (JMIUtil.isFloat((Classifier)dt)) {
                this.line(str + JMIUtil.mutator(at, preOptionalObjConversion + "processFloat(attrs, \"" + name + "\")") + postOptionalObjConversion + ";");
            } else if (JMIUtil.isDouble((Classifier)dt)) {
                this.line(str + JMIUtil.mutator(at, preOptionalObjConversion + "processDouble(attrs, \"" + name + "\")") + postOptionalObjConversion + ";");
            } else if (JMIUtil.isLong((Classifier)dt)) {
                this.line(str + JMIUtil.mutator(at, preOptionalObjConversion + "processLong(attrs, \"" + name + "\")") + postOptionalObjConversion + ";");
            }
        } else if (at.getType() instanceof MofClass) {
            this.line("deferLinkingRef(e, attrs, \"" + this.getName((ModelElement)at.getType()) + "\");");
        } else {
            throw new RuntimeException("GenMMImplXMIReaderSAX2::genAttrSetting(); atType = " + at.getType() + ";  atTypeName = " + at.getType().getName() + "; atName = " + this.getName((ModelElement)at));
        }
    }

    private void genEnumAttrSetting(Attribute at) {
        String name = this.getName((ModelElement)at);
        MofClass cl = (MofClass)at.getContainer();
        if (ScopeKindEnum.INSTANCE_LEVEL == at.getScope()) {
            this.sline("((" + this.type(cl) + ")e).");
        } else {
            this.sline("((" + this.type(cl) + "Class)proxy).");
        }
        this.println(JMIUtil.setter(name, "(" + this.type((StructuralFeature)at) + ")forName(\"" + this.getName((ModelElement)at.getType()) + "\", processEnum(attrs, \"" + name + "\"))") + ";");
    }

    private void genStructAttrSetting(Attribute at) {
        String name = this.getName((ModelElement)at);
        MofClass cl = (MofClass)at.getContainer();
        if (ScopeKindEnum.INSTANCE_LEVEL == at.getScope()) {
            this.sline("((" + this.type(cl) + ")e).");
        } else {
            this.sline("((" + this.type(cl) + "Class)proxy).");
        }
        this.println(JMIUtil.setter(name, "null") + ";");
    }

    private final HashMap createHash() {
        HashMap<String, ArrayList<MofClass>> hash = new HashMap<String, ArrayList<MofClass>>();
        Iterator j = this.getGenerator().getAllClasses().iterator();
        while (j.hasNext()) {
            MofClass cl = (MofClass)j.next();
            String prefix = this.getXMINamespace((ModelElement)cl);
            ArrayList<MofClass> list = (ArrayList<MofClass>)hash.get(prefix);
            if (list == null) {
                list = new ArrayList<MofClass>();
            }
            list.add(cl);
            hash.put(prefix, list);
        }
        return hash;
    }

    private void gen4Attributes(MofClass cl) {
        List allAttrs = this.getAllAttributes(cl);
        Iterator j = allAttrs.iterator();
        while (j.hasNext()) {
            Attribute at = (Attribute)j.next();
            MultiplicityType mult = at.getMultiplicity();
            Classifier type = at.getType();
            if (type instanceof DataType) {
                String isSingle;
                boolean f;
                DataType dt = (DataType)JMIUtil.dereference(type);
                boolean b0 = JMIUtil.isString((Classifier)dt);
                boolean b1 = JMIUtil.isBoolean((Classifier)dt);
                boolean b2 = JMIUtil.isInteger((Classifier)dt);
                boolean b3 = JMIUtil.isLong((Classifier)dt);
                boolean b4 = JMIUtil.isFloat((Classifier)dt);
                boolean b5 = JMIUtil.isDouble((Classifier)dt);
                boolean bl = f = b0 || b1 || b2 || b3 || b4 || b5;
                if (f) {
                    this.sif("\"" + this.getName((ModelElement)at) + "\".equals(propName)");
                    isSingle = mult.getUpper() == 1 ? "true" : "false";
                    if (JMIUtil.isString((Classifier)dt)) {
                        this.line("createSimpleAttrStringState( " + isSingle + ", \"" + this.getName((ModelElement)at) + "\", attrs);");
                    } else if (JMIUtil.isBoolean((Classifier)dt)) {
                        this.line("createSimpleAttrBooleanState( " + isSingle + ", \"" + this.getName((ModelElement)at) + "\", attrs);");
                    } else if (JMIUtil.isInteger((Classifier)dt)) {
                        this.line("createSimpleAttrLongState( " + isSingle + ", \"" + this.getName((ModelElement)at) + "\", attrs);");
                    } else if (JMIUtil.isLong((Classifier)dt)) {
                        this.line("createSimpleAttrULongState( " + isSingle + ", \"" + this.getName((ModelElement)at) + "\", attrs);");
                    } else if (JMIUtil.isFloat((Classifier)dt)) {
                        this.line("createSimpleAttrFloatState( " + isSingle + ", \"" + this.getName((ModelElement)at) + "\", attrs);");
                    } else {
                        throw new RuntimeException("Unsupported CorbaTcObjRef type code." + dt);
                    }
                    this.line("return;");
                    this.eif();
                    continue;
                }
                if (JMIUtil.isEnum(dt)) {
                    this.sif("\"" + this.getName((ModelElement)at) + "\".equals(propName)");
                    isSingle = mult.getUpper() == 1 ? "true" : "false";
                    this.line("createEnumState(\"" + this.getName((ModelElement)at) + "\", attrs, " + this.type((StructuralFeature)at) + ".class);");
                    this.line("return;");
                    this.eif();
                    continue;
                }
                if (JMIUtil.isStruct(dt)) {
                    this.sif("\"" + this.getName((ModelElement)at) + "\".equals(propName)");
                    this.line("createStructAttrState(\"" + this.getName((ModelElement)at) + "\", " + this.type((StructureType)dt) + ".class);");
                    this.line("return;");
                    this.eif();
                    continue;
                }
                this.sif("\"" + this.getName((ModelElement)at) + "\".equals(propName)");
                this.line("createAttrAsElemState(\"" + this.getName((ModelElement)at) + "\", " + this.getCollectionKind(mult) + ");");
                this.line("return;");
                this.eif();
                continue;
            }
            this.sif("\"" + this.getName((ModelElement)at) + "\".equals(propName)");
            this.line("createAttrAsElemState(\"" + this.getName((ModelElement)at) + "\", " + this.getCollectionKind(mult) + ");");
            this.line("return;");
            this.eif();
        }
    }

    private void gen4References(MofClass cl) {
        List allRef = this.getAllReferences(cl);
        Iterator j = allRef.iterator();
        while (j.hasNext()) {
            Reference ref = (Reference)j.next();
            if (!this.isComposite(ref)) {
                this.sif("\"" + this.getName((ModelElement)ref) + "\".equals(propName)");
                this.line("createRefAsElemState(\"" + this.getName((ModelElement)ref) + "\");");
                this.line("return;");
                this.eif();
                continue;
            }
            this.sif("\"" + this.getName((ModelElement)ref) + "\".equals(propName)");
            this.line("createCompositionState(\"" + this.getName((ModelElement)ref) + "\", " + this.getCollectionKind(ref.getMultiplicity()) + ");");
            this.line("return;");
            this.eif();
        }
    }

    private List getAllAttributes(MofClass cl) {
        ArrayList<Attribute> allAttrs = new ArrayList<Attribute>();
        Iterator j = cl.getContents().iterator();
        while (j.hasNext()) {
            Object o = j.next();
            if (!(o instanceof Attribute)) continue;
            Attribute at = (Attribute)o;
            allAttrs.add(at);
        }
        return allAttrs;
    }

    private List getAllReferences(MofClass cl) {
        ArrayList<Reference> allRef = new ArrayList<Reference>();
        Iterator j = cl.getContents().iterator();
        while (j.hasNext()) {
            Reference ref;
            Association asc;
            Object o = j.next();
            if (!(o instanceof Reference) || (asc = (Association)(ref = (Reference)o).getReferencedEnd().getContainer()).isDerived()) continue;
            allRef.add(ref);
        }
        return allRef;
    }
}

