/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator.impl;

import java.io.IOException;
import java.util.Iterator;
import javax.jmi.model.Association;
import javax.jmi.model.DataType;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.model.Operation;
import ru.novosoft.mdf.ext.MDFOutermostPackage;
import ru.novosoft.mdf.generator.GenMM;
import ru.novosoft.mdf.generator.NameUtil;
import ru.novosoft.mdf.generator.impl.GenMMImplWriter;
import ru.novosoft.mdf.generator.jmi.JMIUtil;

public class GenMMImplRepository
extends GenMMImplWriter {
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenMMImplRepository(GenMM g, MDFOutermostPackage r, JMIUtil jmi) throws IOException {
        super(g, g.getProperty("impl.repository.package"), g.getProperty("impl.repository.name") + ".java", jmi);
        this.name = g.getProperty("impl.repository.name");
        try {
            this.prolog();
            this.line("package " + g.getProperty("impl.repository.package") + ";");
            this.line("import ru.novosoft.mdf.ext.*;");
            this.line("import ru.novosoft.mdf.ext.xmi.*;");
            this.line("import javax.jmi.xmi.*;");
            this.line("import javax.jmi.reflect.*;");
            this.line("import ru.novosoft.mdf.impl.*;");
            this.line("import ru.novosoft.mdf.impl.xmi.*;");
            this.println();
            this.line("public class " + this.name + " extends ru.novosoft.mdf.impl.MDFOutermostPackageImpl");
            this.sblock();
            this.line("public " + this.name + "()");
            this.sblock();
            this.eblock();
            this.println();
            this.createByClassMethod();
            this.createMetaObject();
            this.getMetaObject();
            this.forName();
            this.generateXMISupport();
            this.eblock();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close();
            throw throwable;
        }
        this.close();
    }

    public void createByClassMethod() {
        this.println();
        this.line("public MDFObject create(Class cls)");
        this.sblock();
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            if (cl.isAbstract()) continue;
            this.sif("cls == " + this.type(cl) + ".class");
            this.line("return new " + JMIUtil.javaClassPackage(cl.getContainer()) + "." + JMIUtil.nameOfClass(this.name((ModelElement)cl)) + "(this);");
            this.eif();
        }
        this.line("String msg = formatLocalizedString(\"MDFOutmostOutermostPackageImpl_UnknownClass\", cls.getName( )");
        this.line("throw new RuntimeException(msg);");
        this.eblock();
    }

    public void generateXMISupport() {
        this.println();
        this.line("public XMIReader getXMIReader( String xmiVersion )");
        this.sblock();
        this.line("return new " + this.name + "XMIReader();");
        this.eblock();
        this.println();
        this.line("public XMIWriter getXMIWriter( String xmiVersion )");
        this.sblock();
        this.line("return new " + this.name + "XMIWriter();");
        this.eblock();
    }

    private void getMetaObject() {
        this.line("public javax.jmi.reflect.RefBaseObject getMetaObject(javax.jmi.reflect.RefObject metaobject )");
        this.sblock();
        this.line("Class c = null;");
        this.sline();
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            this.pelseIf("ru.novosoft.mdf.impl.MDFBaseObjectImpl.checkQualifiedName( metaobject, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)cl) + " )");
            this.sline("c = " + JMIUtil.javaInterfacePackage(cl.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)cl));
            this.println("Class.class;");
            this.eif();
            this.sline("else ");
        }
        Iterator i2 = this.getGenerator().getAllAssociations().iterator();
        while (i2.hasNext()) {
            Association asc = (Association)i2.next();
            this.pelseIf("ru.novosoft.mdf.impl.MDFBaseObjectImpl.checkQualifiedName( metaobject, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)asc) + " )");
            this.sline("c = " + JMIUtil.javaInterfacePackage(asc.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)asc));
            this.println(".class;");
            this.eif();
            this.sline("else ");
        }
        Iterator i3 = this.getGenerator().getAllPackages().iterator();
        while (i3.hasNext()) {
            MofPackage p = (MofPackage)i3.next();
            this.pelseIf("ru.novosoft.mdf.impl.MDFBaseObjectImpl.checkQualifiedName( metaobject, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)p) + " )");
            this.sline("c = " + JMIUtil.javaInterfacePackage((Namespace)p) + "." + JMIUtil.nameOfInterface((ModelElement)p));
            this.println("Package.class;");
            this.eif();
            this.sline("else ");
        }
        this.sblock();
        this.line("throw new RuntimeException();");
        this.eblock();
        this.line("return getMetaObject( c );");
        this.eblock();
    }

    private void createMetaObject() {
        this.println();
        this.line("protected MDFBaseObject createMetaObject( Class cls )");
        this.sblock();
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            this.sif("cls == " + this.type(cl) + "Class.class");
            this.line("return new " + JMIUtil.javaClassPackage(cl.getContainer()) + "." + JMIUtil.nameOfClass(this.name((ModelElement)cl), "Class") + "( this );");
            this.eif();
        }
        Iterator i2 = this.getGenerator().getAllAssociations().iterator();
        while (i2.hasNext()) {
            Association asc = (Association)i2.next();
            if (asc.isDerived()) continue;
            this.sif("cls == " + this.type(asc) + ".class");
            this.line("return new " + JMIUtil.javaClassPackage(asc.getContainer()) + "." + JMIUtil.nameOfClass(this.name((ModelElement)asc)) + "( this );");
            this.eif();
        }
        Iterator i3 = this.getGenerator().getAllPackages().iterator();
        while (i3.hasNext()) {
            MofPackage p = (MofPackage)i3.next();
            this.sif("cls == " + JMIUtil.javaInterfacePackage((Namespace)p) + "." + JMIUtil.nameOfInterface((ModelElement)p) + "Package.class");
            this.line("return new " + JMIUtil.javaClassPackage((Namespace)p) + "." + JMIUtil.nameOfClass(this.name((ModelElement)p), "Package") + "( this );");
            this.eif();
        }
        this.line("String msg = formatLocalizedString(\"MDFOutmostOutermostPackageImpl_UnknownClass\", cls.getName( )");
        this.line("throw new RuntimeException(msg);");
        this.eblock();
    }

    private void forName() {
        this.line("// enm - enumeration name");
        this.line("public final javax.jmi.reflect.RefEnum forName(String enm, String tnm)");
        this.sblock();
        Iterator it = this.getGenerator().getAllEnumerationTypes().iterator();
        while (it.hasNext()) {
            EnumerationType c = (EnumerationType)it.next();
            this.sif("\"" + this.getName((ModelElement)c) + "\".equals(enm)");
            Iterator i = c.getLabels().iterator();
            while (i.hasNext()) {
                String label = (String)i.next();
                this.sif("\"" + JMIUtil.unprefixEnumLabel((DataType)c, label) + "\".equals(tnm)");
                this.line("return " + JMIUtil.javaInterfacePackage(c.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)c) + "Enum." + NameUtil.getId3(JMIUtil.unprefixEnumLabel((DataType)c, label)) + ";");
                this.eif();
            }
            this.eif();
        }
        this.line("return null;");
        this.eblock();
    }

    private boolean containsOperation(MofClass c) {
        Iterator i = c.getContents().iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof Operation)) continue;
            return true;
        }
        return false;
    }
}

