/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.Association;
import javax.jmi.model.Classifier;
import javax.jmi.model.DataType;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.VisibilityKindEnum;
import ru.novosoft.mdf.generator.GenMM;
import ru.novosoft.mdf.generator.NameUtil;
import ru.novosoft.mdf.generator.impl.GenMMImplWriter;
import ru.novosoft.mdf.generator.jmi.GenMMInterfaceWriter;
import ru.novosoft.mdf.generator.jmi.JMIUtil;

public final class GenMMImplPackage
extends GenMMImplWriter {
    private String name;
    private MofPackage thisPkg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenMMImplPackage(GenMM g, MofPackage c, JMIUtil jmi) throws IOException {
        super(g, JMIUtil.javaClassPackage((Namespace)c), JMIUtil.nameOfClass(GenMMInterfaceWriter.getName(jmi, (ModelElement)c), "Package") + ".java", jmi);
        this.name = g.getProperty("impl.repository.name");
        this.thisPkg = c;
        try {
            this.declareClass();
            this.sblock();
            this.line("public " + JMIUtil.nameOfClass(this.name((ModelElement)c), "Package") + "()");
            this.sblock();
            this.line("super();");
            this.eblock();
            this.line("public " + JMIUtil.nameOfClass(this.name((ModelElement)this.thisPkg), "Package") + "(ru.novosoft.mdf.impl.MDFOutermostPackageImpl r)");
            this.sblock();
            this.line("super(r);");
            this.eblock();
            if (this.isOutermostPackage()) {
                this.generateCreateMetaObject();
                this.generateCreateByClassMethod();
                this.generateGetMetaModel();
            }
            this.generateGetMetaObject();
            this.generateXMISupport();
            this.generateForName();
            this.generateMethods();
            this.generateAbstractMethods();
            this.refMetaObject((ModelElement)this.thisPkg);
            this.eblock();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close();
            throw throwable;
        }
        this.close();
    }

    public void generateMethods() {
        Iterator i = this.thisPkg.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof Import) {
                this.generateForImportedPackage((Import)o);
                continue;
            }
            if (o instanceof MofPackage) {
                this.generateForPackage((MofPackage)o);
                continue;
            }
            if (o instanceof MofClass) {
                this.generateForProxy((MofClass)o);
                continue;
            }
            if (o instanceof Association) {
                this.generateForAssociation((Association)o);
                continue;
            }
            if (!(o instanceof DataType)) continue;
            DataType dt = (DataType)JMIUtil.dereference((Classifier)((DataType)o));
            if (!JMIUtil.isStruct(dt)) continue;
            this.generateForStruct((StructureType)dt);
        }
    }

    public void rootAbstractMethods() {
        this.refPackageMethods();
        this.refBaseObjectMethods((ModelElement)this.thisPkg);
        this.mdfGetInterfaceClass((Namespace)this.thisPkg);
    }

    public void generateCreateByClassMethod() {
        this.println();
        this.line("public MDFObject create(Class cls)");
        this.sblock();
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            if (cl.isAbstract()) continue;
            this.sif("cls == " + this.type(cl) + ".class");
            this.line("return new " + JMIUtil.javaClassPackage(cl.getContainer()) + "." + JMIUtil.nameOfClass(this.name((ModelElement)cl)) + "(this);");
            this.eif();
        }
        this.line("throw new RuntimeException(\"Unknow class: \" + cls.getName());");
        this.eblock();
    }

    public void generateXMISupport() {
        this.println();
        this.line("public XMIReader getXMIReader( String xmiVersion )");
        this.sblock();
        this.line("return new " + this.name + "XMIReader();");
        this.eblock();
        this.println();
        this.line("public XMIWriter getXMIWriter( String xmiVersion )");
        this.sblock();
        this.line("return new " + this.name + "XMIWriter();");
        this.eblock();
    }

    protected void refPackageMethods() {
        this.refClass();
        this.genRefGetAssociation();
        this.genRefGetPackage();
        this.genRefGetAllPackages();
        this.genRefGetAllAssociations();
        this.genRefGetAllClasses();
        this.genRefCreateStruct();
        this.refCreateEnum((Namespace)this.thisPkg);
        this.genRefDelete();
    }

    private boolean isOutermostPackage() {
        ModelPackage p = (ModelPackage)this.thisPkg.refOutermostPackage();
        Iterator i = p.getAliases().getImporter((Namespace)this.thisPkg).iterator();
        while (i.hasNext()) {
            Import im = (Import)i.next();
            if (!im.isClustered()) continue;
            return false;
        }
        return this.thisPkg.refOutermostComposite() == this.thisPkg;
    }

    private void refClass() {
        MofClass cl;
        Object o;
        this.sline("public javax.jmi.reflect.RefClass refClass(javax.jmi.reflect.RefObject type)");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.nullPointerExceptionControl("type");
        Iterator i = this.thisPkg.getContents().iterator();
        while (i.hasNext()) {
            o = i.next();
            if (!(o instanceof MofClass)) continue;
            cl = (MofClass)o;
            this.sif("ru.novosoft.mdf.impl.MDFBaseObjectImpl.checkQualifiedName( type, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)cl) + " )");
            this.line("return get" + JMIUtil.nameOfInterface((ModelElement)cl) + "();");
            this.eif();
        }
        this.line("throw new javax.jmi.reflect.InvalidCallException(type, refMetaObject());");
        this.eblock();
        this.sline("public javax.jmi.reflect.RefClass refClass(String type)");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.nullPointerExceptionControl("type");
        i = this.thisPkg.getContents().iterator();
        while (i.hasNext()) {
            o = i.next();
            if (!(o instanceof MofClass)) continue;
            cl = (MofClass)o;
            this.sif("\"" + this.getName((ModelElement)cl) + "\".equals(type)");
            this.line("return get" + JMIUtil.nameOfInterface((ModelElement)cl) + "();");
            this.eif();
        }
        this.line("throw new javax.jmi.reflect.InvalidCallException(type, refMetaObject());");
        this.eblock();
    }

    private void genRefGetAssociation() {
        Association asc;
        Object o;
        this.sline("public javax.jmi.reflect.RefAssociation refAssociation(javax.jmi.reflect.RefObject association)");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.nullPointerExceptionControl("association");
        Iterator i = this.thisPkg.getContents().iterator();
        while (i.hasNext()) {
            o = i.next();
            if (!(o instanceof Association) || VisibilityKindEnum.PUBLIC_VIS != (asc = (Association)o).getVisibility()) continue;
            this.sif("ru.novosoft.mdf.impl.MDFBaseObjectImpl.checkQualifiedName( association, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)asc) + " )");
            this.line("return get" + JMIUtil.nameOfInterface((ModelElement)asc) + "();");
            this.eif();
        }
        this.line("throw new javax.jmi.reflect.InvalidCallException(association, refMetaObject());");
        this.eblock();
        this.sline("public javax.jmi.reflect.RefAssociation refAssociation(String association)");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.nullPointerExceptionControl("association");
        i = this.thisPkg.getContents().iterator();
        while (i.hasNext()) {
            o = i.next();
            if (!(o instanceof Association) || VisibilityKindEnum.PUBLIC_VIS != (asc = (Association)o).getVisibility()) continue;
            this.sif("\"" + this.getName((ModelElement)asc) + "\".equals(association)");
            this.line("return get" + JMIUtil.nameOfInterface((ModelElement)asc) + "();");
            this.eif();
        }
        this.line("throw new javax.jmi.reflect.InvalidCallException(association, refMetaObject());");
        this.eblock();
    }

    private void genRefGetPackage() {
        MofPackage p;
        Namespace ns;
        MofPackage p2;
        Object o;
        this.sline("public javax.jmi.reflect.RefPackage refPackage(javax.jmi.reflect.RefObject nestedPackage)");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.nullPointerExceptionControl("nestedPackage");
        Iterator i = this.thisPkg.getContents().iterator();
        while (i.hasNext()) {
            o = i.next();
            if (o instanceof MofPackage) {
                p2 = (MofPackage)o;
                this.sif("ru.novosoft.mdf.impl.MDFBaseObjectImpl.checkQualifiedName( nestedPackage, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)p2) + " )");
                this.line("return get" + JMIUtil.nameOfInterface((ModelElement)p2) + "();");
                this.eif();
                continue;
            }
            if (!(o instanceof Import) || !((ns = ((Import)o).getImportedNamespace()) instanceof MofPackage) || !((Import)o).isClustered()) continue;
            p = (MofPackage)ns;
            this.sif("ru.novosoft.mdf.impl.MDFBaseObjectImpl.checkQualifiedName( nestedPackage, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)p) + " )");
            this.line("return get" + JMIUtil.nameOfInterface((ModelElement)p) + "();");
            this.eif();
        }
        this.line("throw new javax.jmi.reflect.InvalidCallException(nestedPackage, refMetaObject());");
        this.eblock();
        this.sline("public javax.jmi.reflect.RefPackage refPackage(String nestedPackage)");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.nullPointerExceptionControl("nestedPackage");
        i = this.thisPkg.getContents().iterator();
        while (i.hasNext()) {
            o = i.next();
            if (o instanceof MofPackage) {
                p2 = (MofPackage)o;
                this.sif("\"" + this.getName((ModelElement)p2) + "\".equals(nestedPackage)");
                this.line("return get" + JMIUtil.nameOfInterface((ModelElement)p2) + "();");
                this.eif();
                continue;
            }
            if (!(o instanceof Import) || !((ns = ((Import)o).getImportedNamespace()) instanceof MofPackage) || !((Import)o).isClustered()) continue;
            p = (MofPackage)ns;
            this.sif("\"" + this.getName((ModelElement)p) + "\".equals(nestedPackage)");
            this.line("return get" + JMIUtil.nameOfInterface((ModelElement)p) + "();");
            this.eif();
        }
        this.line("throw new javax.jmi.reflect.InvalidNameException(nestedPackage);");
        this.eblock();
    }

    private void genRefGetAllPackages() {
        this.line("private java.util.Collection allPackages;");
        this.sline("public java.util.Collection refAllPackages()");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.sif("allPackages == null");
        this.line("java.util.List list = new java.util.ArrayList();");
        Iterator i = this.thisPkg.getContents().iterator();
        while (i.hasNext()) {
            Namespace ns;
            Object o = i.next();
            if (o instanceof MofPackage) {
                MofPackage p = (MofPackage)o;
                this.sline("list.add(mdfOutermostPackage.getMetaObject(");
                this.println(JMIUtil.javaInterfacePackage((Namespace)p) + "." + JMIUtil.nameOfInterface((ModelElement)p) + "Package.class) );");
                continue;
            }
            if (!(o instanceof Import) || !((Import)o).isClustered() || !((ns = ((Import)o).getImportedNamespace()) instanceof MofPackage)) continue;
            MofPackage p = (MofPackage)ns;
            this.sline("list.add( mdfOutermostPackage.getMetaObject(");
            this.println(JMIUtil.javaInterfacePackage((Namespace)p) + "." + JMIUtil.nameOfInterface((ModelElement)p) + "Package.class) );");
        }
        this.line("allPackages = java.util.Collections.unmodifiableList( list );");
        this.eif();
        this.line("return allPackages;");
        this.eblock();
    }

    private void genRefGetAllAssociations() {
        this.line("private java.util.Collection allAssociations;");
        this.sline("public java.util.Collection refAllAssociations()");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.sif("allAssociations == null");
        this.line("java.util.Collection col = new java.util.ArrayList();");
        Iterator i = this.thisPkg.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Association)) continue;
            Association asc = (Association)o;
            this.sline("col.add( mdfOutermostPackage.getMetaObject(");
            this.println(JMIUtil.javaInterfacePackage(asc.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)asc) + ".class) );");
        }
        this.line("allAssociations = java.util.Collections.unmodifiableCollection( col );");
        this.eif();
        this.line("return allAssociations;");
        this.eblock();
    }

    private void genRefGetAllClasses() {
        this.line("private java.util.Collection allProxies;");
        this.sline("public java.util.Collection refAllClasses()");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.sif("allProxies == null");
        this.line("java.util.Collection col = new java.util.ArrayList();");
        Iterator i = this.thisPkg.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof MofClass)) continue;
            MofClass cl = (MofClass)o;
            this.sline("col.add( mdfOutermostPackage.getMetaObject(");
            this.println(JMIUtil.javaInterfacePackage(cl.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)cl) + "Class.class) );");
        }
        this.line("allProxies = java.util.Collections.unmodifiableCollection( col );");
        this.eif();
        this.line("return allProxies;");
        this.eblock();
    }

    private void genRefCreateStruct() {
        StructureField field;
        int j;
        List fields;
        StructureType dt;
        Object o;
        this.sline("public javax.jmi.reflect.RefStruct refCreateStruct(javax.jmi.reflect.RefObject dataType, java.util.List args)");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.generateTestForNull("dataType == null", "MDFClassImpl_NullStructClass");
        Iterator i = this.thisPkg.getContents().iterator();
        while (i.hasNext()) {
            o = i.next();
            if (!JMIUtil.isStruct(o)) continue;
            dt = (StructureType)o;
            this.sif("checkQualifiedName( dataType, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)dt) + ")");
            this.sline("return create" + this.getName((ModelElement)dt) + "( ");
            fields = this.getFields(dt);
            j = 0;
            while (j < fields.size()) {
                field = (StructureField)fields.get(j);
                this.print(this.convertObjectToExpression(field.getType(), "args.get(" + j + ")"));
                this.print(j != fields.size() - 1 ? ", " : "");
                ++j;
            }
            this.println(");");
            this.eif();
        }
        this.line("throw new javax.jmi.reflect.InvalidNameException(null);");
        this.eblock();
        this.sline("public javax.jmi.reflect.RefStruct refCreateStruct(String dataType, java.util.List args)");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.generateTestForNull("dataType == null", "MDFClassImpl_NullStructClass");
        i = this.thisPkg.getContents().iterator();
        while (i.hasNext()) {
            o = i.next();
            if (!JMIUtil.isStruct(o)) continue;
            dt = (StructureType)o;
            this.sif("\"" + this.getName((ModelElement)dt) + "\".equals(dataType)");
            this.sline("return create" + this.getName((ModelElement)dt) + "( ");
            fields = this.getFields(dt);
            j = 0;
            while (j < fields.size()) {
                field = (StructureField)fields.get(j);
                this.print(this.convertObjectToExpression(field.getType(), "args.get(" + j + ")"));
                this.print(j != fields.size() - 1 ? ", " : "");
                ++j;
            }
            this.println(");");
            this.eif();
        }
        this.line("throw new javax.jmi.reflect.InvalidNameException(dataType);");
        this.eblock();
    }

    private void genRefDelete() {
        this.sline("public void refDelete()");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.line("String msg = mdfOutermostPackage.getLocalizedString(\"MDFNotImpl\");");
        this.line("throw new RuntimeException( msg );");
        this.eblock();
    }

    private void generateAbstractMethods() {
        if (this.thisPkg.getSupertypes().size() == 0) {
            this.rootAbstractMethods();
        }
    }

    private void declareClass() {
        this.prolog();
        this.line("package " + JMIUtil.javaClassPackage((Namespace)this.thisPkg) + ";");
        this.line("import ru.novosoft.mdf.ext.*;");
        this.line("import ru.novosoft.mdf.ext.xmi.*;");
        this.line("import javax.jmi.xmi.*;");
        this.line("import javax.jmi.reflect.*;");
        this.line("import ru.novosoft.mdf.impl.*;");
        this.line("import ru.novosoft.mdf.impl.xmi.*;");
        this.line("import " + this.getGenerator().getProperty("impl.repository.package") + ".*;");
        StringBuffer buf = new StringBuffer("public class ");
        buf.append(JMIUtil.nameOfClass(this.name((ModelElement)this.thisPkg), "Package"));
        buf.append(" extends ");
        ArrayList st = new ArrayList(this.thisPkg.getSupertypes());
        if (st.size() == 0) {
            if (this.isOutermostPackage()) {
                buf.append("ru.novosoft.mdf.impl.MDFOutermostPackageImpl implements ");
            } else {
                buf.append("ru.novosoft.mdf.impl.MDFPackageImpl implements ");
            }
            buf.append(JMIUtil.javaInterfacePackage((Namespace)this.thisPkg) + "." + JMIUtil.nameOfInterface((ModelElement)this.thisPkg) + "Package");
        } else {
            MofPackage f = (MofPackage)st.remove(0);
            String name = JMIUtil.javaClassPackage((Namespace)f) + "." + JMIUtil.nameOfClass(this.name((ModelElement)f), "Package");
            buf.append(name);
            buf.append(" implements ");
            int i = 0;
            while (i < st.size()) {
                buf.append(this.type((MofPackage)st.get(i)));
                buf.append("Package, ");
                ++i;
            }
            buf.append(this.type(this.thisPkg) + "Package");
        }
        this.line(buf);
    }

    private void generateForImportedPackage(Import im) {
        Namespace ns = im.getImportedNamespace();
        if (im.isClustered() && ns instanceof MofPackage) {
            MofPackage p = (MofPackage)ns;
            String pkgInterface = JMIUtil.javaInterfacePackage((Namespace)p) + "." + JMIUtil.nameOfInterface((ModelElement)p) + "Package";
            String metaName = "_" + NameUtil.getId2(this.name((ModelElement)im));
            this.line(pkgInterface + " " + metaName + " = null;");
            this.line("public " + pkgInterface + " get" + JMIUtil.nameOfInterface((ModelElement)im) + "()");
            this.sblock();
            this.sif(metaName + " == null");
            this.line(metaName + " = (" + pkgInterface + ")mdfOutermostPackage.getMetaObject(" + pkgInterface + ".class);");
            this.eif();
            this.line("return " + metaName + ";");
            this.eblock();
        }
    }

    private void generateForPackage(MofPackage p) {
        String pkgInterface = JMIUtil.javaInterfacePackage((Namespace)p) + "." + JMIUtil.nameOfInterface((ModelElement)p) + "Package";
        String metaName = "_" + NameUtil.getId2(this.name((ModelElement)p));
        this.line(pkgInterface + " " + metaName + " = null;");
        this.line("public " + pkgInterface + " get" + JMIUtil.nameOfInterface((ModelElement)p) + "()");
        this.sblock();
        this.sif(metaName + " == null");
        this.line(metaName + " = (" + pkgInterface + ")mdfOutermostPackage.getMetaObject(" + pkgInterface + ".class);");
        this.eif();
        this.line("return " + metaName + ";");
        this.eblock();
    }

    private void generateForProxy(MofClass c) {
        String proxyInterface = this.type(c) + "Class";
        String metaName = "_" + NameUtil.getId2(JMIUtil.nameOfInterface((ModelElement)c));
        this.line(proxyInterface + " " + metaName + " = null;");
        this.line("public " + proxyInterface + " get" + JMIUtil.nameOfInterface((ModelElement)c) + "()");
        this.sblock();
        this.sif(metaName + " == null");
        this.line(metaName + " = (" + proxyInterface + ")mdfOutermostPackage.getMetaObject(" + proxyInterface + ".class);");
        this.eif();
        this.line("return " + metaName + ";");
        this.eblock();
    }

    private void generateForAssociation(Association asc) {
        if (VisibilityKindEnum.PUBLIC_VIS == asc.getVisibility()) {
            String ascInterface = this.type(asc);
            String metaName = "_" + NameUtil.getId2(this.name((ModelElement)asc));
            this.line(ascInterface + " " + metaName + " = null;");
            this.line("public " + ascInterface + " get" + JMIUtil.nameOfInterface((ModelElement)asc) + "()");
            this.sblock();
            this.sif(metaName + " == null");
            this.line(metaName + " = (" + ascInterface + ")mdfOutermostPackage.getMetaObject( " + ascInterface + ".class );");
            this.eif();
            this.line("return " + metaName + ";");
            this.eblock();
        }
    }

    private void generateForStruct(StructureType dt) {
        StringBuffer buf = new StringBuffer();
        buf.append("public ");
        buf.append(JMIUtil.javaInterfacePackage(dt.getContainer()));
        buf.append(".");
        buf.append(JMIUtil.nameOfInterface((ModelElement)dt));
        buf.append(" create");
        buf.append(this.name((ModelElement)dt));
        buf.append("(");
        List fields = this.fields((DataType)dt);
        int j = 0;
        while (j < fields.size()) {
            StructureField f = (StructureField)fields.get(j);
            buf.append(this.type(f));
            buf.append(" ");
            buf.append(this.name((ModelElement)f));
            if (j != fields.size() - 1) {
                buf.append(", ");
            }
            ++j;
        }
        buf.append(") throws javax.jmi.reflect.JmiException");
        this.line(buf);
        this.sblock();
        buf.append("return new ");
        buf.append(JMIUtil.javaClassPackage(dt.getContainer()));
        buf.append(".");
        buf.append(JMIUtil.nameOfClass(this.name((ModelElement)dt)));
        buf.append("(");
        int j2 = 0;
        while (j2 < fields.size()) {
            StructureField f = (StructureField)fields.get(j2);
            buf.append(this.name((ModelElement)f));
            if (j2 != fields.size() - 1) {
                buf.append(", ");
            }
            ++j2;
        }
        buf.append(");");
        this.line(buf);
        this.eblock();
    }

    private void generateCreateMetaObject() {
        this.println();
        this.line("protected MDFBaseObject createMetaObject( Class cls )");
        this.sblock();
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            this.sif("cls == " + this.type(cl) + "Class.class");
            this.line("return new " + JMIUtil.javaClassPackage(cl.getContainer()) + "." + JMIUtil.nameOfClass(this.name((ModelElement)cl), "Class") + "( mdfOutermostPackage );");
            this.eif();
        }
        Iterator i2 = this.getGenerator().getAllAssociations().iterator();
        while (i2.hasNext()) {
            Association asc = (Association)i2.next();
            if (asc.isDerived()) continue;
            this.sif("cls == " + this.type(asc) + ".class");
            this.line("return new " + JMIUtil.javaClassPackage(asc.getContainer()) + "." + JMIUtil.nameOfClass(this.name((ModelElement)asc)) + "( mdfOutermostPackage );");
            this.eif();
        }
        Iterator i3 = this.getGenerator().getAllPackages().iterator();
        while (i3.hasNext()) {
            MofPackage p = (MofPackage)i3.next();
            this.sif("cls == " + JMIUtil.javaInterfacePackage((Namespace)p) + "." + JMIUtil.nameOfInterface((ModelElement)p) + "Package.class");
            if (p == this.thisPkg) {
                this.line("return this;");
            } else {
                this.line("return new " + JMIUtil.javaClassPackage((Namespace)p) + "." + JMIUtil.nameOfClass(this.name((ModelElement)p), "Package") + "(mdfOutermostPackage);");
            }
            this.eif();
        }
        this.line("throw new RuntimeException(\"Unknow class: \" + cls.getName());");
        this.eblock();
    }

    private void generateForName() {
        this.line("// enm - enumeration name");
        this.line("public javax.jmi.reflect.RefEnum forName(String enm, String tnm)");
        this.sblock();
        Iterator it = this.getGenerator().getAllEnumerationTypes().iterator();
        while (it.hasNext()) {
            EnumerationType c = (EnumerationType)it.next();
            this.sif("\"" + this.getName((ModelElement)c) + "\".equals(enm)");
            Iterator i = c.getLabels().iterator();
            while (i.hasNext()) {
                String label = (String)i.next();
                this.sif("\"" + JMIUtil.unprefixEnumLabel((DataType)c, label) + "\".equals(tnm)");
                this.line("return " + JMIUtil.javaInterfacePackage(c.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)c) + "Enum." + NameUtil.getId3(JMIUtil.unprefixEnumLabel((DataType)c, label)) + ";");
                this.eif();
            }
            this.eif();
        }
        this.line("return null;");
        this.eblock();
    }

    private void generateGetMetaObject() {
        this.line("public javax.jmi.reflect.RefBaseObject getMetaObject(javax.jmi.reflect.RefObject metaobject )");
        this.sblock();
        boolean isEmpty = true;
        this.sline();
        Iterator i = this.getGenerator().getAllClasses().iterator();
        while (i.hasNext()) {
            MofClass cl = (MofClass)i.next();
            this.pelseIf("ru.novosoft.mdf.impl.MDFBaseObjectImpl.checkQualifiedName( metaobject, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)cl) + " )");
            this.sline("return getMetaObject(");
            this.print(JMIUtil.javaInterfacePackage(cl.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)cl));
            this.println("Class.class);");
            this.eif();
            this.sline("else ");
            isEmpty = false;
        }
        Iterator i2 = this.getGenerator().getAllAssociations().iterator();
        while (i2.hasNext()) {
            Association asc = (Association)i2.next();
            this.pelseIf("ru.novosoft.mdf.impl.MDFBaseObjectImpl.checkQualifiedName( metaobject, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)asc) + " )");
            this.sline("return getMetaObject(");
            this.print(JMIUtil.javaInterfacePackage(asc.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)asc));
            this.println(".class);");
            this.eif();
            this.sline("else ");
            isEmpty = false;
        }
        Iterator i3 = this.getGenerator().getAllPackages().iterator();
        while (i3.hasNext()) {
            MofPackage p = (MofPackage)i3.next();
            this.pelseIf("ru.novosoft.mdf.impl.MDFBaseObjectImpl.checkQualifiedName( metaobject, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)p) + " )");
            this.sline("return getMetaObject(");
            this.print(JMIUtil.javaInterfacePackage((Namespace)p) + "." + JMIUtil.nameOfInterface((ModelElement)p));
            this.println("Package.class);");
            this.eif();
            this.sline("else ");
            isEmpty = false;
        }
        if (!isEmpty) {
            this.sblock();
            this.line("throw new RuntimeException();");
            this.eblock();
        }
        this.eblock();
    }

    private void genPackageIdentity(MofPackage p) {
        this.sif("cls == " + JMIUtil.javaInterfacePackage((Namespace)p) + "." + JMIUtil.nameOfInterface((ModelElement)p) + "Package.class");
        if (p == this.thisPkg) {
            this.line("return this;");
        } else {
            this.line("return new " + JMIUtil.javaClassPackage((Namespace)p) + "." + JMIUtil.nameOfClass(this.name((ModelElement)p), "Package") + "(this);");
        }
        this.eif();
    }

    private void generateGetMetaModel() {
        GenMM g = this.getGenerator();
        this.line("public String getMetaModelResource()");
        this.sblock();
        this.line("return \"/" + g.getProperty("metamodel.resource") + "\";");
        this.eblock();
        this.line("public boolean getMetaModelIsMof()");
        this.sblock();
        this.line("return " + g.getProperty("metamodel.isMof") + ";");
        this.eblock();
    }
}

