/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jmi.model.AggregationKindEnum;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.DataType;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Operation;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.TypedElement;
import javax.jmi.model.VisibilityKindEnum;
import ru.novosoft.mdf.generator.GenMM;
import ru.novosoft.mdf.generator.impl.GenAttributeAPI;
import ru.novosoft.mdf.generator.impl.GenMMImplWriter;
import ru.novosoft.mdf.generator.impl.GenMdfAPI;
import ru.novosoft.mdf.generator.impl.object.GenImplInterface;
import ru.novosoft.mdf.generator.impl.object.GenImplListSetAssociation;
import ru.novosoft.mdf.generator.impl.object.GenImplRefListAssociation;
import ru.novosoft.mdf.generator.impl.object.GenImplRefRefAssociation;
import ru.novosoft.mdf.generator.impl.object.GenImplRefSetAssociation;
import ru.novosoft.mdf.generator.impl.object.GenImplSetSetAssociation;
import ru.novosoft.mdf.generator.impl.object.GenMMImplObjectRefAPI;
import ru.novosoft.mdf.generator.jmi.GenMMInterfaceWriter;
import ru.novosoft.mdf.generator.jmi.GenMMOperationTemplate;
import ru.novosoft.mdf.generator.jmi.JMIUtil;
import ru.novosoft.mdf.mof.MOF;

public class GenMMImplObject
extends GenMMImplWriter {
    protected MofClass thisCls;
    protected Set instanceOtherEnds = new HashSet();
    protected Set instanceAttributes = new HashSet();
    protected GenImplRefRefAssociation genRefRef = null;
    protected GenImplRefSetAssociation genRefSet = null;
    protected GenImplSetSetAssociation genSetSet = null;
    protected GenImplRefListAssociation genRefList = null;
    protected GenImplListSetAssociation genListSet = null;
    protected GenImplInterface genImplInterface = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenMMImplObject(GenMM g, MofClass c, JMIUtil jmi) throws IOException {
        super(g, JMIUtil.javaClassPackage(c.getContainer()), JMIUtil.nameOfClass(GenMMInterfaceWriter.getName(jmi, (ModelElement)c)) + ".java", jmi);
        try {
            this.thisCls = c;
            GenMdfAPI genMdfApi = new GenMdfAPI(c, this.instanceAttributes, this.instanceOtherEnds);
            GenAttributeAPI genAttrApi = new GenAttributeAPI(c, ScopeKindEnum.INSTANCE_LEVEL);
            GenMMImplObjectRefAPI genRefApi = new GenMMImplObjectRefAPI(c, this.instanceAttributes, this.instanceOtherEnds);
            this.genRefRef = new GenImplRefRefAssociation(c);
            this.genRefSet = new GenImplRefSetAssociation(c);
            this.genSetSet = new GenImplSetSetAssociation(c);
            this.genRefList = new GenImplRefListAssociation(c);
            this.genListSet = new GenImplListSetAssociation(c);
            this.genImplInterface = new GenImplInterface(c);
            this.collectInstanceFeatures();
            this.prolog();
            this.classDeclaration();
            this.sblock();
            this.generateConstructors((ModelElement)this.thisCls, "");
            this.generateReplaceData(this.notImpl());
            this.generateNotImplStructure();
            this.generateCompositionSupport();
            this.mdfGetInterfaceClass(c);
            this.cleanup();
            this.generateInternalElementEvent();
            this.checkAddedElement();
            this.elementAdded();
            this.elementRemoved();
            this.elementSetAt();
            genMdfApi.generate();
            genAttrApi.generate();
            genRefApi.generate();
            this.genListSet.generateInternalGetOppositeCollection();
            this.eblock();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.close();
            throw throwable;
        }
        this.close();
    }

    public GenMMImplObject(MofClass c) throws IOException {
        this.thisCls = c;
        this.collectInstanceFeatures();
    }

    public void mdfGetInterfaceClass(MofClass cl) {
        this.line("public Class mdfGetInterfaceClass()");
        this.sblock();
        this.line("return " + JMIUtil.javaInterfacePackage(cl.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)cl) + ".class;");
        this.eblock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isSetSetAssociation(AssociationEnd te, AssociationEnd oe) {
        if (!JMIUtil.isSet(te)) return false;
        if (!JMIUtil.isSet(oe)) return false;
        return true;
    }

    protected boolean isRefRefAssociation(AssociationEnd te, AssociationEnd oe) {
        return this.upper((TypedElement)te) == 1 && this.upper((TypedElement)oe) == 1;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isRefSetAssociation(AssociationEnd te, AssociationEnd oe) {
        if (this.upper((TypedElement)te) != 1) ** GOTO lbl-1000
        if (JMIUtil.isSet(oe)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = isRefSet = false;
        }
        if (this.upper((TypedElement)oe) != 1) ** GOTO lbl-1000
        if (JMIUtil.isSet(te)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isSetRef = v1;
        return isRefSet != false || isSetRef != false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isListSetAssociation(AssociationEnd te, AssociationEnd oe) {
        if (!JMIUtil.isMultiple((TypedElement)te)) ** GOTO lbl-1000
        if (JMIUtil.isMultiple((TypedElement)oe)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        mults = v0;
        isListSet = this.isOrdered((TypedElement)oe) == false && this.isOrdered((TypedElement)te) != false && mults != false;
        isSetList = this.isOrdered((TypedElement)te) == false && this.isOrdered((TypedElement)oe) != false && mults != false;
        return isListSet != false || isSetList != false;
    }

    protected boolean isRefListAssociation(AssociationEnd te, AssociationEnd oe) {
        boolean isRefList = JMIUtil.isList(te) && this.upper((TypedElement)oe) == 1;
        boolean isListRef = JMIUtil.isList(oe) && this.upper((TypedElement)te) == 1;
        return isRefList || isListRef;
    }

    protected void generateConstructors(ModelElement c, String sfx) {
        this.line("public " + JMIUtil.nameOfClass(this.name(c), sfx) + "(ru.novosoft.mdf.impl.MDFOutermostPackageImpl r)");
        this.sblock();
        this.line("super(r);");
        this.eblock();
    }

    protected void generateInternalElementAdded() {
        this.sline("public void internalElementAdded( ru.novosoft.mdf.impl.MDFListImpl list, ");
        this.println("int collectionId, Object addedElement )");
        this.sblock();
        this.sif("needEvent()");
        this.line("switch(collectionId) ");
        this.sblock();
        Iterator iter = this.notImpl().iterator();
        while (iter.hasNext()) {
            MofClass c = (MofClass)iter.next();
            Iterator i = JMIUtil.elementsByType((Classifier)c).iterator();
            while (i.hasNext()) {
                TypedElement ty = (TypedElement)i.next();
                if (!(ty instanceof AssociationEnd)) continue;
                AssociationEnd te = (AssociationEnd)ty;
                AssociationEnd oe = JMIUtil.oppositeEnd(te);
                if (JMIUtil.isOrdered((TypedElement)oe)) continue;
                if (!JMIUtil.isMultiple((TypedElement)oe)) continue;
                this.line("case " + this.vname((ModelElement)oe).toUpperCase() + " :");
                this.line("fireItemAdd( \"" + this.getName((ModelElement)te) + "\", addedElement );");
                this.line("break;");
            }
        }
        this.line("default: super.internalElementAdded(list, collectionId, addedElement);");
        this.eblock();
        this.eif();
        this.eblock();
    }

    protected void generateInternalElementRemoved() {
        this.sline("public void internalElementRemoved(ru.novosoft.mdf.impl.MDFListImpl list, ");
        this.println("int collectionId, Object removedElement )");
        this.sblock();
        this.sif("needEvent()");
        this.line("switch(collectionId) ");
        this.sblock();
        Iterator iter = this.notImpl().iterator();
        while (iter.hasNext()) {
            MofClass c = (MofClass)iter.next();
            Iterator i = JMIUtil.elementsByType((Classifier)c).iterator();
            while (i.hasNext()) {
                TypedElement ty = (TypedElement)i.next();
                if (!(ty instanceof AssociationEnd)) continue;
                AssociationEnd te = (AssociationEnd)ty;
                AssociationEnd oe = JMIUtil.oppositeEnd(te);
                if (JMIUtil.isOrdered((TypedElement)oe)) continue;
                if (!JMIUtil.isMultiple((TypedElement)oe)) continue;
                this.line("case " + this.vname((ModelElement)oe).toUpperCase() + " :");
                this.line("fireItemRemove( \"" + this.getName((ModelElement)te) + "\", removedElement );");
                this.line("break;");
            }
        }
        this.line("default: super.internalElementRemoved(list, collectionId, removedElement);");
        this.eblock();
        this.eif();
        this.eblock();
    }

    protected HashSet notImpl() {
        return this.utilNotImpl(this.thisCls, this.extendedClass(this.thisCls));
    }

    protected void generateGetter(AssociationEnd ae) {
        this.line("public " + this.colType((TypedElement)ae) + " " + JMIUtil.getter(JMIUtil.genName((ModelElement)ae)));
        this.sblock();
        this.line("checkExists();");
        this.line("return " + this.vname((ModelElement)ae) + ";");
        this.eblock();
    }

    protected void generateVariables(AssociationEnd ae1, AssociationEnd ae2) {
        String idName = this.vname((ModelElement)ae2).toUpperCase();
        this.line("private final int " + idName + " = " + JMIUtil.genCollectionId(ae2) + ";");
        this.sline("protected " + this.colType((TypedElement)ae2) + " " + this.vname((ModelElement)ae2) + " = new ru.novosoft.mdf.impl.MDFFeatureListImpl(this, ");
        this.println(idName + ", " + this.isUnique((TypedElement)ae2) + ", " + this.isComposite((TypedElement)ae1) + ");");
    }

    protected void generateRefGetter(AssociationEnd ae) {
        this.line("public " + this.type(ae) + " " + JMIUtil.getter(JMIUtil.genName((ModelElement)ae)));
        this.sblock();
        this.line("checkExists();");
        this.line("return " + this.vname((ModelElement)ae) + ";");
        this.eblock();
    }

    protected void generateRefMethod(AssociationEnd ae1, AssociationEnd ae2) {
        Association a = (Association)ae1.getContainer();
        String thisName = JMIUtil.genName((ModelElement)ae1);
        boolean composite = AggregationKindEnum.COMPOSITE == ae1.getAggregation();
        String refName = this.getRefName(ae2);
        this.line("public void " + JMIUtil.ref(JMIUtil.genName((ModelElement)ae2), this.type(ae2) + " __arg"));
        this.sblock();
        this.sif(this.vname((ModelElement)ae2) + " != __arg");
        this.line(this.type(ae2) + " __saved = " + this.vname((ModelElement)ae2) + ";");
        this.sif("__saved != null");
        if (this.upper((TypedElement)ae1) != 1) {
            this.sline("((" + this.castedType(ae2) + ")__saved).");
            this.println(JMIUtil.getter(JMIUtil.genName((ModelElement)ae1)) + ".remove( this );");
        } else {
            this.line("((" + this.castedType(ae2) + ")__saved)." + JMIUtil.setter(thisName, "null") + ";");
        }
        this.eif();
        this.line(this.vname((ModelElement)ae2) + " = __arg;");
        this.line("firePropertySet(\"" + refName + "\", __saved, __arg);");
        this.genRefThis(null, "((" + this.castedType(ae2) + ")__arg)", composite, refName, false);
        this.eif();
        this.generateAddLinkSupport(a);
        this.eblock();
    }

    protected void generateUnrefMethod(AssociationEnd ae1, AssociationEnd ae2) {
        Association a = (Association)ae1.getContainer();
        String thisName = JMIUtil.genName((ModelElement)ae1);
        boolean composite = AggregationKindEnum.COMPOSITE == ae1.getAggregation();
        String refName = this.getRefName(ae2);
        this.line("public void " + JMIUtil.unref(JMIUtil.genName((ModelElement)ae2), this.type(ae2) + " __arg"));
        this.sblock();
        this.line(this.type(ae2) + " __saved = " + this.vname((ModelElement)ae2) + ";");
        this.genUnrefThis(null, "((" + this.castedType(ae2) + ")__arg)", composite, refName);
        this.line(this.vname((ModelElement)ae2) + " = null;");
        this.line("firePropertySet(\"" + refName + "\", __saved, null);");
        this.generateRemoveLinkSupport(a);
        this.eblock();
    }

    private boolean isNeedElementSetAt(MofClass cls) {
        Iterator it = this.utilNotImpl(cls, this.extendedClass(cls)).iterator();
        while (it.hasNext()) {
            MofClass notImplCls = (MofClass)it.next();
            Iterator i = JMIUtil.elementsByType((Classifier)notImplCls).iterator();
            while (i.hasNext()) {
                TypedElement ty = (TypedElement)i.next();
                if (!(ty instanceof AssociationEnd)) continue;
                AssociationEnd ae2 = JMIUtil.oppositeEnd((AssociationEnd)ty);
                Association asc = (Association)ae2.getContainer();
                if (asc.isDerived()) continue;
                if (!JMIUtil.isList(ae2)) continue;
                return true;
            }
        }
        return false;
    }

    private void elementSetAt() {
        Iterator i;
        if (!this.isNeedElementSetAt(this.thisCls)) {
            return;
        }
        this.line("public void elementSetAt(ru.novosoft.mdf.impl.MDFListImpl list, int collectionId, int position, Object removed, Object added)");
        this.sblock();
        this.line("switch(collectionId)");
        this.sblock();
        Iterator it = this.notImpl().iterator();
        while (it.hasNext()) {
            MofClass notImplCls = (MofClass)it.next();
            i = JMIUtil.elementsByType((Classifier)notImplCls).iterator();
            while (i.hasNext()) {
                TypedElement ty = (TypedElement)i.next();
                if (!(ty instanceof AssociationEnd)) continue;
                AssociationEnd ae1 = (AssociationEnd)ty;
                AssociationEnd ae2 = JMIUtil.oppositeEnd(ae1);
                Association asc = (Association)ae2.getContainer();
                if (asc.isDerived()) continue;
                if (!JMIUtil.isList(ae2)) continue;
                this.elementSetAtCase(ae1, ae2);
            }
            Iterator i2 = this.thisCls.getContents().iterator();
            while (i2.hasNext()) {
                Object o = i2.next();
                if (!(o instanceof Attribute)) continue;
                if (!JMIUtil.isList((TypedElement)((Attribute)o))) continue;
                this.elementSetAtCase((Attribute)o);
            }
        }
        HashSet s = this.notImpl();
        s.remove(this.thisCls);
        i = s.iterator();
        while (i.hasNext()) {
            MofClass cc = (MofClass)i.next();
            if (!this.isNeedElementSetAt(cc)) continue;
            this.line("default: super.elementSetAt(list, collectionId, position, removed, added);");
            break;
        }
        this.eblock();
        this.eblock();
    }

    private void generateTemplateOperation(MofClass c) throws IOException {
        ArrayList<Operation> col = new ArrayList<Operation>();
        Iterator i = c.getContents().iterator();
        while (i.hasNext()) {
            Operation op;
            Object obj = i.next();
            if (!(obj instanceof Operation) || (op = (Operation)obj).getVisibility() != VisibilityKindEnum.PUBLIC_VIS || op.getScope() != ScopeKindEnum.INSTANCE_LEVEL) continue;
            col.add(op);
        }
        new GenMMOperationTemplate(col).operations();
    }

    private void generateReplaceData(Set notImpl) {
        this.line("protected void mdfReplaceData( ru.novosoft.mdf.ext.MDFObject srcarg, Class base)");
        this.sblock();
        this.line("super.mdfReplaceData(srcarg, base);");
        Iterator j = notImpl.iterator();
        while (j.hasNext()) {
            MofClass cls = (MofClass)j.next();
            this.sif("srcarg instanceof " + this.type(cls) + " && " + this.type(cls) + ".class.isAssignableFrom(base)");
            this.line(JMIUtil.implType((ModelElement)cls) + " src = (" + JMIUtil.implType((ModelElement)cls) + ")srcarg;");
            Iterator i = MOF.getAttributes((Classifier)cls, false).iterator();
            while (i.hasNext()) {
                Attribute at = (Attribute)i.next();
                if (ScopeKindEnum.CLASSIFIER_LEVEL == at.getScope()) continue;
                if (at.getType() instanceof DataType) {
                    if (JMIUtil.isMultiple((TypedElement)at)) {
                        this.sblock();
                        if (JMIUtil.isList((TypedElement)at)) {
                            this.line("List c = new ArrayList( src." + JMIUtil.accessor((StructuralFeature)at) + " );");
                        } else {
                            this.line("Set c = new HashSet( src." + JMIUtil.accessor((StructuralFeature)at) + " );");
                        }
                        this.line("src." + JMIUtil.accessor((StructuralFeature)at) + ".clear();");
                        this.lineCollectionSetting(this.vname((ModelElement)at), "c");
                        this.eblock();
                    } else if (at.isChangeable()) {
                        this.line(JMIUtil.mutator(at, "src." + JMIUtil.accessor((StructuralFeature)at)) + ";");
                    }
                }
                if (!(at.getType() instanceof MofClass)) continue;
                if (JMIUtil.isMultiple((TypedElement)at)) {
                    this.sblock();
                    if (JMIUtil.isList((TypedElement)at)) {
                        this.line("List c = new ArrayList( src." + JMIUtil.accessor((StructuralFeature)at) + " );");
                    } else {
                        this.line("Set c = new HashSet( src." + JMIUtil.accessor((StructuralFeature)at) + " );");
                    }
                    this.line("src." + JMIUtil.accessor((StructuralFeature)at) + ".clear();");
                    this.lineCollectionSetting(this.vname((ModelElement)at), "c");
                    this.eblock();
                    continue;
                }
                if (!at.isChangeable()) continue;
                String type = this.type((StructuralFeature)at);
                this.sblock();
                this.line(type + " c = src." + JMIUtil.accessor((StructuralFeature)at) + ";");
                this.sif("c != null");
                this.line("src." + JMIUtil.mutator(at, "(" + type + ")null") + ";");
                this.line("this." + JMIUtil.mutator(at, "c") + ";");
                this.eif();
                this.eblock();
            }
            Iterator i2 = MOF.getAttachedEnds(cls, false).iterator();
            while (i2.hasNext()) {
                AssociationEnd te = (AssociationEnd)i2.next();
                AssociationEnd oe = JMIUtil.oppositeEnd(te);
                String tety = JMIUtil.implType((ModelElement)te.getType());
                String oety = JMIUtil.implType((ModelElement)oe.getType());
                if (JMIUtil.isOrdered((TypedElement)te)) {
                    if (JMIUtil.isMultiple((TypedElement)oe)) {
                        this.sforeach("src." + JMIUtil.getter(JMIUtil.genName((ModelElement)oe)), oety, "c");
                        this.line("int pos = c." + JMIUtil.getter(JMIUtil.genName((ModelElement)te)) + ".indexOf(src);");
                        this.line("c." + JMIUtil.getter(JMIUtil.genName((ModelElement)te)) + ".set( pos, this );");
                        this.eforeach();
                        continue;
                    }
                    this.sblock();
                    this.line(oety + " c = (" + oety + ")src." + JMIUtil.getter(JMIUtil.genName((ModelElement)oe)) + ";");
                    this.sif("c != null");
                    this.line("int pos = c." + JMIUtil.getter(JMIUtil.genName((ModelElement)te)) + ".indexOf(src);");
                    this.line("c." + JMIUtil.getter(JMIUtil.genName((ModelElement)te)) + ".set( pos, this );");
                    this.eif();
                    this.eblock();
                    continue;
                }
                if (JMIUtil.isMultiple((TypedElement)oe)) {
                    this.sblock();
                    if (JMIUtil.isOrdered((TypedElement)oe)) {
                        this.line("List c = new ArrayList( src." + JMIUtil.getter(JMIUtil.genName((ModelElement)oe)) + " );");
                    } else {
                        this.line("Set c = new HashSet( src." + JMIUtil.getter(JMIUtil.genName((ModelElement)oe)) + " );");
                    }
                    this.line("src." + JMIUtil.getter(JMIUtil.genName((ModelElement)oe)) + ".clear();");
                    this.lineCollectionSetting(this.vname((ModelElement)oe), "c");
                    this.eblock();
                    continue;
                }
                this.sblock();
                this.line(this.type(oe) + " c = src." + JMIUtil.getter(JMIUtil.genName((ModelElement)oe)) + ";");
                this.sif("c != null");
                this.line("src." + JMIUtil.setter(JMIUtil.genName((ModelElement)oe), "(" + this.type(oe) + ")null") + ";");
                this.line("this." + JMIUtil.setter(JMIUtil.genName((ModelElement)oe), "c") + ";");
                this.eif();
                this.eblock();
            }
            this.eif();
        }
        this.eblock();
    }

    private void generateInternalElementEvent() {
        Iterator i = JMIUtil.elementsByType((Classifier)this.thisCls).iterator();
        while (i.hasNext()) {
            TypedElement ty = (TypedElement)i.next();
            if (!(ty instanceof AssociationEnd)) continue;
            AssociationEnd te = (AssociationEnd)ty;
            AssociationEnd oe = JMIUtil.oppositeEnd(te);
            if (JMIUtil.isOrdered((TypedElement)oe)) continue;
            this.generateInternalElementAdded();
            this.generateInternalElementRemoved();
            break;
        }
    }

    private void cleanup() {
        this.line("protected void cleanup()");
        this.sblock();
        Iterator i = this.instanceAttributes.iterator();
        while (i.hasNext()) {
            Attribute at;
            block8: {
                String initValue;
                block10: {
                    block11: {
                        Classifier type;
                        block9: {
                            at = (Attribute)i.next();
                            if (!at.isChangeable()) continue;
                            MultiplicityType mt = at.getMultiplicity();
                            int upper = mt.getUpper();
                            int lower = mt.getLower();
                            if (upper == 1 && lower == 0) {
                                this.line(JMIUtil.mutator(at, null) + ";");
                                continue;
                            }
                            if (upper != 1 || lower != 1) break block8;
                            initValue = "null";
                            type = at.getType();
                            if (!JMIUtil.isBoolean(type)) break block9;
                            initValue = "false";
                            break block10;
                        }
                        if (JMIUtil.isInteger(type)) break block11;
                        if (JMIUtil.isDouble(type)) break block11;
                        if (JMIUtil.isLong(type)) break block11;
                        if (!JMIUtil.isFloat(type)) break block10;
                    }
                    initValue = "0";
                }
                this.line(JMIUtil.mutator(at, initValue) + ";");
                continue;
            }
            this.line(this.vname((ModelElement)at) + ".clear();");
        }
        Iterator i2 = this.instanceOtherEnds.iterator();
        while (i2.hasNext()) {
            AssociationEnd oe = (AssociationEnd)i2.next();
            MultiplicityType mt = oe.getMultiplicity();
            int upper = mt.getUpper();
            int lower = mt.getLower();
            if (upper == 1 && lower == 0) {
                this.line(JMIUtil.setter(JMIUtil.genName((ModelElement)oe), "(" + this.type(oe) + ")null") + ";");
                continue;
            }
            if (upper == 1 && lower == 1) {
                this.line(JMIUtil.setter(JMIUtil.genName((ModelElement)oe), "(" + this.type(oe) + ")null") + ";");
                continue;
            }
            this.line(this.vname(JMIUtil.genName((ModelElement)oe)) + ".clear();");
        }
        this.line("super.cleanup();");
        this.eblock();
    }

    private void generateCompositionSupport() {
        this.line("public Collection mdfGetElementContents()");
        this.sblock();
        this.line("Collection ret = super.mdfGetElementContents();");
        Iterator i = this.instanceAttributes.iterator();
        while (i.hasNext()) {
            Attribute at = (Attribute)i.next();
            if (!(at.getType() instanceof MofClass)) continue;
            if (this.upper((TypedElement)at) == 1) {
                this.line("ret.add(" + JMIUtil.getter(this.getName((ModelElement)at)) + ");");
                continue;
            }
            this.line("ret.addAll(" + JMIUtil.getter(this.getName((ModelElement)at)) + ");");
        }
        Iterator i2 = this.instanceOtherEnds.iterator();
        while (i2.hasNext()) {
            AssociationEnd oe = (AssociationEnd)i2.next();
            AssociationEnd te = JMIUtil.oppositeEnd(oe);
            if (AggregationKindEnum.COMPOSITE != te.getAggregation()) continue;
            String nm = JMIUtil.genName((ModelElement)oe);
            if (oe.getMultiplicity().getUpper() == 1) {
                this.line("ret.add(" + JMIUtil.getter(nm) + ");");
                continue;
            }
            this.line("ret.addAll(" + JMIUtil.getter(nm) + ");");
        }
        this.line("ret.remove(null);");
        this.line("return ret;");
        this.eblock();
    }

    private void collectInstanceFeatures() {
        Iterator i = this.notImpl().iterator();
        while (i.hasNext()) {
            MofClass nic = (MofClass)i.next();
            this.initInstanceAttributes(nic);
            this.initInstanceEnds(nic);
        }
        this.instanceAttributes = Collections.unmodifiableSet(this.instanceAttributes);
        this.instanceOtherEnds = Collections.unmodifiableSet(this.instanceOtherEnds);
    }

    private void initInstanceAttributes(MofClass notImplCls) {
        Iterator i = notImplCls.getContents().iterator();
        while (i.hasNext()) {
            Attribute at;
            Object o = i.next();
            if (!(o instanceof Attribute) || (at = (Attribute)o).isDerived() || ScopeKindEnum.INSTANCE_LEVEL != at.getScope()) continue;
            this.instanceAttributes.add(at);
        }
    }

    private void initInstanceEnds(MofClass notImplCls) {
        Collection tes = JMIUtil.elementsByType((Classifier)notImplCls);
        Iterator i = tes.iterator();
        while (i.hasNext()) {
            TypedElement ty = (TypedElement)i.next();
            if (!(ty instanceof AssociationEnd)) continue;
            AssociationEnd oe = JMIUtil.oppositeEnd((AssociationEnd)ty);
            this.instanceOtherEnds.add(oe);
        }
    }

    private void generateNotImplStructure() throws IOException {
        Iterator iter = this.notImpl().iterator();
        while (iter.hasNext()) {
            MofClass c = (MofClass)iter.next();
            this.generateTemplateOperation(c);
            this.line("// implementing: " + this.type(c));
            this.genImplInterface.generate(c);
            Iterator i = JMIUtil.elementsByType((Classifier)c).iterator();
            while (i.hasNext()) {
                TypedElement ty = (TypedElement)i.next();
                if (!(ty instanceof AssociationEnd)) continue;
                AssociationEnd te = (AssociationEnd)ty;
                AssociationEnd oe = JMIUtil.oppositeEnd(te);
                this.genRefList.generateAssociationEnd(te, oe);
                this.genSetSet.generateAssociationEnd(te, oe);
                this.genRefRef.generateAssociationEnd(te, oe);
                this.genRefSet.generateAssociationEnd(te, oe);
                this.genListSet.generateAssociationEnd(te, oe);
            }
        }
    }

    private void classDeclaration() {
        this.generateImports();
        StringBuffer buf = new StringBuffer();
        buf.append("public ");
        if (this.thisCls.isAbstract()) {
            buf.append("abstract ");
        }
        buf.append("class ");
        buf.append(JMIUtil.nameOfClass(this.getName((ModelElement)this.thisCls)));
        buf.append(" extends ");
        if (this.extendedClass(this.thisCls) == null) {
            buf.append("ru.novosoft.mdf.impl.MDFObjectImpl");
        } else {
            MofClass extc = this.extendedClass(this.thisCls);
            buf.append(JMIUtil.javaClassPackage(extc.getContainer()) + "." + JMIUtil.nameOfClass(this.getName((ModelElement)extc)));
        }
        buf.append(" implements ");
        buf.append(this.type(this.thisCls));
        Iterator i = this.notImpl().iterator();
        while (i.hasNext()) {
            MofClass nic = (MofClass)i.next();
            if (!this.getGenerator().needGenerateHelper(nic)) continue;
            buf.append(", ");
            buf.append(JMIUtil.implType((ModelElement)nic));
        }
        this.line(buf);
    }

    private void generateImports() {
        StringBuffer buf = new StringBuffer();
        buf.append("package ");
        buf.append(JMIUtil.javaClassPackage(this.thisCls.getContainer()));
        buf.append(";");
        this.line(buf);
        this.line("import java.lang.reflect.Method;");
        this.line("import java.util.*;");
        this.println();
    }

    private void checkAddedElement() {
        this.line("public void checkAddedElement(ru.novosoft.mdf.impl.MDFListImpl list, int collectionId, Object newElement)");
        this.sblock();
        this.line("switch(collectionId)");
        this.sblock();
        Iterator it = this.notImpl().iterator();
        while (it.hasNext()) {
            MofClass notImplCls = (MofClass)it.next();
            Iterator i = JMIUtil.elementsByType((Classifier)notImplCls).iterator();
            while (i.hasNext()) {
                TypedElement ty = (TypedElement)i.next();
                if (!(ty instanceof AssociationEnd)) continue;
                AssociationEnd ae1 = (AssociationEnd)ty;
                AssociationEnd ae2 = JMIUtil.oppositeEnd(ae1);
                Association asc = (Association)ae1.getContainer();
                if (asc.isDerived()) continue;
                if (this.isListSetAssociation(ae1, ae2)) {
                    this.genListSet.checkAddedElementCase(ae1, ae2);
                    continue;
                }
                if (!JMIUtil.isMultiple((TypedElement)ae2)) continue;
                this.checkAddedElementCase(ae1, ae2);
            }
            Iterator i2 = this.thisCls.getContents().iterator();
            while (i2.hasNext()) {
                Object o = i2.next();
                if (!(o instanceof Attribute)) continue;
                if (!JMIUtil.isMultiple((TypedElement)((Attribute)o))) continue;
                this.checkAddedElementCase((Attribute)o);
            }
        }
        this.line("default: super.checkAddedElement( list, collectionId, newElement );");
        this.eblock();
        this.eblock();
    }

    private void checkAddedElementCase(Attribute at) {
        block5: {
            block4: {
                if (at.getType() instanceof MofClass) break block4;
                if (!JMIUtil.isSet((TypedElement)at)) break block5;
            }
            this.line();
            this.line("case " + this.vname((ModelElement)at).toUpperCase() + ":");
            if (at.getType() instanceof MofClass) {
                this.sif("refOutermostPackage() != ((javax.jmi.reflect.RefBaseObject)newElement).refOutermostPackage()");
                this.line("throw new javax.jmi.reflect.ClosureViolationException(newElement, refMetaObject());");
                this.eif();
            }
            this.line("break;");
        }
    }

    private void checkAddedElementCase(AssociationEnd te, AssociationEnd oe) {
        String oti = JMIUtil.implType((ModelElement)((MofClass)oe.getType()));
        this.line();
        this.line("case " + this.vname((ModelElement)oe).toUpperCase() + ":");
        this.nullPointerExceptionControl("newElement");
        this.sif("refOutermostPackage() != ((javax.jmi.reflect.RefBaseObject)newElement).refOutermostPackage()");
        this.line("throw new javax.jmi.reflect.ClosureViolationException(newElement, refMetaObject());");
        this.eif();
        if (this.upper((TypedElement)te) == 1 && this.isComposite((TypedElement)te)) {
            String m = "(( ru.novosoft.mdf.impl.MDFObjectImpl) newElement ).mdfGetImmediateCompositeAttribute()";
            this.sif(m + " != null && !\"" + this.getRefName(oe) + "\".equals( " + m + " )");
            this.line("throw new javax.jmi.reflect.ClosureViolationException(newElement, refMetaObject());");
            this.eif();
        }
        if (this.isComposite((TypedElement)te)) {
            this.line("mdfCheckNotOwned( (ru.novosoft.mdf.impl.MDFObjectImpl) newElement );");
        }
        this.sif(" ! (newElement instanceof " + this.type(oe) + ") ");
        this.line("throw new javax.jmi.reflect.TypeMismatchException(" + this.type(oe) + ".class, newElement, refMetaObject());");
        this.eif();
        this.line("break;");
    }

    private void elementAdded() {
        this.line("public void elementAdded( ru.novosoft.mdf.impl.MDFListImpl list, int collectionId, int position, Object newElement )");
        this.sblock();
        this.line("switch( collectionId )");
        this.sblock();
        Iterator it = this.notImpl().iterator();
        while (it.hasNext()) {
            MofClass notImplCls = (MofClass)it.next();
            Iterator i = JMIUtil.elementsByType((Classifier)notImplCls).iterator();
            while (i.hasNext()) {
                TypedElement ty = (TypedElement)i.next();
                if (!(ty instanceof AssociationEnd)) continue;
                AssociationEnd ae1 = (AssociationEnd)ty;
                AssociationEnd ae2 = JMIUtil.oppositeEnd(ae1);
                Association asc = (Association)ae1.getContainer();
                if (asc.isDerived()) continue;
                if (this.isListSetAssociation(ae1, ae2)) {
                    this.genListSet.elementAddedCase(ae1, ae2);
                    continue;
                }
                if (!JMIUtil.isMultiple((TypedElement)ae2)) continue;
                this.elementAddedCase(ae1, ae2);
            }
            Iterator i2 = this.thisCls.getContents().iterator();
            while (i2.hasNext()) {
                Object o = i2.next();
                if (!(o instanceof Attribute)) continue;
                if (!JMIUtil.isMultiple((TypedElement)((Attribute)o))) continue;
                this.elementAddedCase((Attribute)o);
            }
        }
        this.line("default: super.elementAdded( list, collectionId, position, newElement );");
        this.eblock();
        this.eblock();
    }

    private void elementAddedCase(AssociationEnd te, AssociationEnd oe) {
        if (!JMIUtil.isList(te)) {
            this.line("case " + this.vname((ModelElement)oe).toUpperCase() + " : ");
            this.sblock();
            String refName = this.getRefName(oe);
            String methName = JMIUtil.genName((ModelElement)te);
            String oti = JMIUtil.implType((ModelElement)((MofClass)oe.getType()));
            this.genRefThis(methName, "((" + oti + ")newElement)", this.isComposite((TypedElement)te), refName);
            if (JMIUtil.isSet(oe)) {
                this.sif("needUndo()");
                this.line("logItemAdd((ru.novosoft.mdf.impl.MDFListImpl)" + this.vname((ModelElement)oe) + ",_addMethod, _removeMethod, newElement);");
                this.eif();
                this.sif(" needEvent() ");
                this.line("fireItemAdd(\"" + refName + "\", newElement);");
                this.eif();
            } else if (JMIUtil.isList(oe)) {
                this.sif("needUndo()");
                this.line("logItemAddAt((ru.novosoft.mdf.impl.MDFListImpl)" + this.vname((ModelElement)oe) + ",_addAtMethod, _removeAtMethod, newElement, position);");
                this.eif();
                this.sif(" needEvent() ");
                this.line("fireItemAddAt(\"" + refName + "\", newElement, position);");
                this.eif();
            }
            this.eblock();
            this.line("break;");
        }
    }

    private void elementSetAtCase(AssociationEnd te, AssociationEnd oe) {
        this.line("case " + this.vname((ModelElement)oe).toUpperCase() + ": ");
        this.sblock();
        String methName = JMIUtil.genName((ModelElement)te);
        String oti = JMIUtil.implType((ModelElement)((MofClass)oe.getType()));
        this.genRefThis(methName, "((" + oti + ")added)", this.isComposite((TypedElement)te), this.getRefName(oe));
        this.genUnrefThis(methName, "((" + oti + ")removed)", this.isComposite((TypedElement)te), this.getRefName(oe));
        this.sif("needUndo()");
        this.line("logItemSetAt((ru.novosoft.mdf.impl.MDFListImpl)" + this.vname((ModelElement)oe) + ",_setAtMethod, removed, added, position);");
        this.eif();
        this.sif(" needEvent() ");
        this.line("fireItemSetAt(\"" + this.getRefName(oe) + "\", removed, added, position);");
        this.eif();
        this.eblock();
        this.line("break;");
    }

    private void elementAddedCase(Attribute at) {
        this.line("case " + this.vname((ModelElement)at).toUpperCase() + " : ");
        this.sblock();
        if (JMIUtil.isSet((TypedElement)at)) {
            this.sif("needUndo()");
            this.line("logItemAdd(_addMethod, _removeMethod, newElement);");
            this.eif();
            this.sif(" needEvent() ");
            this.line("fireItemAdd(\"" + this.getName((ModelElement)at) + "\", newElement);");
            this.eif();
        } else if (JMIUtil.isList((TypedElement)at)) {
            this.sif("needUndo()");
            this.line("logItemAddAt(_addAtMethod, _removeAtMethod, newElement, position);");
            this.eif();
            this.sif(" needEvent() ");
            this.line("fireItemAddAt(\"" + this.getName((ModelElement)at) + "\", newElement, position);");
            this.eif();
        }
        this.eblock();
        this.line("break;");
    }

    private void elementSetAtCase(Attribute at) {
        this.line("case " + this.vname((ModelElement)at).toUpperCase() + ": ");
        this.sblock();
        this.sif("needUndo()");
        this.line("logItemSetAt(_setAtMethod, removed, added, position);");
        this.eif();
        this.sif("needEvent()");
        this.line("fireItemSetAt(\"" + this.getName((ModelElement)at) + "\", removed, added, position);");
        this.eif();
        this.eblock();
        this.line("break;");
    }

    private void elementRemoved() {
        this.line("public void elementRemoved( ru.novosoft.mdf.impl.MDFListImpl list, int collectionId, int position, Object removedObject )");
        this.sblock();
        this.line("switch( collectionId )");
        this.sblock();
        Iterator it = this.notImpl().iterator();
        while (it.hasNext()) {
            MofClass notImplCls = (MofClass)it.next();
            Iterator i = JMIUtil.elementsByType((Classifier)notImplCls).iterator();
            while (i.hasNext()) {
                TypedElement ty = (TypedElement)i.next();
                if (!(ty instanceof AssociationEnd)) continue;
                AssociationEnd ae1 = (AssociationEnd)ty;
                AssociationEnd ae2 = JMIUtil.oppositeEnd(ae1);
                Association asc = (Association)ae1.getContainer();
                if (asc.isDerived()) continue;
                if (this.isListSetAssociation(ae1, ae2)) {
                    this.genListSet.elementRemovedCase(ae1, ae2);
                    continue;
                }
                if (!JMIUtil.isMultiple((TypedElement)ae2)) continue;
                this.elementRemovedCase(ae1, ae2);
            }
            Iterator i2 = this.thisCls.getContents().iterator();
            while (i2.hasNext()) {
                Object o = i2.next();
                if (!(o instanceof Attribute)) continue;
                if (!JMIUtil.isMultiple((TypedElement)((Attribute)o))) continue;
                this.elementRemovedCase((Attribute)o);
            }
        }
        this.line("default: super.elementRemoved( list, collectionId, position, removedObject );");
        this.eblock();
        this.eblock();
    }

    private void elementRemovedCase(AssociationEnd te, AssociationEnd oe) {
        if (!this.isOrdered((TypedElement)te)) {
            this.line("case " + this.vname((ModelElement)oe).toUpperCase() + " : ");
            this.sblock();
            String refName = this.getRefName(oe);
            String methName = JMIUtil.genName((ModelElement)te);
            String oti = JMIUtil.implType((ModelElement)((MofClass)oe.getType()));
            this.genUnrefThis(methName, "((" + oti + ")removedObject)", this.isComposite((TypedElement)te), refName);
            if (JMIUtil.isSet(oe)) {
                this.sif(" needUndo() ");
                this.line("logItemRemove((ru.novosoft.mdf.impl.MDFListImpl)" + this.vname((ModelElement)oe) + ",_removeMethod, _addMethod, removedObject);");
                this.eif();
                this.sif(" needEvent() ");
                this.line("fireItemRemove(\"" + refName + "\", removedObject);");
                this.eif();
            } else if (JMIUtil.isList(oe)) {
                this.sif(" needUndo() ");
                this.line("logItemRemoveAt((ru.novosoft.mdf.impl.MDFListImpl)" + this.vname((ModelElement)oe) + ",_removeAtMethod, _addAtMethod, removedObject, position);");
                this.eif();
                this.sif(" needEvent() ");
                this.line("fireItemRemoveAt(\"" + refName + "\", removedObject, position);");
                this.eif();
            }
            this.eblock();
            this.line("break;");
        }
    }

    private void elementRemovedCase(Attribute at) {
        this.line("case " + this.vname((ModelElement)at).toUpperCase() + " : ");
        this.sblock();
        if (JMIUtil.isSet((TypedElement)at)) {
            this.sif("needUndo()");
            this.line("logItemRemove(_removeMethod, _addMethod, removedObject);");
            this.eif();
            this.sif("needEvent()");
            this.line("fireItemRemove(\"" + this.getName((ModelElement)at) + "\", removedObject);");
            this.eif();
        } else if (JMIUtil.isList((TypedElement)at)) {
            this.sif("needUndo()");
            this.line("logItemRemoveAt(_removeAtMethod, _addAtMethod, removedObject, position);");
            this.eif();
            this.sif(" needEvent() ");
            this.line("fireItemRemoveAt(\"" + this.getName((ModelElement)at) + "\", removedObject, position);");
            this.eif();
        }
        this.eblock();
        this.line("break;");
    }
}

