/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.DataType;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Namespace;
import javax.jmi.model.Operation;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.ScopeKind;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.VisibilityKindEnum;
import ru.novosoft.mdf.generator.GenMM;
import ru.novosoft.mdf.generator.impl.GenAttributeAPI;
import ru.novosoft.mdf.generator.impl.GenMMImplWriter;
import ru.novosoft.mdf.generator.impl.GenMdfAPI;
import ru.novosoft.mdf.generator.jmi.GenMMInterfaceWriter;
import ru.novosoft.mdf.generator.jmi.GenMMOperationTemplate;
import ru.novosoft.mdf.generator.jmi.JMIUtil;
import ru.novosoft.mdf.mof.impl.model.MOFMultiplicityTypeImpl;

public class GenMMImplClassProxy
extends GenMMImplWriter {
    private List instanceAttrs = new ArrayList();
    private Set classReferences = new HashSet();
    private Set classAttributes = new HashSet();
    private final MofClass thisCls;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenMMImplClassProxy(GenMM g, MofClass c, JMIUtil jmi) throws IOException {
        super(g, GenMMImplClassProxy.classPackage(c), GenMMImplClassProxy.proxyName(jmi, c) + ".java", jmi);
        this.thisCls = c;
        try {
            this.collectClassifierFeatures();
            this.prolog();
            this.line("package " + this.proxyPackage() + ";");
            this.line("import java.util.*;");
            this.line("import java.lang.reflect.*;");
            this.proxyDeclaration();
            this.sblock();
            GenMdfAPI genMdfApi = new GenMdfAPI(c, this.classAttributes, Collections.EMPTY_SET);
            GenAttributeAPI genAttrApi = new GenAttributeAPI(c, ScopeKindEnum.CLASSIFIER_LEVEL);
            genMdfApi.generate();
            genAttrApi.generate();
            this.generateConstructors((ModelElement)this.thisCls, "Class");
            this.structure();
            this.templateOperation(c);
            this.mdfGetInterfaceClass(c);
            this.refAllOfType();
            this.refMetaObject((ModelElement)this.thisCls);
            this.eblock();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.close();
            throw throwable;
        }
        this.close();
    }

    public void refAllOfType() {
        this.line("private java.util.Collection allOfType__ = null;");
        this.line("public java.util.Collection refAllOfType()");
        this.sblock();
        this.sif("allOfType__ == null");
        this.line("java.util.List proxies = new java.util.ArrayList();");
        HashSet<MofClass> proxies = new HashSet<MofClass>();
        MofClass metaObject = this.thisCls;
        proxies.add(metaObject);
        Iterator i = this.getGenerator().getRoots().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Namespace)) continue;
            this.processAllMetaObjects((Namespace)o, proxies);
        }
        Iterator i2 = proxies.iterator();
        while (i2.hasNext()) {
            MofClass m = (MofClass)i2.next();
            this.line("proxies.add( mdfOutermostPackage.getMetaObject( " + this.type(m) + "Class.class) );");
        }
        this.line("allOfType__ = new ru.novosoft.mdf.impl.MDFAllTypeCollection( this, proxies );");
        this.eif();
        this.line("return allOfType__;");
        this.eblock();
    }

    public void structure() {
        Iterator i = this.utilNotImpl().iterator();
        while (i.hasNext()) {
            MofClass nic = (MofClass)i.next();
            this.fillInstanceAttributesBuffer(nic);
            if (!nic.isAbstract()) {
                this.noArgsCreateMethod(nic);
                if (!"".equals(this.methodParamList(this.instanceAttrs))) {
                    this.argsCreateMethod(nic);
                }
            }
            Iterator k = nic.getContents().iterator();
            while (k.hasNext()) {
                Object dt = k.next();
                if (!JMIUtil.isStruct(dt)) continue;
                this.createStructMethod((StructureType)dt);
            }
            this.templates(nic);
        }
        this.rootAbstractMethods();
    }

    public void collectInstanceAttributes(MofClass c) {
        Iterator i = c.getSupertypes().iterator();
        while (i.hasNext()) {
            this.collectInstanceAttributes((MofClass)i.next());
        }
        this.pushAdditionAttributes(c);
    }

    public void templates(MofClass c) {
        Iterator i = this.superTypes((Classifier)c).iterator();
        while (i.hasNext()) {
            this.templates((MofClass)i.next());
        }
    }

    public void proxyDeclaration() {
        StringBuffer buf = new StringBuffer("public ");
        buf.append("class ");
        buf.append(GenMMImplClassProxy.proxyName(GenMMInterfaceWriter.jmi, this.thisCls));
        buf.append(" extends ");
        buf.append("ru.novosoft.mdf.impl.MDFClassImpl implements ");
        buf.append(this.type(this.thisCls));
        buf.append("Class");
        this.line(buf.toString());
    }

    public void createStructMethod(StructureType dt) {
        this.declareCreateStructMethod(dt);
        this.sblock();
        StringBuffer buf = new StringBuffer();
        buf.append("return new ");
        if (dt.getContainer() instanceof MofClass) {
            buf.append(JMIUtil.javaClassPackage(dt.getContainer().getContainer()));
        } else {
            buf.append(JMIUtil.javaClassPackage(dt.getContainer()));
        }
        buf.append(".");
        buf.append(JMIUtil.nameOfClass(this.getName((ModelElement)dt)));
        buf.append("(");
        buf.append(this.fieldsParamInvokeList(dt));
        buf.append(");");
        this.line(buf);
        this.eblock();
    }

    private boolean isClassifierLevelAttribute(Object o) {
        if (o instanceof Attribute) {
            Attribute at = (Attribute)o;
            return ScopeKindEnum.CLASSIFIER_LEVEL == at.getScope() && !at.isDerived();
        }
        return false;
    }

    private void templateOperation(MofClass c) throws IOException {
        ArrayList<Operation> col = new ArrayList<Operation>();
        Iterator i = c.getContents().iterator();
        while (i.hasNext()) {
            Operation op;
            Object obj = i.next();
            if (!(obj instanceof Operation) || (op = (Operation)obj).getVisibility() != VisibilityKindEnum.PUBLIC_VIS || op.getScope() != ScopeKindEnum.CLASSIFIER_LEVEL) continue;
            col.add(op);
        }
        new GenMMOperationTemplate(col).operations();
    }

    private void processAllMetaObjects(Namespace ns, Set proxies) {
        Iterator i = ns.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Namespace)) continue;
            this.processAllMetaObjects((Namespace)o, proxies);
        }
        if (ns instanceof GeneralizableElement) {
            this.collectSubtypes((GeneralizableElement)ns, proxies);
        }
    }

    private void collectSubtypes(GeneralizableElement e, Set proxies) {
        List supertypes = e.getSupertypes();
        Iterator i = supertypes.iterator();
        while (i.hasNext()) {
            GeneralizableElement ge = (GeneralizableElement)i.next();
            this.collectSubtypes(ge, proxies);
        }
        Iterator i2 = supertypes.iterator();
        while (i2.hasNext()) {
            GeneralizableElement ge = (GeneralizableElement)i2.next();
            if (!proxies.contains(ge)) continue;
            proxies.add(e);
            break;
        }
    }

    private void collectClassifierFeatures() {
        Iterator i = this.utilNotImpl(this.thisCls, this.extendedClass(this.thisCls)).iterator();
        while (i.hasNext()) {
            MofClass nic = (MofClass)i.next();
            this.initStaticAttributes(nic);
        }
        this.classAttributes = Collections.unmodifiableSet(this.classAttributes);
    }

    private void initStaticAttributes(MofClass notImplCls) {
        Iterator i = notImplCls.getContents().iterator();
        while (i.hasNext()) {
            Attribute at;
            Object o = i.next();
            if (!(o instanceof Attribute) || (at = (Attribute)o).isDerived() || ScopeKindEnum.CLASSIFIER_LEVEL != at.getScope()) continue;
            this.classAttributes.add(at);
        }
    }

    private void declareCreateStructMethod(StructureType dt) {
        StringBuffer buf = this.declareCreateMethodName(dt);
        buf.append("(");
        buf.append(this.fieldsParamList((DataType)dt));
        buf.append(") throws javax.jmi.reflect.JmiException");
        this.line(buf);
    }

    private void noArgsCreateMethod(MofClass notImplCls) {
        StringBuffer buf = new StringBuffer("public final ");
        buf.append(this.type(notImplCls));
        buf.append(" ");
        buf.append(this.nameOfCreateMethod((Classifier)notImplCls));
        buf.append("() throws javax.jmi.reflect.JmiException");
        this.line(buf);
        this.sblock();
        buf.append("return (");
        buf.append(this.type(notImplCls));
        buf.append(")mdfOutermostPackage.create(");
        buf.append(this.type(notImplCls));
        buf.append(".class);");
        this.line(buf.toString());
        this.eblock();
    }

    private void pushAdditionAttributes(MofClass c) {
        Iterator i = c.getContents().iterator();
        while (i.hasNext()) {
            Attribute at;
            Object contentOb = i.next();
            if (!(contentOb instanceof Attribute) || this.instanceAttrs.contains(contentOb) || (at = (Attribute)contentOb).isDerived() || ScopeKindEnum.CLASSIFIER_LEVEL == at.getScope()) continue;
            this.instanceAttrs.add(at);
        }
    }

    private void fillInstanceAttributesBuffer(MofClass notImplCls) {
        this.instanceAttrs.clear();
        this.collectInstanceAttributes(notImplCls);
    }

    private String proxyPackage() {
        return JMIUtil.javaClassPackage(this.thisCls.getContainer());
    }

    private void argsCreateMethod(MofClass cl) {
        this.line(this.declareCreateMethodName(cl).append("(").append(this.methodParamList(this.instanceAttrs)).append(") throws javax.jmi.reflect.JmiException"));
        this.sblock();
        this.line(JMIUtil.implType((ModelElement)cl) + " o = (" + JMIUtil.implType((ModelElement)cl) + ")mdfOutermostPackage.create(" + this.type(cl) + ".class);");
        Iterator j = this.instanceAttrs.iterator();
        while (j.hasNext()) {
            Attribute at = (Attribute)j.next();
            int upper = at.getMultiplicity().getUpper();
            if (upper > 1 || upper == -1) {
                this.line("o." + JMIUtil.accessor((StructuralFeature)at) + ".addAll(" + this.getName((ModelElement)at) + ");");
                continue;
            }
            if (at.isChangeable()) {
                this.line("o." + JMIUtil.mutator(at, this.getName((ModelElement)at)) + ";");
                continue;
            }
            this.line("((" + JMIUtil.implType((ModelElement)this.thisCls) + ")o)." + JMIUtil.mutator(at, this.getName((ModelElement)at)) + ";");
        }
        this.line("return o;");
        this.eblock();
    }

    private StringBuffer declareCreateMethodName(StructureType c) {
        StringBuffer buf = new StringBuffer("public final ");
        buf.append(this.type(c)).append(" ").append(this.nameOfCreateMethod((DataType)c));
        return buf;
    }

    private StringBuffer declareCreateMethodName(MofClass c) {
        StringBuffer buf = new StringBuffer("public final ");
        buf.append(this.type(c)).append(" ").append(this.nameOfCreateMethod((Classifier)c));
        return buf;
    }

    private String nameOfCreateMethod(Classifier c) {
        if (c instanceof DataType) {
            DataType dt = (DataType)c;
            return this.nameOfCreateMethod(dt);
        }
        if (c instanceof MofClass) {
            return "create" + JMIUtil.nameOfInterface((ModelElement)c);
        }
        throw new RuntimeException("association until don't supported.");
    }

    private void rootAbstractMethods() {
        this.refGetValue();
        this.refSetValue();
        this.refFeaturedMethods(this.thisCls, (ScopeKind)ScopeKindEnum.CLASSIFIER_LEVEL);
        this.refClassMethods();
        this.refBaseObjectMethods((ModelElement)this.thisCls);
        this.mdfGetInstanceInterfaceClass(this.thisCls);
    }

    private void refSetValue() {
        this.sline("public void refSetValue(javax.jmi.reflect.RefObject feature, Object value)");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.sline();
        Iterator i = this.thisCls.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!this.isClassifierLevelAttribute(o) || !((Attribute)o).isChangeable()) continue;
            Attribute at = (Attribute)o;
            MultiplicityType mt = at.getMultiplicity();
            int upper = mt.getUpper();
            int lower = mt.getLower();
            this.pelseIf("ru.novosoft.mdf.impl.MDFBaseObjectImpl.checkQualifiedName(feature, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)at) + ")");
            if (upper == 1 && lower == 0) {
                this.line(JMIUtil.mutator(at, "(" + this.type((StructuralFeature)at) + ")value") + ";");
            } else if (upper == 1 && lower == 1) {
                this.line(JMIUtil.mutator(at, this.convertObjectToExpression(at.getType(), "value")) + ";");
            } else {
                this.line(this.vname((ModelElement)at) + ".clear();");
                this.line(this.vname((ModelElement)at) + ".addAll( (" + JMIUtil.javaCollectionInterface((StructuralFeature)at) + ")value );");
            }
            this.eif();
            this.sline("else ");
        }
        this.println();
        this.sblock();
        this.line("super.refSetValue( feature, value  );");
        this.eblock();
        this.eblock();
        this.sline("public void refSetValue(String feature, Object value)");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.sline();
        i = this.classAttributes.iterator();
        while (i.hasNext()) {
            Attribute at = (Attribute)i.next();
            MultiplicityType mt = at.getMultiplicity();
            int upper = mt.getUpper();
            int lower = mt.getLower();
            if (!at.isChangeable()) continue;
            this.pelseIf("\"" + this.name((ModelElement)at) + "\".equals(feature)");
            if (upper == 1 && lower == 0) {
                this.line(JMIUtil.mutator(at, "(" + this.type((StructuralFeature)at) + ")value") + ";");
            } else if (upper == 1 && lower == 1) {
                this.line(JMIUtil.mutator(at, this.convertObjectToExpression(at.getType(), "value")) + ";");
            } else {
                this.lineCollectionSetting(this.vname((ModelElement)at), "(java.util.Collection)value");
                this.line("return;");
            }
            this.eif();
            this.sline("else ");
        }
        this.line("super.refSetValue(feature, value);");
        this.eblock();
    }

    private void refGetValue() {
        int lower;
        int upper;
        MultiplicityType mt;
        this.line("public Object refGetValue(String feature) throws javax.jmi.reflect.JmiException");
        this.sblock();
        Iterator i = this.classAttributes.iterator();
        while (i.hasNext()) {
            Attribute a = (Attribute)i.next();
            String nm = this.getName((ModelElement)a);
            mt = a.getMultiplicity();
            upper = mt.getUpper();
            lower = mt.getLower();
            this.sif("\"" + nm + "\".equals(feature)");
            if (upper == 1 && lower == 0) {
                this.line("return " + JMIUtil.accessor((StructuralFeature)a) + ";");
            } else if (upper == 1 && lower == 1) {
                this.line("return " + this.convertExpressionToObject(a.getType(), JMIUtil.accessor((StructuralFeature)a)) + ";");
            } else {
                this.line("return " + JMIUtil.accessor((StructuralFeature)a) + ";");
            }
            this.eif();
        }
        this.line("return super.refGetValue( feature );");
        this.eblock();
        this.sline("public Object refGetValue(javax.jmi.reflect.RefObject feature)");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        i = this.thisCls.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!this.isClassifierLevelAttribute(o)) continue;
            Attribute at = (Attribute)o;
            mt = at.getMultiplicity();
            upper = mt.getUpper();
            lower = mt.getLower();
            this.sif("ru.novosoft.mdf.impl.MDFBaseObjectImpl.checkQualifiedName(feature, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)at) + ")");
            if (upper == 1 && lower == 0) {
                this.line("return " + JMIUtil.accessor((StructuralFeature)at) + ";");
            } else if (upper == 1 && lower == 1) {
                this.line("return " + this.convertExpressionToObject(at.getType(), JMIUtil.accessor((StructuralFeature)at)) + ";");
            } else {
                this.line("return " + JMIUtil.accessor((StructuralFeature)at) + ";");
            }
            this.eif();
        }
        this.line("return super.refGetValue(feature);");
        this.eblock();
    }

    private void mdfGetInterfaceClass(MofClass cl) {
        this.line("public Class mdfGetInterfaceClass()");
        this.sblock();
        this.line("return " + JMIUtil.javaInterfacePackage(cl.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)cl) + "Class.class;");
        this.eblock();
    }

    private void mdfGetInstanceInterfaceClass(MofClass cl) {
        this.line("public Class mdfGetInstanceInterfaceClass()");
        this.sblock();
        this.line("return " + JMIUtil.javaInterfacePackage(cl.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)cl) + ".class;");
        this.eblock();
    }

    private void refClassMethods() {
        this.fillInstanceAttributesBuffer(this.thisCls);
        this.refCreateInstanceMethod();
        this.refCreateEnum((Namespace)this.thisCls);
        this.genRefCreateStructByString();
        this.genRefCreateStructByMetaobject();
    }

    private void genRefCreateStructByMetaobject() {
        this.sline("public javax.jmi.reflect.RefStruct refCreateStruct(javax.jmi.reflect.RefObject dataType, java.util.List args)");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.generateTestForNull("dataType == null", "MDFClassImpl_NullEnumClass");
        Iterator i = this.thisCls.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!JMIUtil.isStruct(o)) continue;
            StructureType dt = (StructureType)o;
            this.sif("checkQualifiedName( dataType, " + JMIUtil.getQualifiedNameAsParamList((ModelElement)dt) + ")");
            this.sline("return create" + JMIUtil.nameOfInterface((ModelElement)dt) + "( ");
            List fields = this.getFields(dt);
            int j = 0;
            while (j < fields.size()) {
                StructureField field = (StructureField)fields.get(j);
                this.print(this.convertObjectToExpression(field.getType(), "args.get(" + j + ")"));
                this.print(j != fields.size() - 1 ? ", " : "");
                ++j;
            }
            this.println(");");
            this.eif();
        }
        this.line("throw new javax.jmi.reflect.InvalidNameException(null);");
        this.eblock();
    }

    private void genRefCreateStructByString() {
        this.sline("public javax.jmi.reflect.RefStruct refCreateStruct(String structName, java.util.List args)");
        this.println(" throws javax.jmi.reflect.JmiException");
        this.sblock();
        this.generateTestForNull("structName == null", "MDFClassImpl_NullStructClass");
        Iterator i = this.thisCls.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!JMIUtil.isStruct(o)) continue;
            StructureType dt = (StructureType)o;
            this.sif("\"" + this.getName((ModelElement)dt) + "\".equals( structName )");
            this.sline("return create" + JMIUtil.nameOfInterface((ModelElement)dt) + "( ");
            List fields = this.getFields(dt);
            int j = 0;
            while (j < fields.size()) {
                StructureField field = (StructureField)fields.get(j);
                this.print(this.convertObjectToExpression(field.getType(), "args.get(" + j + ")"));
                this.print(j != fields.size() - 1 ? ", " : "");
                ++j;
            }
            this.println(");");
            this.eif();
        }
        this.line("throw new javax.jmi.reflect.InvalidNameException(structName);");
        this.eblock();
    }

    private void refCreateInstanceMethod() {
        this.sline("public javax.jmi.reflect.RefObject refCreateInstance(java.util.List args)");
        this.println(" throws javax.jmi.reflect.JmiException");
        if (this.thisCls.isAbstract()) {
            this.sblock();
            this.line("String msg = mdfOutermostPackage.getLocalizedString(\"MDFNotImpl\");");
            this.line("throw new RuntimeException( msg );");
            this.eblock();
            return;
        }
        this.sblock();
        this.generateTestForNull("args == null", "MDFClassImpl_NullInstanceArgs");
        if (this.instanceAttrs.size() == 0) {
            this.sif("args.size() != 0");
            this.line("throw new javax.jmi.reflect.WrongSizeException(refMetaObject());");
            this.eif();
            this.line("return " + this.nameOfCreateMethod((Classifier)this.thisCls) + "();");
        } else {
            this.sif("args.size() == 0");
            this.line("return " + this.nameOfCreateMethod((Classifier)this.thisCls) + "();");
            this.eif();
            this.sif("args.size() != " + this.instanceAttrs.size());
            this.line("throw new javax.jmi.reflect.WrongSizeException(refMetaObject());");
            this.eif();
            this.line("Object o;");
            int i = 0;
            while (i < this.instanceAttrs.size()) {
                Attribute at = (Attribute)this.instanceAttrs.get(i);
                MultiplicityType mt = at.getMultiplicity();
                int upper = mt.getUpper();
                int lower = mt.getLower();
                this.line("o = args.get(" + i + ");");
                if (upper == 1 && lower == 0) {
                    this.sif("!(o instanceof " + this.type((StructuralFeature)at) + ")");
                    this.sline("throw new javax.jmi.reflect.TypeMismatchException(" + this.type((StructuralFeature)at));
                    this.println(".class, o, refMetaObject());");
                    this.eif();
                    this.line(this.type((StructuralFeature)at) + " " + this.getName((ModelElement)at) + " = (" + this.type((StructuralFeature)at) + ")o;");
                } else if (upper == 1 && lower == 1) {
                    String type = this.type((StructuralFeature)at);
                    Classifier c = JMIUtil.dereference(at.getType());
                    if (c instanceof PrimitiveType) {
                        MOFMultiplicityTypeImpl m = new MOFMultiplicityTypeImpl(0, 1, false, false);
                        type = this.type((PrimitiveType)c, (MultiplicityType)m);
                    }
                    this.sif("!(o instanceof " + type + ")");
                    this.sline("throw new javax.jmi.reflect.TypeMismatchException(" + type);
                    this.println(".class, o, refMetaObject());");
                    this.eif();
                    this.line(this.type((StructuralFeature)at) + " " + this.getName((ModelElement)at) + " = " + this.convertObjectToExpression(at.getType(), "o") + ";");
                } else {
                    this.sif("!(o instanceof " + JMIUtil.javaCollectionInterface((StructuralFeature)at) + ")");
                    this.sline("throw new javax.jmi.reflect.TypeMismatchException(" + JMIUtil.javaCollectionInterface((StructuralFeature)at));
                    this.println(".class, o, refMetaObject());");
                    this.eif();
                    this.sline(JMIUtil.javaCollectionInterface((StructuralFeature)at) + " " + this.getName((ModelElement)at));
                    this.println(" = (" + JMIUtil.javaCollectionInterface((StructuralFeature)at) + ")o;");
                }
                ++i;
            }
            this.line("return " + this.nameOfCreateMethod((Classifier)this.thisCls) + "(" + this.methodInvokeParam(this.instanceAttrs) + ");");
        }
        this.eblock();
    }

    private HashSet utilNotImpl() {
        return this.utilNotImpl(this.thisCls, this.extendedClass(this.thisCls));
    }

    private String proxyQualifiedName() {
        StringBuffer buf = new StringBuffer();
        buf.append(GenMMImplClassProxy.classPackage(this.extendedClass(this.thisCls)));
        buf.append(".");
        buf.append(GenMMImplClassProxy.proxyName(GenMMInterfaceWriter.jmi, this.extendedClass(this.thisCls)));
        return buf.toString();
    }

    private String methodParamList(List classAttributes) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < classAttributes.size()) {
            Attribute at = (Attribute)classAttributes.get(i);
            MultiplicityType mt = at.getMultiplicity();
            int upper = mt.getUpper();
            int lower = mt.getLower();
            if (upper == 1 && lower == 0) {
                buf.append(this.type((StructuralFeature)at));
            } else if (upper == 1 && lower == 1) {
                buf.append(this.type((StructuralFeature)at));
            } else {
                buf.append(JMIUtil.javaCollectionInterface((StructuralFeature)at));
            }
            buf.append(" ");
            buf.append(this.getName((ModelElement)at));
            if (i != this.instanceAttrs.size() - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    private String nameOfCreateMethod(DataType dt) {
        return "create" + JMIUtil.nameOfInterface((ModelElement)dt);
    }

    private static String classPackage(MofClass c) {
        return JMIUtil.javaClassPackage(c.getContainer());
    }

    private static String proxyName(JMIUtil jmi, MofClass proxy) {
        return JMIUtil.nameOfClass(GenMMInterfaceWriter.getName(jmi, (ModelElement)proxy), "Class");
    }
}

