/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import ru.novosoft.mdf.generator.GenMM;

public class GenMMWriter {
    protected static CharArrayWriter charArray = null;
    protected static StringBuffer iterNum = null;
    protected static StringBuffer indentLevel = null;
    protected static GenMM generator;
    private String indentString = "  ";
    private String fileName;
    private String filePackage;

    public GenMMWriter(GenMM generator, String pkg, String file) throws IOException {
        GenMMWriter.generator = generator;
        this.fileName = file;
        this.filePackage = pkg;
        charArray = new CharArrayWriter();
        indentLevel = new StringBuffer("0");
        iterNum = new StringBuffer("0");
    }

    public GenMMWriter() {
    }

    public GenMM getGenerator() {
        return generator;
    }

    public void prolog() {
    }

    public void line() {
        this.sline();
        this.println();
    }

    public void line(String s) {
        this.sline();
        this.println(s);
    }

    public void sline() {
        int level = Integer.parseInt("" + indentLevel);
        int i = 0;
        while (i < level) {
            this.print(this.indentString);
            ++i;
        }
    }

    public void sline(String s) {
        this.sline();
        this.print(s);
    }

    public void indent() {
        int level = Integer.parseInt("" + indentLevel);
        indentLevel.delete(0, indentLevel.length());
        indentLevel.append("" + ++level);
    }

    public void unindent() {
        int level = Integer.parseInt("" + indentLevel);
        indentLevel.delete(0, indentLevel.length());
        indentLevel.append("" + --level);
    }

    public void iline(String s) {
        this.indent();
        this.line(s);
    }

    public void uline(String s) {
        this.unindent();
        this.line(s);
    }

    public void iline() {
        this.indent();
        this.line();
    }

    public void uline() {
        this.unindent();
        this.line();
    }

    public void sblock() {
        this.line("{");
        this.indent();
    }

    public void eblock() {
        this.uline("}");
    }

    public void sfor(String arg) {
        this.line("for (" + arg + ")");
        this.sblock();
    }

    public void efor() {
        this.eblock();
    }

    public void sif(String arg) {
        this.line("if (" + arg + ")");
        this.sblock();
    }

    public void pelse() {
        this.eblock();
        this.line("else");
        this.sblock();
    }

    public void pelseIf(String expr) {
        this.println("if(" + expr + ")");
        this.sblock();
    }

    public void eif() {
        this.eblock();
    }

    public void swhile(String arg) {
        this.line("while (" + arg + ")");
        this.sblock();
    }

    public void ewhile() {
        this.eblock();
    }

    public void sdo() {
        this.line("do");
        this.sblock();
    }

    public void edo(String arg) {
        this.eblock();
        this.line("while (" + arg + ")");
    }

    public void sforeach(String col, String type, String obj) {
        int inum = Integer.parseInt("" + iterNum);
        iterNum.delete(0, iterNum.length());
        iterNum.append("" + ++inum);
        String ivar = "iter" + inum;
        this.line("Iterator " + ivar + " = " + col + ".iterator();");
        this.swhile(ivar + ".hasNext()");
        this.line(type + " " + obj + " = (" + type + ")" + ivar + ".next();");
    }

    public void eforeach() {
        this.ewhile();
    }

    public String vname(String name) {
        return "_" + name;
    }

    public void generateCustomCode() {
    }

    public void print(String s) {
        charArray.write(s, 0, s.length());
    }

    public void print() {
    }

    public void println(String s) {
        this.print(s + "\n");
    }

    public void println() {
        this.println("");
    }

    public void close() {
        if (this.isFileChanged()) {
            this.writeFile();
        }
        charArray.close();
    }

    protected void smodifier() {
        this.sblock();
        this.line("operationStarted();");
        this.line("try");
        this.sblock();
    }

    protected void emodifier() {
        this.eblock();
        this.line("finally");
        this.sblock();
        this.line("operationFinished();");
        this.eblock();
        this.eblock();
    }

    private boolean isFileChanged() {
        File file = generator.getFileName(this.filePackage, this.fileName);
        if ((long)charArray.size() >= file.length() && file.exists()) {
            return !this.isBuffersEquals(charArray.toCharArray(), this.getFileContents(file));
        }
        return true;
    }

    private boolean isBuffersEquals(char[] buf, char[] fileBuffer) {
        int i = 0;
        while (i < fileBuffer.length) {
            if (buf[i] != fileBuffer[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private char[] getFileContents(File file) {
        try {
            char[] fileBuffer = new char[(int)file.length()];
            FileReader fileReader = new FileReader(file);
            int offset = 0;
            int length = (int)file.length();
            while (fileReader.ready()) {
                int num = fileReader.read(fileBuffer, offset, length);
                offset += num;
                length -= num;
            }
            return fileBuffer;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void writeFile() {
        try {
            FileWriter fileWriter = new FileWriter(generator.getFileName(this.filePackage, this.fileName));
            charArray.writeTo(fileWriter);
            fileWriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static String uname(String a) {
        if (a.length() > 0) {
            return a.substring(0, 1).toUpperCase() + a.substring(1);
        }
        return a;
    }

    protected void generateTestForNull(String test, String resourceBundle, String errorKey) {
        this.sif(test);
        this.line("String msg = \"\";");
        this.line("msg = " + resourceBundle + ".getString(\"" + errorKey + "\");");
        this.line("throw new NullPointerException( msg );");
        this.eif();
    }

    protected void generateTestForNull(String test, String errorKey) {
        this.generateTestForNull(test, "mdfOutermostPackage.getResourceBundle()", errorKey);
    }
}

