/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jmi.model.Association;
import javax.jmi.model.DataType;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofException;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.model.StructureType;
import javax.jmi.model.Tag;
import javax.jmi.model.VisibilityKindEnum;
import ru.novosoft.mdf.ext.MDFObject;
import ru.novosoft.mdf.ext.MDFOutermostPackage;
import ru.novosoft.mdf.generator.impl.GenMMImplAssociation;
import ru.novosoft.mdf.generator.impl.GenMMImplClassProxy;
import ru.novosoft.mdf.generator.impl.GenMMImplException;
import ru.novosoft.mdf.generator.impl.GenMMImplHelper;
import ru.novosoft.mdf.generator.impl.GenMMImplObject;
import ru.novosoft.mdf.generator.impl.GenMMImplPackage;
import ru.novosoft.mdf.generator.impl.GenMMImplStruct;
import ru.novosoft.mdf.generator.impl.GenMMImplXMIReaderSAX2;
import ru.novosoft.mdf.generator.impl.GenMMImplXMIWriterSAX2;
import ru.novosoft.mdf.generator.jmi.GenMMAssociation;
import ru.novosoft.mdf.generator.jmi.GenMMClassProxy;
import ru.novosoft.mdf.generator.jmi.GenMMEnum;
import ru.novosoft.mdf.generator.jmi.GenMMImplEnum;
import ru.novosoft.mdf.generator.jmi.GenMMObject;
import ru.novosoft.mdf.generator.jmi.GenMMPackage;
import ru.novosoft.mdf.generator.jmi.GenMMStruct;
import ru.novosoft.mdf.generator.jmi.JMIUtil;
import ru.novosoft.mdf.impl.XMI11MOF13ReaderDOM;

public class GenMM {
    final String outputDirectory;
    final Properties config = new Properties();
    final boolean generateJmiInterfaces;
    boolean generateImpl;
    final HashMap implNeedHelper = new HashMap();
    HashSet allClasses = new HashSet();
    HashSet allDataTypes = new HashSet();
    HashSet allPrimitiveTypes = new HashSet();
    HashSet allEnumerationTypes = new HashSet();
    HashSet allStructureTypes = new HashSet();
    HashSet allCollectionTypes = new HashSet();
    HashSet allAliasTypes = new HashSet();
    HashSet allConstraints = new HashSet();
    HashSet allPackages = new HashSet();
    HashSet allAssociations = new HashSet();
    HashSet allTags = new HashSet();
    private Set allImports = new HashSet();
    private MDFOutermostPackage extent;
    private JMIUtil jmi = null;
    private static final String OUTERMOST_PACKAGE_CLASS = "ru.novosoft.mdf.mof.impl.model.MOFModelPackageImpl";

    public GenMM(String mf, String d, String cf, String version) {
        this.loadConfig(cf);
        this.generateJmiInterfaces = "true".equals(this.config.getProperty("jmi_interfaces.generate"));
        this.generateImpl = "true".equals(this.config.getProperty("impl.generate"));
        this.outputDirectory = d;
        this.loadModel(mf, version);
        this.jmi = new JMIUtil(this.extent, this.config, this);
        this.collectInformation();
        this.generate();
    }

    public Collection getRoots() {
        return this.extent.getRoots();
    }

    public Collection getAllClasses() {
        return this.allClasses;
    }

    public Collection getAllPackages() {
        return this.allPackages;
    }

    public Collection getAllDataTypes() {
        return this.allDataTypes;
    }

    public Collection getAllPrimitiveTypes() {
        return this.allPrimitiveTypes;
    }

    public Collection getAllStructureTypes() {
        return this.allStructureTypes;
    }

    public Collection getAllEnumerationTypes() {
        return this.allEnumerationTypes;
    }

    public Collection getAllCollectionTypes() {
        return this.allCollectionTypes;
    }

    public Collection getAllAliasTypes() {
        return this.allAliasTypes;
    }

    public Collection getAllAssociations() {
        return this.allAssociations;
    }

    public Collection getAllImports() {
        return this.allImports;
    }

    public File getFileName(String pkg, String file) {
        StringTokenizer stk = new StringTokenizer(pkg, ".", false);
        File rc = new File(this.outputDirectory);
        while (stk.hasMoreTokens()) {
            String tk = stk.nextToken();
            rc = new File(rc, tk);
        }
        rc.mkdirs();
        return new File(rc, file);
    }

    public String getProperty(String k) {
        return this.config.getProperty(k);
    }

    public void generate() {
        this.generateImpl = true;
        try {
            Iterator i = this.allClasses.iterator();
            while (i.hasNext()) {
                MofClass c = (MofClass)i.next();
                this.startExceptionGenerator((Namespace)c);
                if (this.checkInterfaces((ModelElement)c)) {
                    new GenMMObject(this, c, this.jmi);
                    if (VisibilityKindEnum.PUBLIC_VIS == c.getVisibility() && !this.isIgnoreLifecycle((ModelElement)c)) {
                        new GenMMClassProxy(this, c, this.jmi);
                    }
                }
                if (!this.generateImpl) continue;
                new GenMMImplObject(this, c, this.jmi);
                if (this.needGenerateHelper(c)) {
                    new GenMMImplHelper(this, c, this.jmi);
                }
                if (VisibilityKindEnum.PUBLIC_VIS != c.getVisibility() || this.isIgnoreLifecycle((ModelElement)c)) continue;
                new GenMMImplClassProxy(this, c, this.jmi);
            }
            Iterator i2 = this.allPackages.iterator();
            while (i2.hasNext()) {
                MofPackage p = (MofPackage)i2.next();
                this.startExceptionGenerator((Namespace)p);
                if (this.isIgnoreLifecycle((ModelElement)p)) continue;
                if (this.checkInterfaces((ModelElement)p)) {
                    new GenMMPackage(this, p, this.jmi);
                }
                if (!this.generateImpl) continue;
                new GenMMImplPackage(this, p, this.jmi);
            }
            Iterator i3 = this.allEnumerationTypes.iterator();
            while (i3.hasNext()) {
                EnumerationType et = (EnumerationType)i3.next();
                if (this.checkInterfaces((ModelElement)et)) {
                    new GenMMEnum(this, et, this.jmi);
                }
                if (!this.generateImpl) continue;
                new GenMMImplEnum(this, et, this.jmi);
            }
            Iterator i4 = this.allStructureTypes.iterator();
            while (i4.hasNext()) {
                StructureType st = (StructureType)i4.next();
                if (this.checkInterfaces((ModelElement)st)) {
                    new GenMMStruct(this, st, this.jmi);
                }
                if (!this.generateImpl) continue;
                new GenMMImplStruct(this, st, this.jmi);
            }
            Iterator i5 = this.allAssociations.iterator();
            while (i5.hasNext()) {
                Association a = (Association)i5.next();
                if (this.isIgnoreLifecycle((ModelElement)a)) continue;
                if (this.checkInterfaces((ModelElement)a)) {
                    new GenMMAssociation(this, a, this.jmi);
                }
                if (!this.generateImpl) continue;
                new GenMMImplAssociation(this, a, this.jmi);
            }
            Iterator i6 = this.allClasses.iterator();
            while (i6.hasNext()) {
                MofClass c = (MofClass)i6.next();
                Iterator j = c.getContents().iterator();
                while (j.hasNext()) {
                    Object m = j.next();
                    if (m instanceof EnumerationType) {
                        EnumerationType et = (EnumerationType)m;
                        if (this.checkInterfaces((ModelElement)et)) {
                            new GenMMEnum(this, et, this.jmi);
                        }
                        if (!this.generateImpl) continue;
                        new GenMMImplEnum(this, et, this.jmi);
                        continue;
                    }
                    if (!(m instanceof StructureType)) continue;
                    StructureType st = (StructureType)m;
                    if (this.generateImpl) {
                        new GenMMImplStruct(this, st, this.jmi);
                    }
                    if (!this.checkInterfaces((ModelElement)st)) continue;
                    new GenMMStruct(this, st, this.jmi);
                }
            }
            if (this.generateImpl) {
                new GenMMImplXMIWriterSAX2(this, this.extent, this.jmi);
                new GenMMImplXMIReaderSAX2(this, this.extent, this.jmi);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            throw new RuntimeException(ex.toString());
        }
    }

    public boolean needGenerateHelper(MofClass e) {
        return Boolean.TRUE.equals(this.implNeedHelper.get(e));
    }

    public void collectInformation() {
        Iterator i = this.extent.getRoots().iterator();
        while (i.hasNext()) {
            MofPackage p = (MofPackage)i.next();
            this.collectInformation(p);
            this.allPackages.add(p);
        }
    }

    private boolean checkInterfaces(ModelElement m) {
        if (this.generateJmiInterfaces) {
            return true;
        }
        String str = null;
        if (m instanceof MofClass) {
            str = JMIUtil.javaInterfacePackage(((MofClass)m).getContainer());
        } else if (m instanceof MofPackage) {
            str = JMIUtil.javaInterfacePackage((Namespace)((MofPackage)m));
        } else if (m instanceof StructureType) {
            str = this.type((StructureType)m);
        } else if (m instanceof EnumerationType) {
            str = this.type((EnumerationType)m);
        } else if (m instanceof Association) {
            str = JMIUtil.javaInterfacePackage(((Association)m).getContainer());
        }
        return !str.startsWith("javax.jmi.");
    }

    private void collectInformation(MofPackage p) {
        try {
            Iterator i = p.getContents().iterator();
            while (i.hasNext()) {
                Object e = i.next();
                if (e instanceof Import) {
                    this.allImports.add(e);
                    continue;
                }
                if (e instanceof EnumerationType) {
                    this.collectEnumerationTypeInfo((EnumerationType)e);
                    this.allEnumerationTypes.add(e);
                    continue;
                }
                if (e instanceof StructureType) {
                    this.collectStructureTypeInfo((StructureType)e);
                    this.allStructureTypes.add(e);
                    continue;
                }
                if (e instanceof MofClass) {
                    this.collectClassInfo((MofClass)e);
                    this.allClasses.add(e);
                    continue;
                }
                if (e instanceof Association) {
                    this.collectAssociationInfo((Association)e);
                    this.allAssociations.add(e);
                    continue;
                }
                if (e instanceof MofPackage) {
                    this.collectPackageInfo((MofPackage)e);
                    this.collectInformation((MofPackage)e);
                    this.allPackages.add(e);
                    continue;
                }
                if (!(e instanceof Tag)) continue;
                this.allTags.add(e);
            }
        }
        catch (Exception ex) {
            System.out.println("2 " + p.getName());
            ex.printStackTrace(System.out);
        }
    }

    private void collectDataTypeInfo(DataType e) {
    }

    private void collectEnumerationTypeInfo(EnumerationType e) {
    }

    private void collectStructureTypeInfo(StructureType e) {
    }

    private void collectClassInfo(MofClass c) {
        List scs;
        if (this.generateImpl && (scs = c.getSupertypes()).size() > 1) {
            HashSet s = new HashSet();
            HashSet<MofClass> s2 = new HashSet<MofClass>();
            Iterator i = scs.iterator();
            MofClass sc1 = (MofClass)i.next();
            GenMM.getAllSupertypes(sc1, s);
            while (i.hasNext()) {
                MofClass sc = (MofClass)i.next();
                s2.add(sc);
                GenMM.getAllSupertypes(sc, s2);
            }
            s2.removeAll(s);
            s2.removeAll(this.implNeedHelper.keySet());
            Iterator j = s2.iterator();
            while (j.hasNext()) {
                MofClass sc = (MofClass)j.next();
                this.implNeedHelper.put(sc, GenMMImplHelper.checkEmptyHelper(this, sc));
            }
        }
    }

    private void collectAssociationInfo(Association e) {
    }

    private void collectPackageInfo(MofPackage e) {
    }

    private void loadConfig(String fileName) {
        try {
            FileInputStream is = new FileInputStream(fileName);
            if (is == null) {
                String msg = "Can't find config.properties resource. Check your CLASSPATH variable.";
                throw new RuntimeException(msg);
            }
            this.config.load(is);
            ((InputStream)is).close();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            throw new RuntimeException(ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadModel(String modelFile, String version) {
        try {
            Class<?> cls = Class.forName(OUTERMOST_PACKAGE_CLASS);
            this.extent = (MDFOutermostPackage)cls.newInstance();
            String mofVersion = version;
            String resource = this.getProperty("metamodel.resource");
            FileInputStream is = new FileInputStream(modelFile);
            try {
                if ("1.4".equals(mofVersion)) {
                    this.extent.getXMIReader("1.1").read(this.extent, (InputStream)is);
                } else if ("1.3".equals(mofVersion)) {
                    XMI11MOF13ReaderDOM converter = new XMI11MOF13ReaderDOM();
                    converter.read(this.extent, (InputStream)is);
                    System.out.println("model is converted");
                } else {
                    String msg = "Unsupported MOF version: " + mofVersion + ". Must be 1.4 or 1.3";
                    throw new RuntimeException(msg);
                }
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            File resourceFile = new File(this.outputDirectory, resource.replace('/', File.separatorChar));
            resourceFile.getParentFile().mkdirs();
            this.extent.getXMIWriter("1.1").write(this.extent, resourceFile.toString());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            throw new RuntimeException(ex.toString());
        }
    }

    public static void getAllSupertypes(MofClass c, Set s) {
        Iterator i = c.getSupertypes().iterator();
        while (i.hasNext()) {
            MofClass sc = (MofClass)i.next();
            s.add(sc);
            GenMM.getAllSupertypes(sc, s);
        }
    }

    public static void main(String[] args) {
        try {
            String mf = null;
            String d = null;
            String cf = null;
            String version = "1.4";
            int n = args.length;
            int i = 0;
            while (i < n) {
                if ("-model".equals(args[i])) {
                    if (mf != null || i + 1 >= n) {
                        GenMM.usage();
                    }
                    mf = args[i + 1];
                    ++i;
                }
                if ("-d".equals(args[i])) {
                    if (d != null || i + 1 >= n) {
                        GenMM.usage();
                    }
                    d = args[i + 1];
                    ++i;
                }
                if ("-config".equals(args[i])) {
                    if (cf != null || i + 1 >= n) {
                        GenMM.usage();
                    }
                    cf = args[i + 1];
                    ++i;
                }
                if ("-version".equals(args[i])) {
                    if (i + 1 >= n) {
                        GenMM.usage();
                    }
                    version = args[i + 1];
                    ++i;
                }
                ++i;
            }
            new GenMM(mf, d, cf, version);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.out);
            throw ex;
        }
    }

    public static void usage() {
        System.out.println("GenMM: Novosoft Metadata Framework generator");
        System.out.println("usage:");
        System.out.println("GenMM -model <model file> -d <output directory> -config <config file>");
        System.out.println(" <model file> - file that contain metamodel which will be used for generation");
        System.out.println(" <output directory> - directory where files will be put");
        System.out.println(" <config file> - configuration file that tailorgeneration process");
        throw new RuntimeException("command line is incorrect");
    }

    private boolean isIgnoreLifecycle(ModelElement m) {
        Iterator i = this.allTags.iterator();
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            if (!"ignoreLifecycle".equals(tag.getTagId())) continue;
            List values = tag.getValues();
            if (values.size() != 1) {
                System.out.print("warning: isIgnoreLifeCycle in metamodel has more then one value");
                System.out.println(", tagId = " + tag.getTagId() + ", xmi.id = " + ((MDFObject)tag).mdfGenXmiId());
                continue;
            }
            String tagValue = (String)values.get(0);
            if ("true".equals(tagValue)) {
                return tag.getElements().contains(m);
            }
            return false;
        }
        return false;
    }

    private void startExceptionGenerator(Namespace p) {
        try {
            Iterator k = p.getContents().iterator();
            while (k.hasNext()) {
                Object o = k.next();
                if (!(o instanceof MofException)) continue;
                new GenMMImplException(this, this.jmi, (MofException)o);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String type(EnumerationType type) {
        if (type.getContainer() instanceof MofPackage) {
            return JMIUtil.javaInterfacePackage(type.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)type);
        }
        return JMIUtil.javaInterfacePackage(type.getContainer().getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)type);
    }

    private String type(StructureType type) {
        if (type.getContainer() instanceof MofPackage) {
            return JMIUtil.javaInterfacePackage(type.getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)type);
        }
        return JMIUtil.javaInterfacePackage(type.getContainer().getContainer()) + "." + JMIUtil.nameOfInterface((ModelElement)type);
    }
}

