/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import ru.novosoft.mdf.ext.MDFObject;
import ru.novosoft.mdf.ext.MDFOutermostPackage;
import ru.novosoft.mdf.ext.xmi.XMIWriter;
import ru.novosoft.mdf.impl.xmi.writers.DataWriter;

public abstract class XMI11WriterSAX2
extends XMIWriter {
    protected int attrKey = 0;
    protected MDFOutermostPackage mdfOutermostPackage;
    private DataWriter dw = new DataWriter();
    public static final int ATTR_AS_ATTR = 0;
    public static final int ATTR_AS_ELEMENT = 1;
    public static final Comparator xmiIdComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String id1 = ((MDFObject)o1).mdfGenXmiId();
            String id2 = ((MDFObject)o2).mdfGenXmiId();
            return id1.compareTo(id2);
        }
    };
    public static final int IDENT_STEP = 2;

    public void setAttrKey(int val) {
        this.attrKey = val;
    }

    public void write(OutputStream stream, RefPackage extent, String xmiVersion) throws IOException {
        this.write(stream, extent);
    }

    public void write(OutputStream stream, Collection objects, String xmiVersion) throws IOException {
        throw new RuntimeException();
    }

    public void write(MDFOutermostPackage r, String file) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(file));
            this.write(r, fos);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void write(MDFOutermostPackage r, OutputStream fos) {
        this.write(fos, r.getRoots());
    }

    public final void write(OutputStream out, RefPackage extent) {
        this.dw.setIndentStep(2);
        this.setAttrKey(0);
        this.dw.setOutput(new OutputStreamWriter(out));
        try {
            HashSet objects = new HashSet();
            this.mdfOutermostPackage = (MDFOutermostPackage)extent.refOutermostPackage();
            this.processModel(this.mdfOutermostPackage.getRoots());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public final void write(OutputStream stream, Collection objects) {
        this.setAttrKey(0);
        this.dw.setIndentStep(2);
        this.dw.setOutput(new OutputStreamWriter(stream));
        try {
            this.processModel(objects);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public final void processModel(Collection objects) throws SAXException {
        this.dw.startDocument();
        AttributesImpl attr = new AttributesImpl();
        this.forceNS();
        attr.addAttribute("", "xmi.version", "xmi.version", "String", "1.1");
        this.dw.startElement("", "XMI", "", attr);
        this.dw.startElement("", "XMI.header");
        this.fillXMIHeader();
        this.dw.endElement("", "XMI.header");
        this.dw.startElement("", "XMI.content");
        this.processOwnedElements(objects);
        this.processAssociations();
        this.dw.endElement("", "XMI.content");
        this.dw.endElement("", "XMI", "");
        this.dw.endDocument();
    }

    protected final String getXMIId(RefObject e) {
        return ((MDFObject)e).mdfGenXmiId();
    }

    protected abstract String getValueForEnum(Object var1);

    protected abstract void getElementName(Class var1, String[] var2);

    protected void forceNS() {
        String[][] allInfo = this.forceNSInfo();
        int i = 0;
        while (i < allInfo.length) {
            String uri = allInfo[i][0];
            String ns = allInfo[i][1];
            this.dw.forceNSDecl(ns, uri);
            ++i;
        }
    }

    protected AttributesImpl prepareAttributes(AttributesImpl allAttr) {
        AttributesImpl attrs = new AttributesImpl();
        String val = allAttr.getValue("", "xmi.id");
        if (val != null) {
            attrs.addAttribute("", "xmi.id", "", "String", val);
        }
        if ((val = allAttr.getValue("", "xmi.uuid")) != null) {
            attrs.addAttribute("", "xmi.uuid", "", "String", val);
        }
        if ((val = allAttr.getValue("", "xmi.label")) != null) {
            attrs.addAttribute("", "xmi.label", "", "String", val);
        }
        if ((val = allAttr.getValue("", "xmi.idref")) != null) {
            attrs.addAttribute("", "xmi.idref", "", "String", val);
        }
        return attrs;
    }

    protected abstract void processAssociations() throws SAXException;

    protected abstract String[][] forceNSInfo();

    protected final void processOwnedElements(Collection ch) throws SAXException {
        TreeSet c;
        if (!(ch instanceof List)) {
            c = new TreeSet(xmiIdComparator);
            c.addAll(ch);
        } else {
            c = ch;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object m = i.next();
            if (!(m instanceof MDFObject)) continue;
            this.processElement((MDFObject)m);
        }
    }

    protected final void processEnum(AttributesImpl e, String name, Object val) throws SAXException {
        if (this.attrKey == 0 && val != null) {
            e.addAttribute("", name, name, "String", val.toString());
        }
    }

    protected final void processBoolean(AttributesImpl attrs, String name, boolean val) throws SAXException {
        if (this.attrKey == 0) {
            attrs.addAttribute("", name, name, "Boolean", "" + val);
        }
    }

    protected final void processBoolean(AttributesImpl attrs, String name, Boolean val) throws SAXException {
        if (val != null) {
            this.processBoolean(attrs, name, (boolean)val);
        }
    }

    protected final void processInt(AttributesImpl e, String name, int val) throws SAXException {
        if (this.attrKey == 0) {
            e.addAttribute("", name, name, "Integer", "" + val);
        }
    }

    protected final void processInt(AttributesImpl e, String name, Integer val) throws SAXException {
        if (val != null) {
            this.processInt(e, name, (int)val);
        }
    }

    protected final void processLong(AttributesImpl e, String name, int val) throws SAXException {
        if (this.attrKey == 0) {
            e.addAttribute("", name, name, "Long", "" + val);
        }
    }

    protected final void processFloat(AttributesImpl e, String name, float val) throws SAXException {
        if (this.attrKey == 0) {
            e.addAttribute("", name, name, "Float", "" + val);
        }
    }

    protected final void processDouble(AttributesImpl e, String name, int val) throws SAXException {
        if (this.attrKey == 0) {
            e.addAttribute("", name, name, "Double", "" + val);
        }
    }

    protected final void processString(AttributesImpl e, String name, String val) throws SAXException {
        if (this.attrKey == 0 && val != null) {
            e.addAttribute("", name, name, "String", val);
        }
    }

    protected final void createStartFieldElement(String uri, String localName, String qName) throws SAXException {
        this.dw.startElement(uri, localName, qName, new AttributesImpl());
    }

    protected final void createEndFieldElement(String uri, String localName, String qName) throws SAXException {
        this.dw.endElement(uri, localName, qName);
    }

    protected final void processStringCollection(String uri, String localName, String qName, Collection vals) throws SAXException {
        TreeSet c = !(vals instanceof List) ? new TreeSet(vals) : vals;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.createStartFieldElement(uri, localName, qName);
            this.dw.characters((String)i.next());
            this.createEndFieldElement(uri, localName, qName);
        }
    }

    protected final void processOwnedElements(String uri, String localName, String qName, Collection ch) throws SAXException {
        TreeSet c;
        if (!(ch instanceof List)) {
            c = new TreeSet(xmiIdComparator);
            c.addAll(ch);
        } else {
            c = ch;
        }
        if (c.size() > 0) {
            this.createStartFieldElement(uri, localName, qName);
            this.processOwnedElements(c);
            this.createEndFieldElement(uri, localName, qName);
        }
    }

    protected final void processOwnedElement(String uri, String localName, String qName, RefObject ch) throws SAXException {
        if (ch != null) {
            this.createStartFieldElement(uri, localName, qName);
            this.processElement(ch);
            this.createEndFieldElement(uri, localName, qName);
        }
    }

    protected final void processReference(AttributesImpl a, String name, RefObject ref) throws SAXException {
        if (this.attrKey == 0 && ref != null) {
            a.addAttribute("", name, "", "String", this.getXMIId(ref));
        }
    }

    protected final void processReferenceList(AttributesImpl e, String name, Collection refs) throws SAXException {
        if (this.attrKey == 0) {
            TreeSet c;
            if (refs instanceof List) {
                c = refs;
            } else {
                c = new TreeSet(xmiIdComparator);
                c.addAll(refs);
            }
            StringBuffer a = new StringBuffer();
            boolean first = true;
            Iterator i = c.iterator();
            while (i.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    a.append(' ');
                }
                a.append(this.getXMIId((MDFObject)i.next()));
            }
            if (a.length() != 0) {
                e.addAttribute("", name, "", "String", a.toString());
            }
        }
    }

    protected final void processField(int arg) throws SAXException {
        this.dw.startElement("", "XMI.field");
        this.dw.characters("" + arg);
        this.dw.endElement("", "XMI.field");
    }

    protected final void processField(boolean arg) throws SAXException {
        this.dw.startElement("", "XMI.field");
        this.dw.characters("" + arg);
        this.dw.endElement("", "XMI.field");
    }

    protected final void processField(String arg) throws SAXException {
        this.dw.startElement("", "XMI.field");
        this.dw.characters(arg);
        this.dw.endElement("", "XMI.field");
    }

    protected final void processField(double arg) throws SAXException {
        this.dw.startElement("", "XMI.field");
        this.dw.characters("" + arg);
        this.dw.endElement("", "XMI.field");
    }

    protected void intValueAsElement(String uri, String localName, int value) throws SAXException {
        if (this.attrKey != 0) {
            this.dw.dataElement(uri, localName, "" + value);
        }
    }

    protected void intValueAsElement(String uri, String localName, Integer value) throws SAXException {
        if (value != null) {
            this.intValueAsElement(uri, localName, (int)value);
        }
    }

    protected void booleanValueAsElement(String uri, String localName, boolean value) throws SAXException {
        if (this.attrKey != 0) {
            this.dw.dataElement(uri, localName, "" + value);
        }
    }

    protected void booleanValueAsElement(String uri, String localName, Boolean value) throws SAXException {
        if (value != null) {
            this.booleanValueAsElement(uri, localName, (boolean)value);
        }
    }

    protected void longValueAsElement(String uri, String localName, long value) throws SAXException {
        if (this.attrKey != 0) {
            this.dw.dataElement(uri, localName, "" + value);
        }
    }

    protected void floatValueAsElement(String uri, String localName, double value) throws SAXException {
        if (this.attrKey != 0) {
            this.dw.dataElement(uri, localName, "" + value);
        }
    }

    protected void doubleValueAsElement(String uri, String localName, double value) throws SAXException {
        if (this.attrKey != 0) {
            this.dw.dataElement(uri, localName, "" + value);
        }
    }

    protected void stringValueAsElement(String uri, String localName, String value) throws SAXException {
        if (this.attrKey != 0 && value != null && !"".equals(value)) {
            this.dw.dataElement(uri, localName, value);
        }
    }

    protected void enumValueAsElement(String uri, String localName, Object value) throws SAXException {
        if (this.attrKey != 0 && value != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "xmi.value", "", "String", value.toString());
            this.dw.emptyElement(uri, localName, "", attrs);
        }
    }

    protected void refValueAsElement(String uri, String localName, String refType, RefObject el) throws SAXException {
        if (this.attrKey != 0 && el != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "xmi.idref", "", "String", ((MDFObject)el).mdfGenXmiId());
            this.dw.startElement(uri, localName);
            this.dw.emptyElement(uri, refType, "", attrs);
            this.dw.endElement(uri, localName);
        }
    }

    protected void refListValuesAsElements(String uri, String localName, String refType, Collection refs) throws SAXException {
        if (this.attrKey != 0) {
            TreeSet c;
            if (!(refs instanceof List)) {
                c = new TreeSet(xmiIdComparator);
                c.addAll(refs);
            } else {
                c = refs;
            }
            Iterator i = c.iterator();
            while (i.hasNext()) {
                MDFObject e = (MDFObject)i.next();
                this.refValueAsElement(uri, localName, refType, e);
            }
        }
    }

    protected abstract void collectAttributes(MDFObject var1, AttributesImpl var2) throws SAXException;

    protected abstract void processContentAsElements(MDFObject var1) throws SAXException;

    protected final void processElement(RefObject e) {
        try {
            Class cls = ((MDFObject)e).mdfGetInterfaceClass();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "xmi.id", "", "String", this.getXMIId(e));
            this.collectAttributes((MDFObject)e, attrs);
            if (this.attrKey == 1) {
                attrs = this.prepareAttributes(attrs);
            }
            String[] vals = new String[2];
            this.getElementName(((MDFObject)e).mdfGetInterfaceClass(), vals);
            String uri = vals[0];
            String name = vals[1];
            this.dw.startElement(uri, name, "", attrs);
            this.processContentAsElements((MDFObject)e);
            this.dw.endElement(uri, name);
        }
        catch (RuntimeException ex1) {
            throw ex1;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            throw new RuntimeException(ex2.getMessage());
        }
    }

    protected void startLink(String uri, String ascName, String role1, RefObject obj, String role2, RefObject m) {
        try {
            AttributesImpl attrs = new AttributesImpl();
            this.processReference(attrs, role1, obj);
            this.processReference(attrs, role2, m);
            this.dw.startElement(uri, ascName, "", attrs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void endLink(String uri, String ascName) {
        try {
            this.dw.endElement(uri, ascName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void fillXMIHeader() throws SAXException {
        this.dw.startElement("", "XMI.documentation");
        this.dw.dataElement("XMI.exporter", this.getClass().getName());
        this.dw.endElement("", "XMI.documentation");
    }
}

