/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.jmi.reflect.WrongSizeException;
import ru.novosoft.mdf.impl.MDFFeatureListImpl;

class SubList
extends MDFFeatureListImpl {
    private int offset;
    private int size;
    private List subList = null;

    SubList(MDFFeatureListImpl l, int fromIndex, int toIndex) {
        super(l);
        if (fromIndex < 0 || toIndex > this.list.size()) {
            throw new WrongSizeException(this.owner.refMetaObject());
        }
        if (fromIndex > toIndex) {
            throw new WrongSizeException(this.owner.refMetaObject());
        }
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
        this.subList = this.list.subList(fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        Object removed;
        block5: {
            Object object;
            removed = null;
            this.operationStarted();
            try {
                if (index < 0 || index >= this.size) {
                    throw new WrongSizeException(this.owner.refMetaObject());
                }
                if (this.subList.get(index) != element) break block5;
                object = element;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.operationFinished();
                throw throwable;
            }
            this.operationFinished();
            return object;
        }
        if (this.verify(element)) {
            this.checkAddedElement(element);
            removed = this.subList.get(index);
            this.subList.set(index, element);
            this.elementSetAt(index + this.offset, removed, element);
        }
        Object var6_6 = null;
        this.operationFinished();
        return removed;
    }

    public Object get(int index) {
        this.rangeCheck(index);
        return this.subList.get(index);
    }

    public boolean isEmpty() {
        return this.subList.isEmpty();
    }

    public int size() {
        return this.subList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object element) {
        this.operationStarted();
        try {
            this.rangeCheck(index);
            if (this.verify(element)) {
                this.checkAddedElement(element);
                this.subList.add(index, element);
                this.elementAdded(index + this.offset, element);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.operationFinished();
            throw throwable;
        }
        this.operationFinished();
        ++this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        Object removed = null;
        this.operationStarted();
        try {
            if (index < 0 || index >= this.size) {
                throw new WrongSizeException(this.owner.refMetaObject());
            }
            removed = this.subList.remove(index);
            this.elementRemoved(index + this.offset, removed);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.operationFinished();
            throw throwable;
        }
        this.operationFinished();
        --this.size;
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(Object o) {
        block5: {
            boolean bl;
            this.operationStarted();
            try {
                int index = 0;
                while (true) {
                    if (index >= this.subList.size()) {
                        break block5;
                    }
                    if (this.subList.get(index).equals(o)) {
                        Object removed = this.subList.remove(index);
                        this.elementRemoved(index + this.offset, removed);
                        --this.size;
                        bl = true;
                        Object var6_5 = null;
                        break;
                    }
                    ++index;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.operationFinished();
                throw throwable;
            }
            this.operationFinished();
            return bl;
        }
        Object var6_6 = null;
        this.operationFinished();
        return false;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection c) {
        int cSize;
        block4: {
            this.operationStarted();
            this.rangeCheck(index);
            cSize = c.size();
            if (cSize != 0) break block4;
            boolean bl = false;
            Object var8_6 = null;
            this.operationFinished();
            return bl;
        }
        try {
            this.checkNotNull(c);
            this.checkWideBounds(index + this.offset);
            this.checkCollection(c);
            int pos = index;
            this.subList.addAll(index, c);
            Iterator i = c.iterator();
            while (i.hasNext()) {
                Object element = i.next();
                this.elementAdded(pos++, element);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.operationFinished();
            throw throwable;
        }
        this.operationFinished();
        this.size += cSize;
        return true;
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        return new MDFFeatureListImpl.MDFListIteratorImpl(this.subList, index);
    }

    public List subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    public void clear() {
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        this.size = 0;
    }

    public boolean add(Object o) {
        this.add(this.size, o);
        return true;
    }

    public boolean contains(Object o) {
        return this.subList.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.subList.containsAll(c);
    }

    public boolean equals(Object o) {
        return this.subList.equals(o);
    }

    public int indexOf(Object o) {
        return this.subList.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.subList.lastIndexOf(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection c) {
        this.checkNotNull(c);
        boolean rc = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            int j = 0;
            while (j < this.subList.size()) {
                if (this.subList.get(j).equals(o)) {
                    Object var8_7;
                    this.operationStarted();
                    try {
                        Object removed = this.subList.remove(j);
                        this.elementRemoved(j + this.offset, removed);
                        var8_7 = null;
                    }
                    catch (Throwable throwable) {
                        var8_7 = null;
                        this.operationFinished();
                        throw throwable;
                    }
                    this.operationFinished();
                    --this.size;
                    rc = true;
                }
                ++j;
            }
        }
        this.subList.removeAll(c);
        return rc;
    }

    public boolean retainAll(Collection c) {
        this.checkNotNull(c);
        int oldSize = this.size();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (c.contains(o)) continue;
            i.remove();
        }
        return oldSize != this.size;
    }

    public Object[] toArray() {
        return this.subList.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.subList.toArray(a);
    }

    public int hashCode() {
        return this.subList.hashCode();
    }

    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > this.subList.size()) {
            throw new WrongSizeException(this.owner.refMetaObject());
        }
        MDFFeatureListImpl.MDFListIteratorImpl it = new MDFFeatureListImpl.MDFListIteratorImpl(this.subList, fromIndex);
        int i = 0;
        int n = toIndex - fromIndex;
        while (i < n) {
            it.next();
            it.remove();
            ++i;
        }
        this.size -= toIndex - fromIndex;
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.size) {
            throw new WrongSizeException(this.owner.refMetaObject());
        }
    }
}

