/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.ClosureViolationException;
import javax.jmi.reflect.DuplicateException;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.WrongSizeException;
import ru.novosoft.mdf.impl.MDFObjectImpl;

public abstract class MDFListImpl
implements List {
    protected ArrayList list = null;
    protected final int collectionId;
    protected final MDFObjectImpl owner;
    protected final boolean isUnique;
    protected final boolean isComposite;
    private List ucopy;
    protected MDFListImpl parentList = null;

    public MDFListImpl(MDFListImpl l) {
        this.owner = l.owner;
        this.collectionId = l.collectionId;
        this.isUnique = l.isUnique;
        this.isComposite = l.isComposite;
        this.list = l.list;
        this.parentList = l;
    }

    public MDFListImpl(MDFObjectImpl featuredObject, int id, boolean isUnique, boolean isComposite) {
        this.list = new ArrayList();
        this.owner = featuredObject;
        this.collectionId = id;
        this.isUnique = isUnique;
        this.isComposite = isComposite;
    }

    public final void internalAdd(Object o) {
        if (this.list.add(o)) {
            this.owner.internalElementAdded(this, this.collectionId, o);
        }
    }

    public final void internalRemove(Object o) {
        if (this.list.remove(o)) {
            this.owner.internalElementRemoved(this, this.collectionId, o);
        }
    }

    protected final List getCopy() {
        if (this.ucopy == null) {
            this.ucopy = Collections.unmodifiableList(new ArrayList(this.list));
        }
        return this.ucopy;
    }

    protected final void checkNotNull(Object element) {
        if (element == null) {
            throw new NullPointerException();
        }
    }

    protected final void checkCollection(Collection c) {
        HashSet set = new HashSet();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof RefObject) {
                RefFeatured container = ((RefObject)o).refImmediateComposite();
                while (container != null) {
                    if (c.contains(container)) {
                        throw new ClosureViolationException(o, this.owner.refMetaObject());
                    }
                    container = ((RefObject)container).refImmediateComposite();
                }
            }
            if (o != null) {
                boolean isContains = this.list.contains(o);
                if (this.isUnique && isContains) {
                    throw new DuplicateException(o, this.owner.refMetaObject());
                }
                if (!this.isComposite || !isContains) {
                    set.add(o);
                }
            }
            this.checkAddedElement(o);
        }
        if (set.size() < c.size()) {
            if (this.isUnique) {
                throw new DuplicateException(c, this.owner.refMetaObject());
            }
            c = set;
        }
    }

    protected final void operationStarted() {
        this.ucopy = null;
        this.owner.checkExists();
        this.owner.operationStarted();
    }

    protected final void operationFinished() {
        this.owner.operationFinished();
    }

    protected final void checkAddedElement(Object element) {
        this.owner.checkAddedElement(this, this.collectionId, element);
    }

    protected final void elementAdded(int index, Object element) {
        this.owner.elementAdded(this, this.collectionId, index, element);
    }

    protected final void elementRemoved(int index, Object removedObject) {
        this.owner.elementRemoved(this, this.collectionId, index, removedObject);
    }

    protected final void checkInBounds(int index) {
        if (index < 0 || index >= this.list.size()) {
            String msg = "index = " + index + ", size = " + this.list.size();
            throw new WrongSizeException(this.owner.refMetaObject(), msg);
        }
    }

    protected final void checkWideBounds(int position) {
        if (position < 0 || position > this.list.size()) {
            String msg = "index = " + position + ", size = " + this.list.size();
            throw new WrongSizeException(this.owner.refMetaObject(), msg);
        }
    }

    protected void elementSetAt(int index, Object removed, Object added) {
        this.owner.elementSetAt(this, this.collectionId, index, removed, added);
    }

    protected MDFListImpl getParent() {
        return this.parentList;
    }
}

