/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.ext.undo;

import java.util.ArrayList;
import java.util.TooManyListenersException;
import ru.novosoft.mdf.ext.MDFOutermostPackage;
import ru.novosoft.mdf.ext.undo.MDFCheckPoint;
import ru.novosoft.mdf.ext.undo.MDFUndoManager;
import ru.novosoft.mdf.ext.undo.MDFUndoableAction;

public class MDFCheckPointUndoManager {
    private MDFOutermostPackage repository;
    final UndoManagerProxy proxy = new UndoManagerProxy();
    public static final int UNDO_POLICY_DISABLED = 0;
    public static final int UNDO_POLICY_ENABLED = 1;
    private static final int UNDO_POLICY_UNDOING = 2;
    private static final int UNDO_POLICY_REDOING = 3;
    int undo_policy = 0;
    int currentCheckPointPosition = 0;
    boolean addingUndo = false;
    ArrayList undoStack = new ArrayList(1024);

    public MDFCheckPointUndoManager(MDFOutermostPackage rep) {
        this.repository = rep;
        this.undoStack.add(new MDFCheckPoint(0, this));
    }

    public synchronized void setUndoPolicy(int policy) {
        if (this.undo_policy == policy) {
            return;
        }
        if ((this.undo_policy == 1 || this.undo_policy == 2 || this.undo_policy == 3) && policy == 1) {
            return;
        }
        if (this.undo_policy == 0 && policy == 1) {
            try {
                this.repository.addUndoManager(this.proxy);
            }
            catch (TooManyListenersException ex) {
                String msg = this.repository.getLocalizedString("MDFCheckPointUndoManager_AlreadyRegistered");
                throw new IllegalStateException(msg);
            }
        }
        if ((this.undo_policy == 1 || this.undo_policy == 2 || this.undo_policy == 3) && policy == 0) {
            this.forget(this.getCheckPoint());
            this.repository.removeUndoManager(this.proxy);
        }
        this.undo_policy = policy;
    }

    public int getUndoPolicy() {
        return this.undo_policy;
    }

    public synchronized MDFCheckPoint getCheckPoint() {
        MDFCheckPoint rc;
        this.addingUndo = false;
        if (this.undo_policy == 0) {
            String msg = this.repository.getLocalizedString("MDFCheckPointUndoManager_UndoDisabled");
            throw new IllegalStateException(msg);
        }
        if (this.currentCheckPointPosition == this.undoStack.size() - 1) {
            rc = (MDFCheckPoint)this.undoStack.get(this.currentCheckPointPosition);
        } else {
            this.currentCheckPointPosition = this.undoStack.size();
            rc = new MDFCheckPoint(this.currentCheckPointPosition, this);
            this.undoStack.add(rc);
        }
        return rc;
    }

    public synchronized void undo(MDFCheckPoint c) {
        if (this.undo_policy == 0) {
            String msg = this.repository.getLocalizedString("MDFCheckPointUndoManager_UndoDisabled");
            throw new IllegalStateException(msg);
        }
        this.addingUndo = false;
        this.setUndoPolicy(2);
        if (!c.canBeUndone()) {
            throw new IllegalArgumentException();
        }
        int i = this.currentCheckPointPosition;
        while (i > c.stackPosition) {
            Object o = this.undoStack.get(i);
            if (o instanceof MDFUndoableAction) {
                MDFUndoableAction u = (MDFUndoableAction)o;
                u.undo();
            }
            --i;
        }
        this.currentCheckPointPosition = c.stackPosition;
        this.setUndoPolicy(1);
    }

    public synchronized void redo(MDFCheckPoint c) {
        this.addingUndo = false;
        if (this.undo_policy == 0) {
            String msg = this.repository.getLocalizedString("MDFCheckPointUndoManager_UndoDisabled");
            throw new IllegalStateException(msg);
        }
        this.setUndoPolicy(3);
        if (!c.canBeRedone()) {
            throw new IllegalArgumentException();
        }
        int i = this.currentCheckPointPosition + 1;
        while (i < c.stackPosition) {
            Object o = this.undoStack.get(i);
            if (o instanceof MDFUndoableAction) {
                MDFUndoableAction u = (MDFUndoableAction)o;
                u.redo();
            }
            ++i;
        }
        this.currentCheckPointPosition = c.stackPosition;
        this.setUndoPolicy(1);
    }

    public synchronized void forget(MDFCheckPoint c) {
        if (this.undo_policy == 0) {
            String msg = this.repository.getLocalizedString("MDFCheckPointUndoManager_UndoDisabled");
            throw new IllegalStateException(msg);
        }
        int i = this.currentCheckPointPosition - 1;
        while (i >= 0) {
            Object o = this.undoStack.get(i);
            if (o instanceof MDFCheckPoint) {
                MDFCheckPoint ic = (MDFCheckPoint)o;
                ic.valid = false;
            }
            --i;
        }
        int i2 = this.currentCheckPointPosition - 1;
        while (i2 >= 0) {
            this.undoStack.remove(0);
            --i2;
        }
        this.currentCheckPointPosition = c.stackPosition;
    }

    public synchronized void enlistUndo(MDFUndoableAction u) {
        if (!this.addingUndo && this.currentCheckPointPosition < this.undoStack.size() - 1) {
            while (this.currentCheckPointPosition != this.undoStack.size() - 1) {
                this.undoStack.remove(this.currentCheckPointPosition + 1);
            }
        }
        this.undoStack.add(u);
        this.addingUndo = true;
    }

    class UndoManagerProxy
    implements MDFUndoManager {
        UndoManagerProxy() {
        }

        public void enlistUndo(MDFUndoableAction a) {
            if (MDFCheckPointUndoManager.this.undo_policy == 1) {
                MDFCheckPointUndoManager.this.enlistUndo(a);
            }
        }
    }
}

