/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.ext.event;

import java.util.EventObject;
import ru.novosoft.mdf.ext.MDFFeatured;
import ru.novosoft.mdf.ext.event.MDFEventFilter;

public final class MDFFeatureEvent
extends EventObject {
    private final String property;
    private final EventObject event;
    String name;
    private final int eventType;
    Object addedValue;
    Object removedValue;
    int position;
    public static final int ELEMENT_REMOVED = 0;
    public static final int ELEMENT_CREATED = 1;
    public static final int PROPERTY_SET = 2;
    public static final int ITEM_ADDED = 5;
    public static final int ITEM_REMOVED = 6;
    public static final int ITEM_SET_AT = 7;
    public static final int ITEM_ADDED_AT = 8;
    public static final int ITEM_REMOVED_AT = 10;
    public static final int PROPERTY_CHANGED = 11;
    public static final int EVENT_FORWARDED = 12;

    public MDFFeatureEvent(MDFEventFilter source, MDFFeatureEvent evt) {
        super(source);
        this.eventType = 11;
        this.property = evt.getName();
        this.event = evt;
    }

    public MDFFeatureEvent(MDFEventFilter source, String prop, MDFFeatureEvent evt) {
        super(source);
        this.eventType = 12;
        this.property = prop;
        this.event = evt;
    }

    public MDFFeatureEvent(MDFFeatured e, int type) {
        this(e, null, type, null, null, -1);
    }

    public MDFFeatureEvent(MDFFeatured e, String name, int type, Object removed, Object added) {
        this(e, name, type, added, removed, -1);
    }

    public MDFFeatureEvent(MDFFeatured e, String nm, int t, Object added, Object removed, int pos) {
        super(e);
        this.eventType = t;
        this.name = nm;
        this.addedValue = added;
        this.removedValue = removed;
        this.position = pos;
        this.property = null;
        this.event = null;
    }

    public final String getProperty() {
        return this.property;
    }

    public final int getEventType() {
        return this.eventType;
    }

    public final MDFFeatureEvent getMDFFeatureEvent() {
        return this.event instanceof MDFFeatureEvent ? (MDFFeatureEvent)this.event : null;
    }

    public String toString() {
        switch (this.eventType) {
            case 11: {
                return super.toString() + " PROPERTY_CHANGED (" + this.property + "), evt = " + this.getMDFFeatureEvent();
            }
            case 12: {
                return super.toString() + " EVENT_FORWARDED (" + this.property + "), evt = [" + this.getMDFFeatureEvent() + "]";
            }
        }
        return super.toString() + " BAD EVENT TYPE = " + this.eventType;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.eventType;
    }

    public Object getAddedValue() {
        return this.addedValue;
    }

    public Object getRemovedValue() {
        return this.removedValue;
    }

    public int getPosition() {
        return this.position;
    }
}

