/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.mdf.ext.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ru.novosoft.mdf.ext.MDFObject;
import ru.novosoft.mdf.ext.event.MDFEventFilterConfig;
import ru.novosoft.mdf.ext.event.MDFFeatureEvent;
import ru.novosoft.mdf.ext.event.MDFFeatureListener;

public final class MDFEventFilter
implements MDFFeatureListener {
    private final List listeners = new ArrayList();
    private final MDFObject object;
    private final MDFEventFilterConfig configuration;
    private final MDFEventFilter master;
    private final String masterProperty;
    private final Map config2property2object2spider = new HashMap();

    private MDFEventFilter(MDFEventFilterConfig cfg, MDFObject obj, MDFEventFilter newMaster, String name) {
        this.configuration = cfg;
        this.master = newMaster;
        this.masterProperty = name;
        this.object = obj;
        this.object.addMDFFeatureListener(this);
        this.configuration.createSlaveFilters(this);
    }

    public MDFEventFilter(MDFEventFilterConfig cfg, MDFObject obj) {
        this(cfg, obj, null, null);
    }

    public String dump(String id) {
        StringBuffer rc = new StringBuffer();
        rc.append(id + super.toString() + "\n");
        id = id + "  ";
        rc.append(id + "node=" + this.object + "\n");
        rc.append(id + "configuration=" + this.configuration + "\n");
        rc.append(id + "master=" + this.master + "\n");
        rc.append(id + "masterProp=" + this.masterProperty + "\n");
        rc.append(id + "slaves=" + "\n");
        String id2 = id + "  ";
        String id3 = id2 + "  ";
        String id4 = id3 + "  ";
        Iterator k = this.config2property2object2spider.entrySet().iterator();
        while (k.hasNext()) {
            Map.Entry ke = k.next();
            rc.append(id2 + ke.getKey() + "\n");
            Map p2o2s = (Map)ke.getValue();
            Iterator i = p2o2s.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry ie = i.next();
                rc.append(id3 + ie.getKey() + "\n");
                Map o2s = (Map)ie.getValue();
                Iterator j = o2s.values().iterator();
                while (j.hasNext()) {
                    rc.append(((MDFEventFilter)j.next()).dump(id4));
                }
            }
        }
        return rc.toString();
    }

    public synchronized void clear() {
        this.object.removeMDFFeatureListener(this);
        this.removeAllSlaveFilters();
    }

    synchronized void addSlaveFilter(String property, MDFObject obj, MDFEventFilterConfig cfg) {
        HashMap<MDFObject, MDFEventFilter> o2s;
        HashMap p2o2s = (HashMap)this.config2property2object2spider.get(cfg);
        if (p2o2s == null) {
            p2o2s = new HashMap();
            this.config2property2object2spider.put(cfg, p2o2s);
        }
        if ((o2s = (HashMap<MDFObject, MDFEventFilter>)p2o2s.get(property)) == null) {
            o2s = new HashMap<MDFObject, MDFEventFilter>();
            p2o2s.put(property, o2s);
        }
        if (o2s.containsKey(obj)) {
            String msg = "";
            if (obj != null) {
                msg = obj.mdfGetOutermostPackage().getLocalizedString("MDFEventFilter_ObjAlreadyHandled");
            }
            throw new IllegalStateException(msg);
        }
        MDFEventFilter s = new MDFEventFilter(cfg, obj, this, property);
        o2s.put(obj, s);
    }

    synchronized void removeSlaveFilter(String property, MDFObject obj, MDFEventFilterConfig cfg) {
        Map p2o2s = (Map)this.config2property2object2spider.get(cfg);
        if (p2o2s == null) {
            String msg = "";
            if (obj != null) {
                msg = obj.mdfGetOutermostPackage().getLocalizedString("MDFEventFilter_ObjNotHandled");
            }
            throw new IllegalStateException(msg);
        }
        Map o2s = (Map)p2o2s.get(property);
        if (o2s == null) {
            String msg = "";
            if (obj != null) {
                msg = obj.mdfGetOutermostPackage().getLocalizedString("MDFEventFilter_ObjNotHandled");
            }
            throw new IllegalStateException(msg);
        }
        MDFEventFilter s = (MDFEventFilter)o2s.remove(obj);
        if (s == null) {
            String msg = "";
            if (obj != null) {
                msg = obj.mdfGetOutermostPackage().getResourceBundle().getString("MDFEventFilter_ObjNotHandled");
            }
            throw new IllegalStateException(msg);
        }
        s.clear();
    }

    synchronized void removeAllSlaveFilters() {
        Iterator k = this.config2property2object2spider.values().iterator();
        while (k.hasNext()) {
            Map p2o2s = (Map)k.next();
            Iterator i = p2o2s.values().iterator();
            while (i.hasNext()) {
                Map o2s = (Map)i.next();
                Iterator j = o2s.values().iterator();
                while (j.hasNext()) {
                    MDFEventFilter s = (MDFEventFilter)j.next();
                    s.clear();
                }
            }
        }
        this.config2property2object2spider.clear();
    }

    public synchronized void addMDFFeatureListener(MDFFeatureListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public synchronized void removeMDFFeatureListener(MDFFeatureListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public MDFObject getObject() {
        return this.object;
    }

    public void fireEvent(MDFFeatureEvent e) {
        if (this.master == null) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                MDFFeatureListener l = (MDFFeatureListener)i.next();
                l.propertyChanged(e);
            }
        } else {
            this.master.fireEvent(new MDFFeatureEvent(this.master, this.masterProperty, e));
        }
    }

    public synchronized void propertyChanged(MDFFeatureEvent e) {
        this.configuration.handleEvent(this, e);
    }

    public synchronized void created(MDFFeatureEvent e) {
        this.configuration.handleEvent(this, e);
    }

    public synchronized void removed(MDFFeatureEvent e) {
        this.configuration.handleEvent(this, e);
    }
}

