package net.yakclient.web.utils.helper

import org.springframework.boot.SpringApplication
import org.springframework.context.ConfigurableApplicationContext

inline fun <reified T> runAppWithProperties(
    args: Array<String>,
    vararg properties: Pair<String, Any>
): ConfigurableApplicationContext =
    SpringApplication(T::class.java).apply { setDefaultProperties(mapOf<String, Any>(*properties)) }.run(*args)

