package net.yakclient.web.utils.helper

import net.yakclient.web.utils.reflection.ViewUtils
import net.yakclient.web.utils.response.rpc.RpcError
import net.yakclient.web.utils.response.rpc.RpcResponse
import net.yakclient.web.utils.response.rpc.RpcSuccessPayload
import org.springframework.hateoas.EntityModel
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder
import org.springframework.http.HttpHeaders
import org.springframework.http.HttpStatus
import org.springframework.http.ResponseEntity
import org.springframework.web.bind.annotation.ControllerAdvice
import org.springframework.web.bind.annotation.ExceptionHandler
import org.springframework.web.bind.annotation.ResponseStatus
import org.springframework.web.client.HttpClientErrorException
import java.nio.charset.Charset
import java.util.*
import kotlin.reflect.KFunction
import kotlin.reflect.KProperty1
import kotlin.reflect.jvm.javaMethod

typealias ResModel = ResponseEntity<*>

typealias DataMap = Map<String, *>

typealias DataModel = EntityModel<DataMap>

fun <T> Optional<T>.or404(message: String = "Failed to find resource"): T =
    this.orElseThrow { createHttpException(HttpStatus.NOT_FOUND, message) }

fun WebMvcLinkBuilder.withRel(property: KProperty1<*, *>) = withRel(property.name)

fun createHttpException(status: HttpStatus, message: String = "An error has occurred"): HttpClientErrorException =
    HttpClientErrorException.create(
        status,
        message,
        HttpHeaders(),
        ByteArray(0),
        Charset.defaultCharset()
    )

fun throwHttpException(status: HttpStatus, message: String = "An error has occurred"): Nothing =
    throw createHttpException(status, message)

fun rpcErrorResponse(
    message: String = "An error has occurred",
    code: Int,
    extra: String = "nothing"
): DataMap = rpcErrorsResponse(RpcError(message, code, extra))

//TODO Dont use viewutils here, its repetitive
fun rpcErrorsResponse(
    vararg error: RpcError
): DataMap = ViewUtils.view(RpcResponse(false, null, error.toList()))

fun rpcSuccessResponse(
    message: String
): DataMap = ViewUtils.view(RpcResponse(true, RpcSuccessPayload(message), listOf()))

fun createSafeLink(func: KFunction<*>, vararg params: Any?): WebMvcLinkBuilder =
    requireNotNull(func.javaMethod) { "Passed function must be a java method!" }
        .let { WebMvcLinkBuilder.linkTo(it, params) }


@ControllerAdvice
class ControllerUtilsAdvice {
    @ExceptionHandler(HttpClientErrorException::class)
    fun handleHttpException(ex: HttpClientErrorException): ResponseEntity<Any> = ResponseEntity.status(ex.statusCode).body(ex.responseBodyAsString)
}