package net.yakclient.web.utils.config

class DomainDelegatingConfig(
    private val domain: String,
    private val separator: Char,
    parent: ConfigReader
) : DelegatingConfigReader(parent) {
    override fun readString(name: String): String? = super.readString("$domain$separator$name")

    override fun <T> readObject(parser: ConfigParser<T>, property: String): T? = super.readObject(parser, "$domain$separator$property")
}