package net.yakclient.mixins.api

/**
 * This static interface is used to define default priorities.
 * It is recommended to use these but overloading with a
 * raw int would also work sufficiently.
 *
 * You can use priority as shown below:
 *
 * ```kotlin
 * @Injection(priority=Priority.HIGHEST)
 * fun `Your Method`() { /*...*/ }
 * ```
 *
 * @see Injection
 *
 *
 * @author Durgan McBroom
 */
public interface Priority {
    public companion object {
        public const val HIGHEST : Int = 4
        public const val HIGH : Int = 3
        public const val MEDIUM : Int = 2
        public const val LOW : Int = 1
        public const val LOWEST : Int = 0
    }
}