/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.remoteapi.model;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public class ImageDescriptor {
    private static final Pattern IMAGE_QUALIFIER = Pattern.compile("^((?<registry>[\\w\\.\\-]+(:\\d+)?)/)??((?<repository>[\\w]+)/)?(?<image>[\\w\\.\\-]+)(:(?<tag>[\\w\\.\\-]+))?$");
    private final String id;
    private final Optional<String> registry;
    private final Optional<String> repository;
    private final String image;
    private final Optional<String> tag;

    public ImageDescriptor(String id) {
        Validate.notBlank((CharSequence)id, (String)"Id was null or empty", (Object[])new Object[0]);
        this.id = id;
        Matcher matcher = IMAGE_QUALIFIER.matcher(id);
        if (matcher.matches()) {
            this.registry = Optional.ofNullable(matcher.group("registry"));
            this.repository = Optional.ofNullable(matcher.group("repository"));
            this.image = matcher.group("image");
            this.tag = Optional.ofNullable(matcher.group("tag"));
        } else {
            this.registry = Optional.empty();
            this.repository = Optional.empty();
            this.image = id;
            this.tag = Optional.empty();
        }
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getRegistry() {
        return this.registry;
    }

    public Optional<String> getRepository() {
        return this.repository;
    }

    public String getImage() {
        return this.image;
    }

    public Optional<String> getTag() {
        return this.tag;
    }

    public String getRegistryRepositoryAndImage() {
        StringBuilder buf = new StringBuilder();
        this.appendRegistry(buf);
        this.appendRepository(buf);
        this.appendImage(buf);
        return buf.toString();
    }

    public String getRepositoryAndImage() {
        StringBuilder buf = new StringBuilder();
        this.appendRepository(buf);
        this.appendImage(buf);
        return buf.toString();
    }

    public String getRepositoryImageAndTag() {
        StringBuilder buf = new StringBuilder();
        this.appendRepository(buf);
        this.appendImage(buf);
        this.appendTag(buf);
        return buf.toString();
    }

    private void appendRegistry(StringBuilder buf) {
        if (this.registry.isPresent()) {
            buf.append(this.registry.get());
            buf.append('/');
        }
    }

    private void appendRepository(StringBuilder buf) {
        if (this.repository.isPresent()) {
            buf.append(this.repository.get());
            buf.append('/');
        }
    }

    private void appendImage(StringBuilder buf) {
        buf.append(this.image);
    }

    private void appendTag(StringBuilder buf) {
        if (this.tag.isPresent()) {
            buf.append(':');
            buf.append(this.tag.get());
        }
    }

    public String toString() {
        return "ImageDescriptor[id=" + this.id + ", registry=" + this.registry.orElse("<empty>") + ", repository=" + this.repository.orElse("<empty>") + ", image=" + this.image + ", tag=" + this.tag.orElse("<empty>") + "]";
    }
}

